// Written by Mikheil Sukhiashvili (Kartu)
// Feel free to use ;)
var geo = {
	GEORGIAN_QWERTY : {"a":"\u10D0","b":"\u10D1","g":"\u10D2","d":"\u10D3","e":"\u10D4","v":"\u10D5","z":"\u10D6","T":"\u10D7","i":"\u10D8",
			"k":"\u10D9","l":"\u10DA","m":"\u10DB","n":"\u10DC","o":"\u10DD","p":"\u10DE","J":"\u10DF","r":"\u10E0","s":"\u10E1","t":"\u10E2",
			"u":"\u10E3","f":"\u10E4","q":"\u10E5","R":"\u10E6","y":"\u10E7","S":"\u10E8","C":"\u10E9","c":"\u10EA","Z":"\u10EB","w":"\u10EC",
			"W":"\u10ED","x":"\u10EE","j":"\u10EF","h":"\u10F0","p":"\u10F4"},
	langControl : null,
	isIe6Minus : false,
	isIe : false,
	languages : null,
	switchChar : null,
	cookieName : null,
	init : function(arg) {
		this.cookieName = arg.cookieName
		this.switchChar = arg.switchChar
		this.languages = arg.languages
        // Detect if we are IE < 7        
		if (/MSIE (\d+\.\d+);/.test(navigator.userAgent)){ //test for MSIE x.x;
			var ieversion = new Number(RegExp.$1) // capture x.x portion and store as a number
			this.isIe6Minus = ieversion < 7
        }
        this.isIe = typeof document.addEventListener == "undefined";
		
		if(this.isIe) {
			window.attachEvent('onload', geo.doInitListeners)
		} else {
			window.addEventListener('load', geo.doInitListeners, false)
		}
		// Create select lang control		
		ctrl = document.createElement('div')
		select = document.createElement('select')
		select.size = 1
        select.length = 10
        select.length = 0
        select.style.left = arg.x ? arg.x : "10px"
        select.style.top = arg.y ? arg.y : "10px"
        for (val in arg.languages) {
            option = document.createElement('option')
            option.appendChild(document.createTextNode(val))
            option.value = val
            select.appendChild(option)
        }
        if(geo.isIe6Minus) {
        	select.style.position = "absolute"
        } else {
	        select.style.position = "fixed"
	    }
	    if(geo.isIe) {
	    	select.attachEvent('onchange',geo.onChange)
	    } else {
	        select.addEventListener('change',geo.onChange,false)
	    }
	    
        ctrl.appendChild(select)
		document.body.appendChild(ctrl)
		this.langControl = select
		if(this.cookieName) {
			select.value = this.getCookie(this.cookieName, null);
		}
	},
	doInitListeners : function() {
		// Bind onkeypress events
		var tags = ["input", "textarea"];
		for(var i=0,n=tags.length; i<n; i++) {
			var elems = document.getElementsByTagName(tags[i]);
			for(var j=0,m=elems.length; j<m; j++) {
				elems[j].onkeypress = geo.onKeypress;
			}
		}

		document.getElementsByTagName("textarea");
	},
	doSwitchLanguage : function() {
		var n = this.langControl.selectedIndex + 1
		if(n >= this.langControl.options.length) {
			n = 0
		}
		this.langControl.selectedIndex = n
	},
	onChange : function() {
		if(geo.cookieName) {
			geo.setCookie(geo.cookieName, geo.langControl.value)
		}
	},
	onKeypress : function() {
		// So that things work both on FF and IE
        var evt = arguments[0] || event;
        var char = String.fromCharCode(evt.which || evt.keyCode)
        if(char == geo.switchChar) {
        	geo.doSwitchLanguage();
			evt.cancelBubble = true;
		    return false;
        }
        var currentLang = geo.langControl.value;
		if(geo.languages[currentLang]) {
			var ch = geo.languages[currentLang][char]
			if(ch) {
				if(geo.isIe) {
					var range = document.selection.createRange()
					if(range.text != "") {
						document.selection.clear()
					}
					range.text = ch
				    evt.cancelBubble = true
			        return false
				} else {				
					// it migh tbe selected, then we have to replace stuff (happens automatically in IE)
					var v = this.value
					var selEnd = this.selectionEnd
					var selStart = this.selectionStart
					this.value = v.substring(0, selStart) + ch + v.substring(selEnd)
				    this.selectionStart = selStart + 1
				    this.selectionEnd = selStart + 1
				    return false
				}
	        }
        }
    },
	setCookie: function ( id, value) {
		document.cookie = id+'='+value+';path=/;expires='+this.cookieTime(365)
	},
	getCookie: function( id, defaultValue ) {
		var re          = new RegExp(id+'=(.*)');
		var value       = re.exec(document.cookie);
		return (value) ? value[1].split(';')[0] : defaultValue;
	},cookieTime: function(days){
		var now = new Date();
		var exp = new Date();
		var x   = Date.parse(now) + days*24*60*60*1000;
		exp.setTime(x);
		str = exp.toUTCString();
		re = '/(\d\d)\s(\w\w\w)\s\d\d(\d\d))/';
		return str.replace(re,"$1-$2-$3");
	}
}