﻿// ==UserScript==
// @name           iForum
// @namespace      http://forum.ge/
// @description    გაფართოება Forum.ge-ს მომხმარებლებისთვის
// @author         Beqa Arabuli
// @include        http://*forum.ge/*
// ==/UserScript==



var _FORMAT_TOOLBAR = {
	_BLOG_AREA: undefined,
	_BLOG_AREA_ID: 'blogarea',
	_WRAPPERS: {
		'_BOLD': {

			'start': '[b]',

			'end': '[/b]',

			'text': '<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAACXBIWXMAAArrAAAK6wGCiw1aAAAALXRFWHRTb2Z0d2FyZQBDcmVhdGVkIGJ5IGZDb2RlciBHcmFwaGljcyBQcm9jZXNzb3J/w+1fAAADmklEQVR42q2UT2zbVBzH37OdOHHipEmTNKXtuqw0WpNurcoGCDr+TUxjCI0xIcRhEr0gDj1MHCYhDgjtAEjALjsg9UqFxB8hTdqAaIxKTIzQZW1IoelU1kZjatfSJqnjJH5+f3julrRVOnYYX+knPz/bn9/fZ4kxBv5PSbWFpmmOlXzBxx0I2zmhhDDIKHa7YNXbFCzLDhVDCBveqwNTE5Px0cTlIdPb1sGcqo1SBjEmgHDDBDPDMBlA5UrIg1bi4WDm0MCeC7FYbE6SbFu814HR7ofnXhdtoz+mZ4+POzrexM4m1agYwLUwNbVXZRcLDAUnaOjApO5pT0wVtXMzqVdPHa6cPjK476Ig1jEbwIdaW1e5XVn+O+eZyJdew4pfBTylsBNkh18a/CDkkgojiatvfZzRPyzLTd4J5H7qbCJzcl8kmArv6Mo3AGuyiwIGjPGSUUAp5UsGoSgCJdSBnu4v/fT577/c+Iu64owy8EdRjP+azva9vKNr7J5AHhRcr5tVP0LA5gbJolCVGSlbe5YZBNh0A7s3f98AtIQxBqZpApNDeXP41wAYlbKYup7rv2XKESow3nXMelTzz/09O9P3BVog07xjxeKaP3Fp7EBJUMJfTq8NrTnbmgU9b/SyxWvDg9FPunviN+8P5CADmVbabI54ej9LLb6zJqjhojPcQqoabNXncy/Gvd88sjuSgcJWxDZAyIEYIA4k2AShymL2lag8wlxu9bvZhWNJEHhuVtkd/Si9+H5OuxR574T9dGdk1+3akG8DZBtAE8OAr2np+NGDibbW8PJjqcnkqa+vnUlWA4NVZ9D11U3tRPO3Y0vvvuH91NccKN0DyCPkkRkIA8qvRCTrriW7zAZ6ezLPjE//kErr+5FNdeqiW/0+O//C0D/50f8AAmbVEEHzDtBO6w8EUSSKCDSRT2ltD1Fo5yNZ5zQA+YzA9ZTBXaBI2fo2l67r7rk86kaiIlv3kGIWDcgzPrdjpQFonQqMkLCqVTylqmkzqAkYD6RAkT93a6GjUjXU88npw+fnyTEiyhIkiPa5Cqnh52Mj4ZbwagNwOjuz88LP4wcTM6tHi8TvJ7yGltK64/G3v/jtDDORdL2i7ClLHsVXvb30aAu8fPJI7OyhJ58YE2y2GmYDaCAklctl2952b7K3U7rKp/Huz07lCVuni7FnCTrXHlCWo51dN+K72rO880ubYVuAA/19s5aBB9S2J+VB9C/yOOMCfFO0WgAAAABJRU5ErkJggg==" width="16" height="16" />'

		},
		'_ITALIC': {

			'start': '[i]',

			'end': '[/i]',

			'text': '<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAACXBIWXMAAAsTAAALEwEAmpwYAAAALXRFWHRTb2Z0d2FyZQBDcmVhdGVkIGJ5IGZDb2RlciBHcmFwaGljcyBQcm9jZXNzb3J/w+1fAAAC0klEQVR42q2UW2sTQRTHz87sZttcNklN0ss2NL0qqYoPihUUERFF/AIivgg+CoKfwE9QH/0E+hEKgm8qvUhRaS0KQpu05tqkuTWZnZ0dd2K7zaaYPtgDu+zZnf3N+f/P2ZU553CaIXcmjDEwTdPJqWl69qq1IWbx9jruPkGfR2kORiMZSZKcd1zAVqsF2UzGyXdyhbG375de1vwjI6bHjym1N2QmMGIArueb1xPBhedPHr5SFMWR6QKKnRTl6BaWeEb3wvwWNx5/YrFnxKRACIUkLny4OR6eP6PCd97lmQso5FYrVSeXuFWf1mMrxQy5A4eqaJPfP6u9uTE+trCdTkN3uD20gY1Gw8kRwqDro8purnCJWxws+xig5eyQN7JqywE9Pgqd/h0D2l5AMBRyLcjmC2O7KDjDTAsse8OZoPQ55pNTAuTzBXoDLcsCwyBOLtxZ3ynP5Vu+UbsVgIw6mY7ipWAgUBCgbthxIBdAw8kJMbw/KuxKxcRhAQwjM3cuJC/LityeLYQQdMexCgk5qjBXrukbRXKNIIxEw6KysTUd11fxAUhCJ1QomqCqqpOXjXriV0O+QPvEwDNIBOh6UNN2D5Ui6YQKhYRO4GapebmONZUZFHirxpJJbbHTt5M9FE0hxuE1/prdv2qYXkl8khG6V0hEpjYQcgO7mS4gt5tC7C6L4c/kizObdTRB7OoYpXxS48sqa6ZLpZKz3uf3w4ilA8b/AFrMgnqtBqHwAPwsNue2ayxuAAWFNuj5qLoSGQjlZVl2pKoetfccCmni58AAD60W4G7FVDQLcdBkqzSsGGvpVIolZ2fB4/nrs/C7J7BJjNC3rfyttS/F2x/3Yw8sHGi3kYDcv5gq3cvnC2xicuqdhFB7trCMoft/6u4ylr3DejyhDnqqF+X+184DrnCFeWgirISjsSjDB6aJTxWhHhXG9eHfL54+mof/CBfwNOIPZ7RRC/V/gG0AAAAASUVORK5CYII=" width="16" height="16" />'

		},
		'_UNDERLINE': {

			'start': '[u]',

			'end': '[/u]',

			'text': '<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAACXBIWXMAAArrAAAK6wGCiw1aAAAALXRFWHRTb2Z0d2FyZQBDcmVhdGVkIGJ5IGZDb2RlciBHcmFwaGljcyBQcm9jZXNzb3J/w+1fAAADR0lEQVR42o2US0wTQRjHZ1/ttvRFS1taIVJeFRUBJQImiigaY2LwAtF4UI6acDMaYyKJB+7cPGhMvEjiwaOPxCgFIwgCiooVRVoeFYGFltputzszzhZf3Rb0f5jZzPfNb//fN7PLYoxBJBzm+/t8VYKwnEeBTHEabbx2b91rm9Ua6/f1Vq+urlgB9Scz3+Wa2X/g4BuNRgNYZUEU49pPgdnK8cVY84zBUwdZnUaWIUDxqOiMBsYcTHzEabcHOA2HBib81W/mY4feipY9DEbxXdrw4J6CpQd1DQ1/gA67I9zRfubmi9Gx8a5Xaz3QVeHGUhLwy9NTp7ez3Y2N+/u0eiPWcCy4dL79xtjQ0OCFe+9vFzhts93nTlw0mHIFPseYcpsCApoGlN4EjDZXGIsLEUyWEBk4AGM2i3nRmufEv8vn7Djf4Q7lJgem7Zx5bktxmQD+EgvShAGCECGIgdJbZWBoCgGV4iJEwmpCLgYYqmPpQMKAEFJK/8gMMMLZzuhnLqYwwECtNKASJgaBDBUgBsQrABsh1yvIWM4oWXGWTMoAKi5RRrUpKe9QWpKFpwauO0wBCZj0czOD2XiqkkmG/MshmWWIsu0BGo4COTxNAZRZgtohJg6xJMmpXKXsbE3keY4xm3lyq8ibVUoDMqRIRpZEKZnEGCFKkhGdRIhRb4pCmp9PsLlVOiqsjqUBTXpt1G3mQ4GERI6HAiKitSJmzepN38gXuQR5T6HdMqeOpQHz8uzC3kKT76VfOBzjzKZliXE8exc8Wumd9rsLCoVkQqJnZgKuu71vT+VqaaG2ZtfYpkC9wSi1NVb3DAZ9DU/WuNYwpTXeer/SMRd55K4tcQxHopLRNxFoDEaoksvHvF27d5SNbwpUVFRS/rWzDV8rfTrqfz4nNc0ngPPxVKL5qd+/z2rgo1stOcHOlrKrLU31j3Q6vfRPIEX+c1U7tvl3ekuvBacm8yc/fvAsfTcbGHIBSosK5su85V9MFltio08oBewdGK6/N/C5FdPsBveYTo2+hRAAg6GMqFNPLZxtrrmztcgTSgEDwdktD/uHjyCGy0j+HxVbuKmTtZ775HEduLuiZOTK8eXrG/8JNpfRYIg4Xe4F5fkHeyKPw+SwCzIAAAAASUVORK5CYII=" width="16" height="16" />'

		},
		'_STRIKE': {

			'start': '[s]',

			'end': '[/s]',

			'text': '<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAASCAYAAABb0P4QAAAACXBIWXMAALSMAAC0jAECTCg/AAAALXRFWHRTb2Z0d2FyZQBDcmVhdGVkIGJ5IGZDb2RlciBHcmFwaGljcyBQcm9jZXNzb3J/w+1fAAADj0lEQVR42n2Tf0wbZRjHn7vSNmuB3lpb6bQBlDItyGi7sbEJnR3YhcYs0ejC0GTJkrK/XU3800X/MIs6E7MYwmB/mPDHjIvJsjiZyxLcD36sc9C4DRmM0ru0YDna3h1t7fU93yulAdf6zX3zvs/73vPJve/zXAX8j9RVJs3Jz0YYSw1FgSSBkPpHGvjyzF52fvxBuZyKchuyTLa3PnjTXk+tJLMgIgTWGgPR1P6O7/f58dPlcsoCCVIB7p73+7kMggSfgtiaIGVFPeHu6uqdvPqdP5OI8qXyygKpWkeLo6Vxf0LIwsJihKbDS9NmU4fXbNpZbba5exfvjQyWyisLtO476qusrCTSyTTcH/tliGVmJ9oP7PMuI8Bf/p7v0sTlQQmJz+WVBMrF6Or29DFsCuJsXKRnRodSbJhZXGIWLbV1dY3WV51UndOxtjDxXHHyQEKhBBJ7U6bXDx+37DJSa+sIgjMz11NrdFhef3D7xsXd1v4vcqSSsB3o6R+ng/2bORLKARIzG8Bmr/8rV1fPRuWI/KP6K7QKBJ7Ymt54u+mbX3kCBzhUrPMckHjucntOHXZ7+kgyvw6B4Fzg2vkPXXlgMkZHph8G/sStBqRKqzcYTQ0iviuBFxLJ1eishDcQ3pNHpYZ6mdIbduG5gkvEuTTPLsmMNMfOF48cuvvD17LleeuxTy54uw82SJgw9P235+duXTwLW2TY7fKc8p+7HhMIEJQCc3n40/1bi7OtKKpKo/ZQ55G+aDwLFSIHYg5VmVuOfrz1HYVSQ0ajKxnQmtVmyysOnWWPMx4KBEoCDQ3tx1+sqdHFcMvqqRfg5Gn/GVQ4LkLyiI2vQo6X4xkQcmrCurfbNxUKFItTBMp/hqPT60umCahW54BdjRXvTb5bVBw31nRqNTyLSWCzd/TOjA77M9wKtw1Y9VJzq7XxtTYuJQIdmQtdGz77Lm4FCcqo2f3R51anx6usMFQZGw+eoAM/D2wDWppdPpVGRyhyCEZv/nSJizwOQr6DipYlbfrxnSsXbI4O79+cGvYc6vExf1wdkHsxD1SodlTb2zpPJNdzkOWXRTp480e8rJO3sMmCZaGCc4nw9CSz8OiZvs5Zr7U02LXG+jZ++elkHrjDUNs6G5y6q1Y9JKLhp4+yAhspwMpLQijw28g5q505JkcavaWlCOQjT8amrjwZg42jkf8ZSx4ZG8Xmbg9iDxTivP4FmTyelgB2EuIAAAAASUVORK5CYII=" width="16" height="16" />'

		},
		'_KILLER': {

			'start': '[b]                                        ',

			'end': '[/b]',

			'text': '<img src="data:image/png;base64,/9j/4AAQSkZJRgABAQEAZABkAAD//gAmQ3JlYXRlZCBieSBmQ29kZXIgR3JhcGhpY3MgUHJvY2Vzc29y/9sAQwAFAwQEBAMFBAQEBQUFBgcMCAcHBwcPCwsJDBEPEhIRDxERExYcFxMUGhURERghGBodHR8fHxMXIiQiHiQcHh8e/9sAQwEFBQUHBgcOCAgOHhQRFB4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4e/8AAEQgAFAAUAwERAAIRAQMRAf/EABcAAQEBAQAAAAAAAAAAAAAAAAcGBQj/xAApEAABAwMCBQMFAAAAAAAAAAABAgMEAAURBiEHExQxYRJBUUKBkaGx/8QAGQEAAgMBAAAAAAAAAAAAAAAAAQMEBQYC/8QAHhEAAgICAwEBAAAAAAAAAAAAAQIAAxEhBBIxIkH/2gAMAwEAAhEDEQA/ADfTdrkRI1v6aSyhx0rcU44nPLAV2x843+9VT9SQTNShZQVH5GPRVyv930/HkwZURDrb6mXytsqSpA7FPvRryYjkKqt9CQvE+wXW6azly47hUkpbSeWsABQQMjfz/aYK2bYil5FdY6tDR27JRbo7kGV1CUAtLJzsckA/OMY/VBq94MfRfhciIPDy63KHp/KLxHWwhYX043V3ztgbfmlHXke4Vvo7mnC4g6F9Lrj10CH3HVKd9UdwkqzjOQCCMAVYVgquJnrwz2Ejyc5w5LsdZ5SsBRwQexosob2d12snku13KZb9AmTGeIckOGOon6Ukb48+d6jpWpeTrrWFYkIokGpUriZ//9k=" width="16" height="16" />'

		},
		'_URL': {

			'start': '[url=]',

			'end': '[/url]',

			'text': '<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAACXBIWXMAAA7EAAAOxAGVKw4bAAAALXRFWHRTb2Z0d2FyZQBDcmVhdGVkIGJ5IGZDb2RlciBHcmFwaGljcyBQcm9jZXNzb3J/w+1fAAAEDUlEQVR42o2UW0wcZRiG/znteYalhS5LQaCwiIuAGyw0hVgIpEUJxUqlEkyVctFa2nBlYmLRC5PGlCtNimkvPLQSwqnGLaAslpBUKLssRcTS4QwtoWwpi3sAdnYO6/+vipqQXd+LyWTmnyff973vfCTYRRHaSAAwDLg2nLu9Diny7xscx0FufqGu+PWqWm2UPtvP+/nVpZlB653bzWOjI07O5wvF2VEQiGDv1r1fXFhxpgMjKEaQAkAQJRCZkF75nKnw0oGur2vMbTd6vB5PON6fwJy8At0rJ2o6JIxk/BwvOhbZaUEUfcx+QzqQq6MzSmvbtr2uo+aOliFRFMMDC8pO1Uo4ycAuxeHOpoaHv9iuuVwu3/PpWS+ZKi7eIpSMLulwWaNh3F7EsmzI3kmaYQC9NyabEyTgWGCnEWx4eHjDmGlScZxv5ZHd0hCXV3FdFZuak5B0IBEC2ZBADGCA8/t5BPQLgs/tdm8j2IWPP+ulVHTqUE/LhzycJxwroaK1cfCb0EC32wUc0E1NfHqlKiY53QBpBEm5KXpPJk4paFPJ21cX134HuFwdkHjOGwoWBKLL2EB3c0xW4SVcoY42lp/vXB2785H1x9ZPMorf+hQjZNS+yAgwOzm2pN27T17fcOUcJZPJH8+x4+O2n+9Nsw85SfrHqCBwfMzuTOz9psZQcqYNUzAxukMnrouSBOafrAF91B6YKxLEJxtjozMy+zVMBIZilXq4FLz8WvXsSNeNsz981zrg8bgDO0CO40BPR3NP0Zb7aFxuWaNCb8iRAEbAyARmHtx/FG/I2B8gFbInWzxgfE8FiqS2CaVGQ9JRKdlv1HUDEDj+fdu3P6Hw7/wpXq8HdHW2Dhl+vV+E3FRqtHGS4PNGREbLmReM/es8BiRAgBU3t73cf+0dhVwpGYqqvyDVWn3ykTebsqYmDtqsVtcOEAmFFuXsr2gE3Xzvg8vn1IwW23Q4RCeP87iSoXX5VZ9Ptl8xbXZ/dTrrZL2F0upTktIyj9hHRsz/Ae4mkqLkfhgpaMTWiuXL+qi8U43rI+ampcVFj+Pps7tpZdwmICiNQqsz0TQdHrg8PzWecKgUADmcGY5tsK2XMxcXFtbn5ub8uQXHYiWMUErQJFHw88ECwgEnRwfvvXiselbGRKUkFFQ1bVlunlauOe/mFpbE5lZebIHFE6LIi9trj20euDzCAmemp7gHvTfPGo+f78ZVWn1a+QVLyqvcZgAnlSgJKEIudrBvfoa1SjBqYYHokMXcPoBjoDwu/+RVZICEUxopANuElbnZob7V0d66iYmJ4G4LC0SCezBwu725L2v6t4OJ0E0ZNECCM+OeLdtQZQgmCELw7P8CIqHw22w2l91uNyM30TM0M9TBv/UH9p7nCHKWy2cAAAAASUVORK5CYII%3D" width="16" height="16" />'

		},
		'_SIZE': {

			'start': '[size=7]',

			'end': '[/size]',

			'text': '<img src="data:image/png;base64,R0lGODlhJgANAMQAAAJEjc/c6kFyqYChxv///yFbm6C51GCKt9/o8RFPlLDE2+/z+DFmonCVv5CtzVB+sMDQ4gAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEHAAQALAAAAAAmAA0AAAWpICESCGACyKiubNsOJzC4dL0WcVEn5mOzARPPFHApYouf6mA64AAHF/NkaDUEAtZQ0RC2Fj0egwU2KVQGb9BUXaUBhmlK5Tj5Ro+m6HlXCUwLRzIrDFCAIiUxinOIJgwQECY6I4kIOG11ijEOdJpEIzAJA4VZBIUAAgOqA09jI09YAqdRe5oIawBFI5m5Imt9BDwJviZzOA5dAJOUJw0iyW0iU2ddrgTVIQA7" width="16" height="16" />'

		},
		'_CODE': {

			'start': '[Code]',

			'end': '[/Code]',

			'text': '<img src="data:image/jpeg;base64,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" width="16" height="16" />'

		},
		'_FONT': {

			'start': '[font=times]',

			'end': '[/font]',

			'text': '<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAACXBIWXMAAA7EAAAOxAGVKw4bAAAALXRFWHRTb2Z0d2FyZQBDcmVhdGVkIGJ5IGZDb2RlciBHcmFwaGljcyBQcm9jZXNzb3J/w+1fAAADEUlEQVR42pWT30tTYRjHv9vZOft1ltmmpWfO2ZaTOSylH0QEhV5ZrPJKujLw2gv/A6FroYvo1jvBIkh2Yxh0IUoQLtpGRZmC5KalnrnN/Txb7/u6Mzd1Rg88vOc97/t8np+vDofCT0xMvLDZbE2lUglUi4oCpViEQtZsNotkMpkLBALPwuHwAuqIrurb1N/fP+hwOFoYjICoFgoFBszn85BlGT6fb3BycvLB8vLy/L+AmrKgWssHbLVYLDRy09TU1JuRkRE/gb47DVgxLBZLlb1GoyVaglbLgeM46A0GSJJkmp6enh0eHvYHg8Ea6BGgltVudm4BFpMAo1GP6JYMgdeCQwlyIkW8ZTEzM0PLYRobG5sl6ftDoVAFWgPkOC1S6Sw8rla4OxyggQbml+BySvC4nfixsgY5LhNoAblcjkHHx8dfjo6OXiR1lk8AcjAbDfB63NDr9Vhbj7K07a3N4HkBNqsVdukCSV/LmkUbtbe3d5bYWU8EqtBCQcF+Ko2V1V/4FFlBbHMbosmAeDINHclCCwWpTAHdne240euhhedU+xogz/OkkyLUOdzcltEo8vAPXIXBYMTT569wu8+Fu7f6sPQxBJ5gzGZzpZnHgDQVGiGFyfEEUvtp3B+4Ca/Xi2D4O/t/7YoXdnsbLqfzMBkFCIJQjTgOVOcvurVDataILk8nc/L5y0+cEQ1wtLWyge+81FEZ/rpAFUoj2Yj9wbkGEaJ4kBIFutqayV5kDqgUy8/yVCCFxX7vYIvUr6W5kY3O7k4cO3IC9+70sjqr96jzo1IDpJeSyX3Ed3fhc0vEQIONjRhCX1fJ6OXRLp1n56BNwwFQEPj6QHqhocHCVHVA5fXcIhxSE5xOB3k9xsp/dRrqdlmFqgb0YoJEFPm2hus9LgZTm6aCaB3V+ycC0+kMG2ziH9ukdm/fL6Kr3YpcJoPFD0H0dHugYafEWMeRmtYijqVsNpsqHumQP3n8kH2rEel0unIND1OuB1Qikcg6eZu1cwDUGFXXr7wqRPPqeTUwNTQ09IisRvyfUFhU3fwFV/x+t7Mnhi0AAAAASUVORK5CYII=" width="16" height="16" />'

		},
		'_COLOR': {

			'start': '[color=red]',

			'end': '[/color]',

			'text': '<img src="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABQAAAAUCAYAAACNiR0NAAAACXBIWXMAAAsTAAALEwEAmpwYAAAALXRFWHRTb2Z0d2FyZQBDcmVhdGVkIGJ5IGZDb2RlciBHcmFwaGljcyBQcm9jZXNzb3J/w+1fAAAC30lEQVR42qWTW0gUYRTHz+x8o7uzN1fctfI50ojESnvKt5B6yQoxonuCQQWBpEJPEQoFvmxZQhnaEoSWEasWaLj6UBZeInHLaNVwRx0v6257mdHdnWlmYHVGZ7egP8zwzbn8vvOd7wzas2unNxQKWrOsVookybVwOGxYWlzcZjKZ/JbMzKV4PK6Zm53NicVi6RcuV+y2ZFh+wCaNjI7CT88kYBgGSEgMV92sPmjLzqYKi4rgxvVr5QLwxfYdOa0PHjVV6UgSBvpdZMfL9ldpRJpBq9MqYPP0AngmpySYKHS4pKQ5v6CAoigv3KqtAa93RnIwTATu1tdBReUVEMqPlJ86Xet2j1tIUr8OGxsbgw8fBxUboJIjRxs5joMBVx+IULlYlgVHawvcvlMHPM9/3bf/gNZoNEIoGIS29jYY/PQZNks6st/vB/f4+BanKP/KCty32+FYaSmv1+sZh8MBTqcTotGoajwSX++6u8QKVAMwTANDw8PQ09sLGo0maVxCyOfzwejIsKpTTMY0uLhMF9AEx6WGiUJvXnek3HWOpmF1lbhX8Tt0VYCu27/ojMBcZEGeSk/qefTNrd47uQjgseK1FZzHNoAhLQ7B/KBwjA1bPKrhkBrgf4TEkUlIbHpKqbZGaUP2xiZpEQ6HoLurE6Y8HvzX9DSYTGaUm5cH/uAQBCAOA2f0itwJioT3zlKFjaN9gAwGg/SB4zjk5uZh1MzMIfGbZZnCrCwrce78uejj1idwqXpCkYw6MXi4cBbkRmN0CFBiZGh6PrvlafPxSCQyZbXZagKBADx3PKs8UVbWJ7vcv2r9UoTRoQmCaDKbzYoAl6t/c5tSKuktSwzhLwlHGGCFwam3Fyj836czYC/WDvLdYstLyYEiTHoEsQwBjoZihTstIwA9JxtgY0YA3kZs6kBeguFbHfJeYonalA1WABPHVIX9o5QVJq2M5zkdIz8dxFEMBpctivvyhPTcH9j2LpKSEqkIAAAAAElFTkSuQmCC" width="16" height="16" />'

		},
		'_IMG': {

			'start': '[img]',

			'end': '[/img]',

			'text': '<img src="data:image/png;base64,/9j/4AAQSkZJRgABAQEARwBHAAD//gAmQ3JlYXRlZCBieSBmQ29kZXIgR3JhcGhpY3MgUHJvY2Vzc29y/9sAQwAFAwQEBAMFBAQEBQUFBgcMCAcHBwcPCwsJDBEPEhIRDxERExYcFxMUGhURERghGBodHR8fHxMXIiQiHiQcHh8e/9sAQwEFBQUHBgcOCAgOHhQRFB4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4eHh4e/8AAEQgAFAAUAwERAAIRAQMRAf/EABkAAAIDAQAAAAAAAAAAAAAAAAQFAAMGB//EACoQAAEEAQIEBAcAAAAAAAAAAAIBAwQFEQAGEhMhQQcVMmEiIzFVgZTS/8QAGQEAAgMBAAAAAAAAAAAAAAAABAUBAgYD/8QAIREAAQUAAgMAAwAAAAAAAAAAAQACAwQREiEGE1FhkfD/2gAMAwEAAhEDEQA/AO0wKIir4Ss18dGyjNKOIwY9A+2nNcV/WOQGrP2nWva7i45qjddBkC6UB6tmiy5ynVZabLlnjPCvTVoH1JemtCHMs+a2QkBIt7U8JuZCR+uicxYiKq8gEz8w8dtK7nrEp4gYn1ASmEGTs/lN3PEFqsgRK5mCjpsxWgMnDwiryx7JrM3fIZK7zFHFyzrUDYthshakO392w6MJLddSwGQkvK86IkXxEv57aWxeSXIzjYv79IGOaGJp4tzUZui387cgWCtC0pxMcKFlOjh60dO465EJXtw/E8rS+yMOV1FveaNJXiVRTOKkVpOI45Kq4FE6rxaJ6PeIgxMJJIRi75m/ZaP9Uv6104AgEqRBH8WF8RN5WL1ywqQ69pBjCKC20Qp6iX6cXvqRG34rNAAwL//Z" width="16" height="16" />'

		},
		'_QUOTE': {

			'start': '[quote]',

			'end': '[/quote]',

			'text': '<img src="data:image/png;base64,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" width="16" height="16" />'

		},
		'_SPOILER': {

			'start': '[spoiler]',

			'end': '[/spoiler]',

			'text': '<img src="data:image/png;base64,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" width="16" height="16" />'

		},
		'_YOUTUBE': {

			'start': '[YOUTUBE]',

			'end': '[/YOUTUBE]',

			'text': '<img src="data:image/png;base64,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" width="16" height="16" />'

		},
		'_OFFTOPIC': {

			'start': '[OFFTOPIC]',

			'end': '[/OFFTOPIC]',

			'text': '<img src="data:image/png;base64,/9j/4AAQSkZJRgABAQEASABIAAD/2wBDAAEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQEBAQH/wAALCAAWAB4BAREA/8QAGQAAAgMBAAAAAAAAAAAAAAAACAkFBgcK/8QAIxAAAgMAAgICAgMAAAAAAAAABgcEBQgDCQECABYTFRQXGP/aAAgBAQAAPwDv4+IB0l2b6nSKTbWp6apz/crKewO0nPSUTlmumLxHYC0+uhRdgJxVNtpOmK7OMfby/a5B16k3pYJkTR6PIxCneNFBjO8imqGwtW3YLnZm3+BhYwUVS5E/4t9aD+qzGGxrzpj7H6exHOBKszH6fBQ85yzaa6qnIhR+cSPJklRtpl8FQemoorBW3jzXDNRcwTg0e98XAQ9kI+BOXQywa2W9PqsJywn7PRTv0WTc2XyBNCeePTg0HzCDmjUaz02faDIx9k8mY2pFExAbRNs26vnhU3sw1yCxrmPI9QAal/i+5NC5atLri2/ZaD0oQEqumYVmvRUyK70pNkoLZxKdaQV4PV9hXtgJCEDxAc37lGD5wKRjLbXFsVWTknldfw8ekZxW1C/LN35H4DhBPm8WjgmPG0T+u1OsKSNDpPUqHDSh21iLG72yDcxvVoRVHzuA03GR5zTgywea/vUFFsQIsN4+kRNHTJR+aQG1u5hJ9e+WKDU2qs36/XcK30BVZvs099FUVu0xw7vl0VtiiuP3de8uVCsBf2YKL+J33dLu9n09UR2/9c3/ACVDNDWkGgBPuLEIq9Crasw6OCCKE7YxAtMQmI8J11dUlQaKhdjsvlITgZMbj2JKiSQElRr6ZBpq60BeeuF7ECjWk72LIxHy09KMBj1Xf6RboK7d1nGf9MEA+wFTZGSwr8mfWs4sJWIpJ71X6nDbNQuF66Tm8TAp2b2AMBr3rLtTkjHLGKt1aKjanDCCru2Rd6/pTrsFXYQIC4XhYPouoy6n7EBSQEMrCumr0aKhfUGA9WoSbJFqMlCI3Gn1obYBBw4sTYlyhticLMzuR4MaCdt6WoI/OQbW6xTHsFyxQIbWTTz+7y2u0BVPTlsjLOj2FUSLfoF0VrSlFlOp8/7oRDtoPx1hHLJbK7b2tXz/ADjEqZfPHqK4StVSGpT/2Q==" width="16" height="16" />'

		},
		'_MYVIDEO': {

			'start': '[myvideo]',

			'end': '[/myvideo]',

			'text': '<img src="data:image/png;base64,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" width="16" height="16" />'

		},

		'_SOUNDCLOUD': {
				
			'start': '[sc]',
			
			'end': '[/sc]',
			
			'text': '<img src="data:image/png;base64,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" width="16" height="16" />'
		},
		
		'_FACEPALM': {
			'start': '[img]http://i.imgur.com/COCWf.gif[/img] ',
			'end': '',
			'text': '<img src="data:image/png;base64,R0lGODlhLQAYAPexAGNPHP/mId6wEO/y9NXUzKeehHtqQGJNGXppP6WbgdTTyuTl46KYfGxTCqeKEdKyFu7MGuzJGc2qFKSDD2pQCdjY0XVjNpp+EO/RHPjbHvrdH/XWHfDOGuS8FpJyDN3d2GlVIMKkFfzhIP7kIf7lIvLRG+nCFrSNDmlUIO/y85OGZbCTEvnbH/rfIP/lIv/mIv3iIfHPGua8FKJ8C5KFY+7x8tLQx29WCvPUHQAAAOvGF9uuEG1QCNHPxaGXe62PEu/MGeK3Ep52CqGWenhnPNi3F+S6FMCSC2VQHenHGc6dC+fEGOK3E82aC9OwFfbXHd6xEL2MCXhmO6iGD9mnDZtxB29UCea/Ft6vENCbCqaCDd+yEdWhC5twB/38/GdTHraPDuW8FOvFF92vEK19B2ZQHNjX0HNhM49tCtmsEOW7FNinDc6ZCYlkB3JfMdfWz2lNCL6QC9WiDNSfC7uKCZpvB2hLCNTSyaOZfndmOl9JFGFOG//lIP7kIPjbHe3KGf7lIfrdHu/NGufFGfHPGeK4FOXCGO/MGOC1E8uZC9GuFfzhH//lIfbXHOvGFtyvEL2NCKeFD/nbHua8E9elDZxyBm5TCfLRGunCFd6vD86aCmRRG/DOGfXWHN+yENOgC+vFFuW8E92vD3JgMpBuCdmsD+K3EeW7E96wD9ioDM6aCIhjB2hNCJ93Cb6RCtWjC5luBwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C05FVFNDQVBFMi4wAwEAAAAh+QQJZACxACwAAAAALQAYAAAI/wBjCRxIsKDBgwhj/funMKHDhw7/kSAhkSHEiwgtKpy4aaJGjCA3WpQIBQrFkCg3UiRpcuHHlA8lUpxIgs/CkyhdukxIsmaAAHxMQnkZ89+PB38iSJiwMGPQnwFIbGkK8t8FDBlatMiwQdAVD0QFSuQToCRVjP9CZBABg0RbERkumQBDdGzJoTlXBGpBkyYMSTGuzPgo8UWAnTlxiDjA+N+LF40POMKiUaZNmApXZKD5uPNESX+CCGEoEy/mf0UCkejMemKLGGqO3KwZtmoSvqtZPyYRCLaS0rWrGtqsezfv0JrGBq+qaENbEoyjM96QZEuUf6YxE/wXQxKMA61hBFw6oIZKlbPaB/67csn7xBduA+EwgSUL+vRitZgQtCFDIP9dmbAFF3UsdxoYVzjyRwwxCOKIGlhwQYaB2i2URhBqqBEEFlRo0gaF+P0jRBxyzEFHgSDip5BOKToUEAAh+QQFLAGxACwAAAAALQAYAAAI/wBjCRxIsKDBgwgTKlzIsKHDhxAjSpxIsaLFiwn/adz4DyNDjiRChuzoEeG/C/9C8lnJZyTJkgP/hUhJ4h9Lli5hxvq3IiUfmz9ZamxZ8+XFoUF/2izqaOhIjP9+pASqkcRPEhkiGBECtObRIkinBiURSFAHV0SWGp34b1AgmylfwLUaKEYQJT7XsjWU4WeAACNb8slwCFGilV6PKtqwyOrfFwFe8FnUyNGOOCv1sv0nKBAMPpv2hN50QFKMSZSqJPb478qlDAdI9NmzZ1GGPSYyadKo858WTIIaNcpAvJMgE1A+1dF8FMwkR4cwHDrkKBQULmSYQ/1XytSkSaagpBJSxVunQY2uXn2iU968yY0eAwIAOw==" width="16" height="16" />'
		},
		'_FACEPALM2': {
			'start': ':facepalm: ',
			'end': '',
			'text': '<img src="data:image/png;base64,R0lGODlhEgASAPcAAAAAAP//////AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAEALAAAAAASABIAAAhfAAMIHEiwoMGBABIqPIgQgICHEBcWdAixYkSCFC1qBIBQgEKNFwN8fJhxo0iSEUF6PImyZUSFCVO6pBgz5kyPJG3atJgxIUucKleK3BmUI8uSII3+DCp0KFOSGJ+uDAgAOw%3D%3D" width="16" height="16" />'
		},
		'_PUKE': {
			'start': '[img]http://forum.ge/html/emoticons/puke.gif[/img] ',
			'end': '',
			'text': '<img src="data:image/png;base64,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%3D" width="16" height="16" />'
		},
		'_MAD': {

			'start': ':mad: ',

			'end': '',

			'text': '<img src="data:image/png;base64,R0lGODlhDwAPAKIAAP///729vf9jY/8AAAAAAAAAAAAAAAAAACH5BAkAAAEALAAAAAAPAA8AAAhfAAMIFEigYMGBCAMUHMCQ4UGEBBw2jDiAwECKEjFWJOgwokeKFjEu7DgxooCTDRmeFFDRJMqUK1sOOGmwJsqRBADk3KnTocKKOoPu3PizZU2QF1MqtQhRY8uEF2smDAgAOw%3D%3D" width="16" height="16" />'

		},
		'_GIVI': {

			'start': ':givi: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhDwAPAPcDAP///729vVn/yMDAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAMALAAAAAAPAA8AAAhVAAcIFPivYMGBCAcUFMCQ4UGE/xpKdDgwooCFDi3+I3jRYceOGy1OHLnQoEmTFyMaBADgpMqX/1i6TJnSpcGLCmvO3JhT502cHH1ShCgyY8KKJhMGBAA7" width="16" height="16" />'

		},
    	'_DRUG': {

			'start': ':drug: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhDwAPAPcFAAAAABgYGBjn////AP///wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C05FVFNDQVBFMi4wAwEAAAAh+QQFyAAFACwAAAAADwAPAAAIWgALCBQIoKDBgQgLDljIEADCAgAYSlzokOAAgxEnOowIgIBHAhklGvzokaPBix1JliQ5ciTIkikxFlwJMqbJkyk/bpxIUadFigpRFhwYkmdFokUpPkSKEWFAAAAh+QQFCgAFACwAAAAADwAPAAAIJAALCBxIsKDBgwgTKlzIsKFDhQQINCQQIEBDAAAeatzIcWFAAAAh+QQFHgAFACwAAAAADwAPAAAIIQALCBxIsKDBgwgTKlzIsKHDhwsJEGg4EUBDixAzalQYEAAh+QQFCgAFACwAAAAADwAPAAAIIgALCBxIsKDBgwgTKlzIsKHDhwsDBGgIoACBhhchatyoMCAAIfkEBcgABQAsAAAAAA8ADwAACCIACwgcSLCgwYMIEypcyLChQ4UAADSMSKAhgYoPM2rcqDAgACH5BAUAAAUALAAAAAAPAA8AAAgkAAsIHEiwoMGDCBMqXMiwYQEAEAE4lNiQYsIBDjNq3MjxYEAAACH5BAUKAAUALAAAAAAPAA8AAAgkAAsIHEiwoMGDCBMqXMiwYQECEAk4lNiQYkIADjNq3MjxYEAAACH5BAUKAAUALAAAAAAPAA8AAAgkAAsIHEiwoMGDCBMqXMiwYQEAEAE4lNiQYsIBDjNq3MjxYEAAACH5BAXIAAUALAAAAAAPAA8AAAgkAAsIHEiwoMGDCBMqXMiwYQECEAk4lNiQYkIADjNq3MjxYEAAACH5BAUKAAUALAAAAAAPAA8AAAgfAAsIHEiwoMGDCBMqXMiwocOHECNKFCigoYCKEyEGBAAh+QQFLAEFACwAAAAADwAPAAAIHgALCBxIsKDBgwgTKlzIsKHDhxAjSpQowKGAihIDAgA7" width="16" height="16" />'

		},
		'_USER': {

			'start': ':user: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhDwAPAKIEAD0Re////wAAAP//AP///wAAAAAAAAAAACH/C05FVFNDQVBFMi4wAwEAAAAh+QQFyAAEACwAAAAADwAPAAADP0iq0r2QtEHpg6I6vbINAshJHxiIg0Cmp3l6U9jKb5rJACDk9cTmOwDKZ7sRVZ6K0sLQOJlNyzFClEY6DhUkAQAh+QQFAAAEACwDAAMACQAGAAADDTgj28qOQUerepdOkQAAIfkEBQAABAAsAwADAAkABgAAAxJIGsS6LLgmaZQXBwAIr1v3EQkAIfkEBQAABAAsAwADAAkABgAAAw04I9vKjkFHq3qXTpEAACH5BAVkAAQALAMAAwAJAAYAAAMSSBrEuiy4JmmUFwcACK9b9xEJACH5BAUAAAQALAMAAwAJAAYAAAMNOCPbyo5BR6t6l06RAAAh+QQFZAAEACwDAAMACQAGAAADEkgaxLosuCZplBcHAAivW/cRCQAh+QQFAAAEACwDAAMACQAGAAADDTgj28qOQUerepdOkQAAOw%3D%3D" width="16" height="16" />'

		},
		'_MO': {

			'start': ':mo: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhFwAXAMMDAAAAAP//AP/yAP///2ZmZgoKChMTE1lZWQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C1dFVFNDQVBFMi4wAwEAAAAh+QQFZAAIACwAAAAAFwAXAAAEVhDJSau9OOvNOwZeBiJjKIGlCayrCgQw3HKvYN92etXC2gM3XaUGGAyKx5wokDM6gcods+c0QnufaXGbjFp4PxZOOLnixhrz2fsJ+tgi9czDmpvu+EkEACH5BAUKAAgALAYACgAHAAYAAAQMUMhJqwUSCwx6t1IEACH5BAUKAAgALAYACgAHAAYAAAQQUAAgKRjjZo13x1MmWtMkRAAh+QQFCgAIACwGAAoABwAGAAAEDFDISasFEgsMerdSBAAh+QQJMgAIACwAAAAAFwAXAAAEKRDJSau9OOvNu/9gKI5kaQEAgobAMLQvCLsxSLvsgOj1h/6moHBILA4jACH5BAlkAAgALAEAAwARABEAAARPEMkJpr23Io3z7hggiqAkBihKhoHgvi5ntoJYAy+Ht8Aw9L+cKecr4mIbAQ1ohNmWv+gxNqWOYDes1gmg5U6wQKWLBRC8YkrVtZSZRnBZBAAh+QQFZAAIACwCAAQADwARAAAERRBJCaa9syKN8+4WIIqgGJwnGQZC67YcwAoiDbiaTA8DwN+0zczH++F0u2LvOOw5gbaZbfSqQF9VCnYbO0I5lKutNAIjIgAh+QQFZAAIACwIAA4AAwAEAAAEB7AgiWoNOAIAIfkEBQoACAAsBgAKAAcACAAABBBQyEmrBRILDHq34BSMgRQBACH5BAUyAAgALAYACgAHAAgAAAQVUAAgKRjjZo13/lOHWdMknGgarGcEACH5BAlkAAgALAIABAAPABEAAAQiEMlJq7046807FQICZgIAlOcGdAPSehrQzitm3vAGlnkvRQAh+QQJFAAIACwCAAMADwARAAAERRBJCaa9syKN8+4WIIqgGJwnGQZC67YcwMIC8GoyPAC7W+W1gVBogwF5w55xxhspa0Co1Ld51ay425VKsd4uIiwHPBojIgAh+QQFyAAIACwCAAQADwARAAAEQxBJCaa9syKN8+4WIIqgGJwnGQZC67YcwL60JsOAILrVrQ8DADCHmwmBQ57viCTqlsGos6cc8Si0bKx2DTlxpRFHEgEAIfkEBQoACAAsBgALAAcABgAABAxQyEmrBRILDHq3UgQAIfkEBcgACAAsBgALAAcABgAABBBQACApGONmjXfHUyZa0yREACH5BAUKAAgALAYACwAHAAYAAAQMUMhJqwUSCwx6t1IEACH5BAXIAAgALAYACwAHAAYAAAQQUAAgKRjjZo13x1MmWtMkRAAh+QQJMgAIACwCAAQADwARAAAEIBDJSau9OOvNOwUAAmbAMJTnNnRh6GlCKwqZYNtvrusRACH5BAkeAAgALAIAAwAPABEAAARGEEkJpr2zIo3z7hYgiqAYnCcZBoIAuK2bse4A2LEGsPfg47Jd60YEuoQ1m+81RB6fOecwlttQX8whhcrVbrveTLZZGnEkEQAh+QQFMgAIACwCAAQADwARAAAERRBJCaa9syKN8+4WIIqgGJwnGQZC67YcwAoiDbiaTA8DwN+0zczH++F0O5/yOCwaYUjb6FUBvq65qzZ2tHIoVmhp9EVEAAAh+QQJAAAIACwCAAQAFAARAAAEHhDJSau9OOvNu/9gKFKGMSKmmIaFWLzgC8dIS9dnBAAh+QQJAAAIACwCAAQAEAARAAAEQxBJCaa9tiKN8+4XIIrgBgQoSoaB4L4ut7VwzZ21TdE5XOECQGwYm71GIp+IJzggkZSXc3QoRonCY6ZnzWSPshD0EgEAIfkEBQAACAAsAgAEABEAEQAABEUQSQmmvbcijfPuGCCKIAUEKEqGgeC+Lke1cC2ftT3hub7RgJgwVuEJRiJY0eg6IJEUmHN0OFqCLyzWeu3FOkmlLATFRAAAIfkECQAACAAsAgAEABIAEQAABCEQyUmrvTjrzbv/IAWEyBiaIEoJh1WoEzsBrSaMN6nvVAQAIfkECQAACAAsAgAEABMAEQAABEkQSQmmvRhVnXvd3QWMYziNQZqWXiC88AtagBvfM2Xf8HfuvB5HYwPIjjIKsUcyCim14KHZpPCmpAPGGXMac9agAHziysiiaicCACH5BAkAAAgALAIABAASABEAAAREEEkJpr24Io3z7h0giuAkBihKhoHgvi5ntnAtb3T9rriurwAaIEaMfYK70XBHQdYOSiXlqYRelrvibeMzhrCx7VXaiQAAIfkECQAACAAsAgAEABEAEQAABEUQSQmmvbcijfPuGCCKIAUEKEqGgeC+Lke1cC2ftT3hub7RgJgwVuEJRiJY0eg6IJEUmHN0OFqCLyzWeu3FOkmlLATFRAAAIfkECQAACAAsAgAEABIAEQAABE4QSQmmvbgijfPuHSCK4CQGKEqGgeC+Lme2glgDr7y1wDD0v5gFQAP6gjENMfZr4oSVZe3oe9Yo0ttIG6XAYKOR6Zu7ZXI2YciaLGHFnQgAIfkECQAACAAsAgAEABQAEQAABFkQSQmmvZjqzGvlGSCKoCUGKEqCQCC88PthrQwIIjybLjAMPqCM5sL9jjeZwTCpGX1QnYSJcAaRUgTViRslh4hCM0YGF86UMrlyRqdt35lY3PzaLHR6fVSKAAAh+QQFMgAIACwCAAQADwARAAAERRBJCaa9syKN8+4WIIqgGJwnGQZC67YcwAoiDbiaTA8DwN+0zczH++F0O5/yOCwaYUjb6FUBvq65qzZ2tHIoVmhp9EVEAAAh+QQFMgAIACwIAA0AAwADAAAEBnDIMootEQAh+QQFZAAIACwGAAoABwAKAAAEF1DIKQEQFo8Btt3gB3JdyWFWRq3rlWIRACH5BAVkAAgALAgADQADAAMAAAQGsCCJ0LARACH5BAUyAAgALAYACwAHAAkAAAQPUMhJqwUSCwx6t+CVVUAEADs%3D" width="16" height="16" />'

		},
		'_CHUPS': {

			'start': ':chups: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhGwAWALMJAP///3Nzc/cmCoGBgaBBDfSawQYGBv/yAAAAAP///wAAAAAAAAAAAAAAAAAAAAAAACH/C1dFVFNDQVBFMi4wAwEAAAAh+QQFMgAJACwAAAAAGwAWAEAEejDJSau9E53NOUpEIRJYoh1Gh24f4pZWC2OnAQA2jm/hOEuuoIX0o8iKtOAHmdnknjyRlFg5oQwpbIqFoJasWg/wxVwumVUg+iI7o10qMojgjXGwV05vynbe/jcpez52KH85OwdddF8qjlxyfU53YkIzcB2RBANuaz8RACH5BAUUAAkALAUACQAJAAYAQAQO8MhJjT3W0M3rRJPWHREAIfkECTIACQAsBQABABEAFABABCUwyUkrNSZhy7v/FyAaIpCBaFqRZXmqcCzP9Mfe36jbG/bWwFgEACH5BAUNAAkALAAAAAAbABYAQARvMMlJq730aGMOPwgmaht5EChCIKFIha07ep9BFDhOyC/LujtXK8bD+H5FiwfAbAJQwaLJc8rppFPS8Ei0ELvJyTAsgiXARdYUSd4YABw4qP1m1m9X7BSfi7pMHRp8K2gVU4EaMD4yaiZsZyx+ZDwRACH5BAkNAAkALAYACQARAAwAQAQdMKVzZpU46yTE/qBGjVSodZ6pbuRoutcqn+hszxEAIfkECQ0ACQAsAAAAABsAFgBABFUwyUmrvTjreroRIFGMBIJsaEp1bCeSqmTO1kzEeJ4bbXviLd5rVLileqzf7KdrOp9Q3YE39RyYKqSLYMz2hrCjJ0QMo4KHEBdRwmIQPdNkKY9KuokIACH5BAkNAAkALAAAAAAbABYAQARyMMlJq70TnW3M6QeCXdrGCShRrCuBvO+YiKJMmnhO7HYFx71RrRbE/IjFGSdnQgqZn42KVSDMYAEfdIPYWYtIZ1IyHBtnaPM1BwSbPNGo+LbFzbX1w7RqIZZwBigCey0uMDxkTB4pLF8Bj1l9f1x3akURACH5BAUNAAkALAAAAAAbABYAQARxMMlJq70TnWN25wh2aVvZCUShqkSCvEgwSqEokmWe13YFvxOCsJeh8IiY3xHp0jmXSadBQN0IW0ScLrUqEJTMsKUGFdNcZp/G0GGXbx7n5u2TP7PyT4mekVKpXF5jRnYHgSxfMENGWgcvgVgBkjJpNhEAIfkECQ0ACQAsBQACABYAEwBABBkwyUmrvTjrzXsVgieOZFkdZqqubOuCbixHACH5BAkNAAkALAAAAAAbABYAQARqMMlJq730aGMOPwgmaptgCkSKEEgoUqH7jiRJFDhOzHDbvruXS8bD+H5Fi6dmSyUTzM4tVwjOmLXhkWghcp+SIdiYiI3DCCYSvGkvvy+sZlpNyum6Ys1worPgFVEHJiBlPjMtal4tVmczEQAh+QQJDQAJACwAAAAAGwAWAEAEazDJSau9E51tzOkHgl3axgkoUawEIo6V+MJWad6HytKx69YuAu8142F8PyOl5MFtiiPbzaNbFYQ0KY7oGy6VRwkU/JWRM9qk0tZsh4xaJ2E+dJqqu6jTkLLm9TgeKXMILWM9WzNIamcWWBIRACH5BAkNAAkALAAAAAAbABYAQARyMMlJq70TnW3M6QeCXdrGCShRrCuBvO+YiKJMmnhO7HYFx71RrRbE/IjFGSdnQgqZn42KVSDMYAEfdIPYWYtIZ1IyHBtnaPM1BwSbPNGo+LbFzbX1w7RqIZZwBigCey0uMDxkTB4pLF8Bj1l9f1x3akURACH5BAUNAAkALAAAAAAbABYAQARxMMlJq70TnWN25wh2aVvZCUShqkSCvEgwSqEokmWe13YFvxOCsJeh8IiY3xHp0jmXSadBQN0IW0ScLrUqEJTMsKUGFdNcZp/G0GGXbx7n5u2TP7PyT4mekVKpXF5jRnYHgSxfMENGWgcvgVgBkjJpNhEAIfkECQ0ACQAsBQACABYAEwBABBkwyUmrvTjrzXsVgieOZFkdZqqubOuCbixHACH5BAkyAAkALAAAAAAbABYAQAR2MMlJq7306L1RIkVIYNNhcKbmISxprW5sAMBc1xooxhLrWyMeBSbE+FrFiolmOx10oUIQYzKcrM4Da+raYDs9ZNGTICcrZPN5WG6vywiUmEDnaazVDXRHstH+J3tSLn6FKnRcVChyPzF3XmCNLiyMFAQDam8xEQAh+QQJCgAJACwAAAAAGwAWAEAEdTDJSau9E51tzOkHgl3axpkHoSIEIo6U+MJWyYEGUew7QccuF8wHe81+mKAQGeMAnlCAilhEmTw6XoE6sllDEuUyGWOSE0dzRYZWZ7yhNM3WAdQ9ctIVanhmt3NfJn89VVYeG38teRlfiBsyQXNwY2guXG40EQAh+QQJCgAJACwAAAAAGwAWAEAEdDDJSau9E51tzOkHgl3a9hlEoaoE4rojJYoxad4boYe19cK9EY0WxPyIxUTJAGgynUghrpNaFQjKV8B4A+mwSQkyGlaKyyQzOejCAYulE6Az5/XiJ0/HY4/hOSgrLRVkf1RWVy0vOj5dhywSAZJbQn9vaJgRACH5BAkKAAkALAAAAAAbABYAQARpMMlJq70TnW3M6QeCXdr2FWhBICw7kon4kmYNmvJMta4+yjkfiSfccWomQ/CHNKRUoVZgVuIQCJulL6gtxiRd71cUplazZdrxc0xnkPCs7sxBYeVfDN2ZuvKuTEl9GwGFU3NVHj1ijBMRACH5BAkKAAkALAAAAAAbABYAQARlMMlJq70TnW3M6QeCXdr2FQWBrOs4iqJLmjRoxjLFtvkr4T3SLqjj0EwG4OtoQBFCrECvZLwRM7qrJabU/hIwL5i64QWpno+xOzu6Qzky50kzY+TNlIpFIMjITXQBg1JncnZiWhEAIfkEBQ0ACQAsAAAAABsAFgBABFwwyUmrvROdbczpB4Jd2sYhaDquoriSZiyHr5WiNSu5OXbzvUTJMzMAR6WY5xY4ImcmZw0oDbqqQaEWy0pucFYTcUybQmfc3TkGZskMBMItnvOaAvhmFiVrZ/8UEQAh+QQFDQAJACwIAA0ACgAFAEAEEzDJmQ6tM8hjEpmIVxmWhGjjJUUAIfkECQ0ACQAsCQANAAoABQBABBMwySkRPTPIYxKZ1sdhlZZwlJVEACH5BAkNAAkALAAAAAAbABYAQAQyMMlJq704a3y6QSC4jWRpnmiqrizVHcYRIkFr33iu77z0/ohE8OQhEGZG4i/ArPWeiQgAIfkECQ0ACQAsAAAAABsAFgBABFowyUmrvROdbczpB4Jd2maaBqKqI5mILXnOJxxTK3uPsL2TuR+OQ/v4eEVUaBWIlYrHnS8qfEmoVasI63xudL+n50PkDpO1mxfdQyYNBEIu7kYH7k31GpztSyIAIfkECQ0ACQAsAAAAABsAFgBABFwwyUmrvROdbczpB4Jd2maeBqKqoyWKLXnOJxxTK3uPsL2TuR+OQ/v4eEVUaBVolYrHnS8qTPSqmJcVK1HNdL+n50OkupLf2xMdymTZBgIhJ3+zEYF8M+atmbk/EQAh+QQJAAAJACwAAAAAGwAWAEAEXDDJSau9Ep1tzOkHgl3aZp4foqpjJYotic4bHFMre4+wvZO5H45DM/h4NJQxF0AmjzsfVJjoUTGv6jVTMul+Xc+HOLV0k7XbGS2VoT8EQi7uZicC+GZLhfpu/wkRACH5BAkAAAkALAAAAAAbABYAQARcMMlJq70TnW3M6QeCXdpmngaiqqMlii15ziccUyt7j7C9k7kfjkP7+HhFVGgVaJWKx50vKkz0qpiXFStRzXS/p+dDpLqS39sTHcpk2QYCISd/sxGBfDPmrZm5PxEAIfkECQAACQAsAAAAABsAFgBABFswyUmrvROdbczpB4Jd2maeH6KqYyWKLYnOGxxTK3uPsL2TuR+OQzP4eDSUMRdAJo87H1SY6FExr+pVokLpfqUPUTy1hJO12xktlaE/BEIu7mYnAvhmq3v6bv8RACH5BAkAAAkALAAAAAAbABYAQARcMMlJq70TnW3M6QeCXdpmngaiqqMlii15ziccUyt7j7C9k7kfjkP7+HhFVGgVaJWKx50vKkz0qpiXFStRzXS/p+dDpLqS39sTHcpk2QYCISd/sxGBfDPmrZm5PxEAIfkECQ0ACQAsAAAAABsAFgBABH8wyUmrvROdzTnCl3YY3bh9CaKioPSxbSUaAEDb9jkRRd8ToRUsBnoRW8LhcVa7kQ5D3i/DMVhHV10KIS0AKSLsEyohrI6uNDqkXluMymX4FC9WSVlyhcAHb241gU8sXVMpf4KCWgmFXi4lkDoqZnxfVH9VHkl1LnNQKJZuogkRACH5BAUyAAkALAAAAAAbABYAQAR6MMlJq70Tnc05SkQhEliiHUaHbh/illYLY6cBADaOb+E4S66ghfSjyIq04AeZ2eSePJGUWDmhDClsioWglqxaD/DFXC6ZVSD6IjujXSoyiOCNcbBXTm/Kdt7+Nyl7PnYofzk7B110XyqOXHJ9TndiQjNwHZEEA25rPxEAOw%3D%3D" width="16" height="16" />'

		},
		'_KISS': {

			'start': ':2kiss: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhIgAPAJEAAP//////AAAAAP///yH/C05FVFNDQVBFMi4wAwEAAAAh+QQJZAADACwAAAAAIAAPAAACYZwtmcet25AIlMKYqhVOe955FThMW5BZjCKOiAUAQmySJd2iJRz3snrrmUSpmez4092Mw09NKAQmoq0UKsOSXpvO3OflddWGxdU1B2pmgZIwiauxgasO7qXujEgU+jqfUQAAIfkECQcAAwAsAAAAAB8ADwAAAmCcLZnHrNuQCJTClqoVWHvueBo4TFuQWYciVqApAEA8q4hsihws97hK+7VStFgROBPqeLgerBTMfXIsFhCVGkpbV+6oZPnYYFsXwvUwg8vfM5cE9cLjo7lkGpEo8o5HowAAIfkECQcAAwAsAAAAAB8ADwAAAlucLZnHrNuQCJTClqoVWHvueBo4TFuQWYcpVqApAEA8q8gpcrDMy3CJYrVStFhRJWzhaDPeL6lMBScKFzR6zWVzQNQHqfzcNlWbNLoKk8ZDTPLieK/jioi7zigAACH5BAkHAAMALAAAAAAeAA8AAAJYnC2Zx6fbkAiUQpaqFW1qzTkfKG5BZiHjF3oCALxxOrgeW1vwDtvnvULJXkPTiuXayWa/I7Ki+N2AzmbVcoXmTizjtQV9aFHO0DaIKXeoFwfbvFZEMI9GAQAh+QQFBwADACwAAAAAHQAPAAACV5wtmceo0k4KlC42a7hSe4h4GjgI1ZRtpfiFGwAIsKnS6bi+8B5bG836WWaxmS84su1kxg0yeULdnlGqFWf7HKkg4MM7FZGA4k6Q5PigS+RfxKF4wzmGAgAh+QQFBwADACwDAAMACQAIAAACEdyCaSMSbZJzqdqLFV1mtm8UACH5BAlQAAMALAAAAAAdAA8AAAIdnI+py+0Po5wh1anECKJqDIbiGArm+ZHqyrbuWAAAIfkECQcAAwAsAAAAAB4ADwAAAk6cLZnHp9uQCJRClqoVbWrNOR8ojuTgmRZSZdmKbiaXenY7vaquyj3+AwYDvF4q+HooLcOVTflshmqPFuo4K2W1o5ADe/l+wphHpKxoFAAAIfkECQcAAwAsAAAAAB8ADwAAAlCcLZnHrNuQCJTClqoVWHvueBo4TOJ4mKeFVFnGtgH8la6FsxN98uts+7lUQg7x51sllaaHcyNENZ3NYBSkesaWKFmvo8QcL44xSayIoMmDAgAh+QQJBwADACwAAAAAHwAPAAACWZwtmces25AIlMKWqhVYe+54GjhM4ngop4VUWcYiAGCKXG3mbjnP9fdbBW403womZCV6QVfzdBsibbnHQ5ncVa2x6rG1UXWHSdIzJhGS0qN1KnjBPCJyRaMAACH5BAkHAAMALAAAAAAfAA8AAAJZnC2Zx6zbkAiUwpaqFVh77ngaOEzieCinhVRZxiIAYIpcbeZuOc/191sFbjTfCiZkJXpBV/N0GyJtucdDmdxVrbGS9NjaqLpTW0pICkMxwYujnX4rIuw5owAAIfkECQcAAwAsAAAAACAADwAAAlucLZnHrduQCJTCmKoVTnveeRU4TKJGltkZgKbSrqkAAKbI3Vb7IXWtQwVZLhuQODy5aEdlEoeIPWM7nCXKQpU2jxdjsoJuueHZtHWYprBKR/Di/qzTjwimzigAADs%3D" width="16" height="16" />'

		},
		'_JUMP': {

			'start': ':jump: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,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%3D%3D" width="16" height="16" />'

		},
		'_YAWN': {

			'start': ':yawn: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhDwAPAKIAAP///2PG//+cnAYJDQAAAP///wAAAAAAACH/C05FVFNDQVBFMi4wAwEAAAAh+QQFyAAFACwAAAAADwAPAAADP1iq072wtEDpg4MSErZdWQcAxMgFAyOOLIlKmkmaVliOA3tOmredqFBlOOQ5jkYYkZhSLitN5zLKENYioGMkAQAh+QQFCgAFACwDAAIACQAFAAADCRi63P6wLLJKAgAh+QQFyAAFACwDAAIACQAFAAADEVhFtK0EgDiXvJLlmcv1UpEAACH5BAUKAAUALAUACgAFAAEAAAMDOKoJACH5BAUKAAUALAMABgAJAAYAAAMNWFqz/jDCIaoVbejdEgAh+QQFCgAFACwFAAsABQACAAADBCiq050AIfkEBQoABQAsAgABAAsACQAAAyBYSlSskAAgaZx4Nug6hxTABQFDlAypruvgvrArzDQ9JAAh+QQFCgAFACwCAAEACwAIAAADHVgKQEyquLVglPjGBnQg4BdGQVmU5qCurCq8MFwkACH5BAUKAAUALAIAAQALAAcAAAMaWKrQs4sUCRcgAIZAOvdbKIZDaZ6PoK5rkQAAIfkEBQoABQAsAgABAAsABgAAAxpYWsOrgQAwJgklaDLCuFooikNpno2grmuRAAAh+QQFCgAFACwDAAEACQAFAAADEVgKA1ohkBEGiTjHwXsXYBgmACH5BAUKAAUALAQAAQAHAAQAAAMLWDEcGjCyyYS9IgEAIfkEBWQABQAsBQABAAUAAwAAAwYYqtMtECYAIfkEBTIABQAsAgACAAsACwAAAyBYShSskAAgaZx4kuI01UHngSHTmGGqrkPrumssrxCtJAAh+QQJCgAFACwAAAAADwAPAAADFVi63P4wykmrvTgPwbsYzyCOYGZWCQA7" width="16" height="16" />'

		},
		'_BOLI': {

			'start': ':boli: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,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" width="16" height="16" />'

		},
		'_YES': {

			'start': ':yes: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhDwAPAJEAAP//////AAAAAP///yH/C05FVFNDQVBFMi4wAwEAAAAh+QQFUAADACwAAAAADwAPAAACOJwtmceTAeFiIlp5qqwPOwkAQqgJXzCGqriB4suipZrGnczd93WZpSbzAHEWE4IXMWaGssZS0SgAACH5BAkUAAMALAAAAAAPAA8AAAIqnI+py50BI4t0QSEClkgPIABD5ohNKKaggoLASy4Z5gzcidHTw+iGgCgAACH5BAUUAAMALAAAAAAPAA8AAAI4nC2Zx5MB4WIiWnmqrA87CQBCqAlfMIaquIHiy6KlmsadzN33dZmlJvMAcRYTghcxZoayxlLRKAAAIfkECRQAAwAsAAAAAA8ADwAAAiqcj6nLnQEji3RBIQKWSA8gAEPmiE0opqCCgsBLLhnmDNyJ0dPD6IaAKAAAOw%3D%3D" width="16" height="16" />'

		},
		'_NO': {

			'start': ':no: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhDwAPAJEAAP//////AAAAAP///yH/C05FVFNDQVBFMi4wAwEAAAAh+QQFCgADACwAAAAADwAPAAACOJwtmceTAeFiIlp5qqwPOwkAQqgJXzCGqriB4suipZrGnczd93WZpSbzAHEWE4IXMWaGssZS0SgAACH5BAUKAAMALAIAAwAKAAkAAAIa3DSBYQd+mHjNCPXmjBvGYyhhRTaLlVRIahQAIfkEBQoAAwAsAgADAAoACQAAAhrcMoJix/BYYM3AOSDMim5+GIpYlc1ioCdpFAAh+QQJCgADACwAAAAADwAPAAACI5yPqcudMQQULFBw6dMI74F5HmIZ40gakuq0w2TAFevWtlMAADs%3D" width="16" height="16" />'

		},
		'_CRY': {

			'start': ':cry: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhEwAPAKIEAACy6/////ma0AAAAP///wAAAAAAAAAAACH/C05FVFNDQVBFMi4wAwEAAAAh+QQFyAAEACwAAAAAEwAPAAADQ0i6dO4sLidqhVId+3jel7CBogSO1BmdYnC44sWMrRvA4yy+j+Pmk93v8SsFWz2eTPe6NXGmS4piXFmuyw9Jmln1MgkAIfkEBQoABAAsBQAEAAkABwAAAw4oJ8q7jjUJJbW2zn2qTwAh+QQFMgAEACwFAAQACQAHAAADFCint67hRAVjmLLpmHXnW3NZ15EAACH5BAUKAAQALAUABAAJAAcAAAMOKCfKu441CSW1ts59qk8AIfkEBWQABAAsBQAEAAkABwAAAxQop7eu4UQFY5iy6Zh151tzWdeRAAAh+QQFMgAEACwIAAoAAwABAAADAwgECQAh+QQFMgAEACwGAAoABwABAAADBAhArAkAIfkEBR4ABAAsBAAEAAsABwAAAxIocsqrr0Hm5Kyx4Q2qByBghQkAOw%3D%3D" width="16" height="16" />'

		},
		'_POP': {

			'start': ':pop: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhLAAeALMPAKenpwYHAZqamo6OjW9DGGZmZqZ9VIJ7AP/yAIxiOSEhIaZ8UszMzP///wAAAP///yH/C1dFVFNDQVBFMi4wAwEAAAAh+QQJDwAPACwAAAAALAAeAAAE//DJSau9OOvNu6dKqHzkJZ5jSYqHgiBKG6od6sIovcXt68OHlk4TO71OwiGmUOwBiwXlkhc6UqNSCzPkLIawWQoz2CUrwCrHw6F+MCRb2wmdZjsYb4mDzCe3dXZ2eWuBhQ4BSoVubQEIDg2PkA2QCIhDbXdvao2Rk54OlRgAowAbDgJ3E42On58vlhKkAAm0CRsCAoOrjmy8sr+ztAvDthoCD7lvuz8IAwO10MLDxBzHyMrMPs/T3NLTxRqD2Myg29zECd0egwINNz4OzunDBOjn4LcTBAIG5OYEAOt5W4AvX0ADBpY1m7egnr1vHwQMAIiQwIMAq+TRmzew4AYDAicWIDRgUQLGZ+kSOCTIkOCHBiMrWjDXTRotFSNLWojG0yOJBmEoRAAAIfkECQ8ADwAsAAAAACwAHgAABP/wyUmrvTjrzbunSqh85CWeY0mKh4IgShuqHerCKL3F7evDh5ZOEzu9TsIhplDsAYsFpYRRYQZDR54iKqVSmCFnMcSlOR4M78R6PQZbZTPj/LXZ4iWHI02fON6Ab31menpqD4WJiQFKdIZ9AQgODZOUDZQIjEMOAntUeg+RlZekDpkYAKkAGgIPAoeRkqWlL5oSqgAJugkZra0UsZJ6wrjFuboLybwYv7A/PwMDu9PIycqsU8DPPtLW3tXWy8wTrxLBz93eygnfG7+u2i+F0ezJBOvq4swE/AQCC+Z+6EnX7x64BfouLBDQz9qEcwjSLbiHL9wGdckqBIhFz169gwkeMWC8sFEauwQUEda71sGbBonhqumScoGazZA0lUQAACH5BAkPAA8ALAAAAAAsAB4AAAT/8MlJq7046827p0qofOQlnmNJioeCIEobqh3qwii9xe3rw4eWThM7vU7CIaZQ7AGLBeWSFzpSo1ILM+QshrAkhsQxDXbNCrCHIR47yJSt7aReu9/wicPMN+fDd3gUeISEASpsY24PeQEIDg2QkQ2RCIeAegJ5bw+OkpSgDpYYAKUAFW0SAg+rFI6PoaEvlxKmAAm4Cahtq60Tr49vwbbEt7gLyLqorKoVwD8IAwO51MfIyRdirb4Sz8HRCdfi1tfKFr7cnT+E0+Ll4eUZ6BbAeNLwCwTJ+NgWCwIEAhJIp87Hm3b5BC4gtxDDNYECFtCDhjDfu3EZ3CG7EODVPWQEIOAxNHdBo4aO08Il0LcPowZxHSq+E0kyi4RqOGvaVBIBACH5BAkPAA8ALAAAAAAsAB4AAAT/8MlJq7046827p0qofOQlnmNJioeCIEobqh3qwii9xe3rw4eWThM7vU7CIaZQ7AGLBeWSFzpSo1ILM+QshrAkhsQxDXbNCvBHPHaQKVvbSd1hsN34isPMN7/DE3h5gYKFDgEqdmNtD38BCA4NkZINkgiINGIOAn9uD4+TlaIOlxgApwAYYgICFo+Qo6MvmBKoAAm4CRZ2ra0Vr5BuwbbEt7gLyLoVDL6+FMA/CAMDudXHyMkXzmzP0cLU2OHX2MoSDA0CbNzdPoLg4ckJ4hUGAgRszr/tbtPyyATx4JWTYMAAgYPMMEDj5+/gwQXjIFogUPDggHz6frxbADAguYkFMQ0sEGBAQ4BX/f75iziQAsWQBhpsOElNXoKOEP1lw/CypIeN5K7h2iCzhLWjLbNIiQAAIfkECQ8ADwAsAAAAACwAHgAABP/wyUmrvTjrzbunSqh85CWeY0mKh4IgShuqHerCKL3F7evDh5ZOEzu9TsIhplDsAYsF5ZIXOlKjUgsz5CyGsFkKM9glK8AfhsTxcLDFNhvao1673xMHeU/Gp+t3dxSBhG4BKnVtgYoSAQgODZCRDZEIhyQMiW94bI6SlKAOlhgApQAYgAJ+jo+hoS+XEqYACbUJF3UCD7oTrI9uv7PCtLULxrcVmRK6vI0/PwMDttPFxse4y9m9z8DS1t/V1sgYvM0Pvr9u3t/HCeCouxPm5z530e7GBO3s48nx2tvqOVhHoKC+cAv6VVgggIHBefSg4Vugb5+4DNYeLrAQgNW9fPgiECq0wM4Yho7S3CWomHBiwg0lN6wDV61Wh28dqOkcGWZIBAAh+QQJDwAPACwAAAAALAAeAAAE//DJSau9OOvNu6dKqHzkJZ5jSYqHgiBKG6od6sIovcXt68OHlk4TO71OwiGmUOwBiwXlkhc6UqNSCzPkLIawWQoz2CUrwCrHw6EW22zoNLs9cZDvZDptPmfU+YAOAUqADAxtAQgODYuMDYwIg0Ntan5qiY2Pmg6RGACfABsOApUSiYqbmy+SEqAACbAJGgIPAoamPnOKDq69r7ALwbIZtLYTpz8vAwOxzcDBwhu0D364ycoJ0NrP0MPEErZ+yLkIzNrd2d0c07XV44rL6QsEwvLR0hPGD+8O5vMEABdwE9hBAECAAhZY8+FvHrptHBYYDBjs2Kl4wQikG+hNw7mKFRwCBGCWLQG9ehA7fMTQEN3GjhGhaXBGE2YYJREAACH5BAkPAA8ALAAAAAAsAB4AAAT/8MlJq7046827p0qofOQlnmNJioeCIEobqh3qwii9xe3rw4eWThM7vU7CIaZQ7AGLBeWSFzpSo9IJQ8IMOYshbPaxfTCDX7RCrHI8HG5GuWs7sdtwR1niQPvRbkN5cHITg4dwAUqHb3oPAQgODZKTDZMIioJ8Wo+Rlp+WDpgYAKUAGw4CgXKQnqGfoqMTpgAJtgkbAgISW62RcL+0wrW2C8a4Gru7Er4/CAMDt9LFxsccywK9zsDR1d7U1cgae9o+g93exwnfHnvZN78O0OvGBOrp4rkTBAIGP3DoCAi0B25BPn0DDRho9ozeAnv3wn0QMECgQgKPWs2rR6/gwQ0GKAQsUGgAI7MA0dYlgGjQocEPDUhetIDuGzVbKkiatDCt50cSDcZQiAAAIfkECQ8ADwAsAAAAACwAHgAABP/wyUmrvTjrzbunSqh85CWeY0mKh4IgShuqHerCKL3F7evDh5ZOEzu9TsIhplDsAYsF5ZIXOlKjUgsz5CyGsDTHNNglK8Bhh/jBkGxtJ3RJTWe0JQ6ynrzW0esTf4JqAUpramwTAQgODY2ODY4IhUMOAmJ2iIuPkZ0OkxgAogAaAg+mdw+LjJ6eL5QSowAJtAkZpqiKPnSMDrK/s7QLw7YYpqdsbas/LwMDtdDCw8SlEsfKzGoIz9Pd0tPFxhO5y71q3N3ECd4bx8i6L3TO68ME6unhxgT7BAILEuXO0eNn79uCfBcWCOA3DZ4PdAvs3QO3Id2wCgFWzatHzyBCDBYcL2R8ti6BxIP0qHXopgEiOGm0sliIRvOjzCERAAAh+QQJDwAPACwAAAAALAAeAAAE//DJSau9OOvNu6dKqHzkJZ5jSYqHgiBKG6od6sIovcXt68OHlk4TO71OwiGmUOwBiwXlkhc6UqNSCzPkLIawJIbEMQ12zQrwRzx2kClb20ndYbDd+IrDzDe/wxN4eYGChQ4BKnZjbQ9/AQgODZKTDQ4IiDRiDgJ/bg+PkZSSlpgWAKcAGGICD6wUj5CjspaXFKgACbkJFoqsrhOwkIW3xLi5C8i7FasSvxLBPwgDA7rVx8jJGa7On9Fu0gnY4tfYysu/3NCC1OLl4eWq6BbBeNPvCwTJ99kWCwIEDAgQ4NbNhxt2+ATmI7fAXAVsCgUsmBcNIT534zK0Q3YhACx7yCEIvGPosF87DR6phUuQT19GDeI6WHQ3smSWB9Zy2rw5JAIAIfkECQ8ADwAsAAAAACwAHgAABP/wyUmrvTjrzbunSqh85CWeY0mKh4IgShuqHerCKL3F7evDh5ZOEzu9TsIhplDsAYsF5ZIXOlKjH0aHGXIWQ9gOQztxTINetCIsrjjeFa7txOaQJe+8G81Hm7N3D3l6ZYOGDgEkgYJ4Zn8PAQgODZSVDQ4IiR6LggKPcJGTlpSYmhYAqAAUYxQCAhaRkqSzmJkUqQAJugmrE6+vFbGShrjFuboLybwTZMDAFMI/CAMDu9bIycoXz5zRP9XZ4djZyxIMDdwX3pLTCeHk7uQVBgIEvhjeDtTxCwTK/NooGDBAoOCDZ8Gk6YtXsOCCcQ8tEBhYcADChN/4+fsnTuJAAwsvBBjQECDWvmQE4kEsV2HiRwMNNpSs5i7BxocAWbb8+AHcu13/NsQsca2oTilIIwAAIfkECQ8ADwAsAAAAACwAHgAABP/wyUmrvTjrzbunSqh85CWeY0mKh4IgShuqHerCKL3F7evDh5ZOEzu9TsIhplDsAYsF5ZIXOlKjUgsz5CyGsFkKM9glK8Aqx8OhFttsaA9jwmZXHOQ8uV2ar+t2dICDDgEqDH6DfxIBCA4NkJENDgiGJH4SbXxqjY+SkJSWFgCkABWIFA4CfA+NjqCwlJUUpQAJtwkXfgIPvBOujoO1w7a3C8e5Fru9FMA/CAMDuNPGx8i6c76+jM8+0tbg1dbJpxLazd0v3+DICeEa29vcL3XR7scE7ezk5fEVzmzWERiYT9wCfqcEECQgb563ewvy6RuX4RgDggIWWAjgyh6+ewYhEVpgdwwDR2nuEkg8CPHgBpIb1oWrdqsDuA7UcooMMyQCACH5BAUPAA8ALAAAAAAsAB4AAAT/8MlJq7046827p0qofOQlnmNJioeCIEobqh3qwii9xe3rw4eWThM7vU7CIaZQ7AGLBeWSFzpSo1ILM+QshrBZCjPYJSvAKsfDoRbbbOg0uz1xkO9kOm0+p/D/bAFKfAxrbQEIDg2LjA0OCIJDagyFEmqIio2Lj5EWAJ8AGw4ClRKIiZupj5AUoAAJsAkaAg+lD6eJf667r7ALv7IZpLa4PwgDA7HKvr/AG6QPtKbGPsnN18zNwcKF0rc+f9bXwAnYHLSU3sVsyOW/BOTj28ISDOo/7O4E+/DZC/PC9jEgIGDBtBf5msGLp43DAgH8mk0IcKrdO3f+AGIY98sCxWTlGBIs/OfOWQeOGMRhYwaLxDUNy2JqDDMkAgA7" width="16" height="16" />'

		},
		'_WEEP': {

			'start': ':weep: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhFQAPAIMIAQAAAIAAAACAAICAAAAAgIAAgACAgICAgMDAwP8AAAD/AP//AAAA//8A/wD//////yH/C05FVFNDQVBFMi4wAwEAAAAh+QQJKAAIACwAAAAAFQAPAAMEOhDJKYG1NGfrescaBXjkF1ZlCpyjN7am1l4u56xbquOirsq+Em8CuxhdodfuxgrGksFhEvaRnhBGqwQAIfkECQgACAAsAAAAABUADwADBDwQySmBtTRn63rHGgV45BdW5Dh6wKlyH9dqa2nPoq3jU62ztF+Jh4pdYA4i6shMupLMi/P5U2580BPteAIAIfkECSgACAAsAAAAABUADwADBDoQySmBtTRn63rHGgV45BdWZQqcoze2ptZeLuesW6rjoq7KvhJvArsYXaHX7sYKxpLBYRL2kZ4QRqsEACH5BAkIAAgALAAAAAAVAA8AAwQ8EMkpgbU0Z+t6xxoFeOQXVuQ4esCpch/Xamtpz6Kt41Ots7RfiYeKXWAOIurITLqSzIvz+VNufNAT7XgCACH5BAkoAAgALAAAAAAVAA8AAwQ6EMkpgbU0Z+t6xxoFeOQXVmUKnKM3tqbWXi7nrFuq46Kuyr4SbwK7GF2h1+7GCsaSwWES9pGeEEarBAAh+QQJCgAIACwAAAAAFQAPAAMEPxDJKYG1NGfrescaBXjkF1bkOHrAqXIf12prac+ireNTrbO01AMwTAVjF5iD11smk0uX8yk7IXwlJg0LsvaSJwAh+QQJAQAIACwAAAAAFQAPAAMEPxDJKYG1NGfrescaBXjkF1bOmK4rcI6XF7uaWt60eO/5ZO+yGgnwIP56qM8lZhIun6lX6jk7IX4lZA0LsvqWJwAh+QQJCgAIACwAAAAAFQAPAAMEQhAhAKSk2M56O3UgSE2dNoWoaGoA2rYht76f+MlsqqsmvLuzXwp3cT0AR2AvhsHEVqem1EG00KQ3aPFX7fls2llTCwAh+QQJCgAIACwAAAAAFQAPAAMEQxDJKYG1NGfrescaMAFe+Y2IWJUk6ampKDvXy8lxbO6f7PM7DMwFfIVYD0CSdexdOKfjc0rTrKbPqjVVhG2htm3ouQUAIfkECQoACAAsAAAAABUADwADBEgQySmBtTRn63rHGgV45BdW5Dh6wKlyH9dqa2nPoq3jU62ztNQDMEwFYxeYA9dqLpPJJaLZnD6hsum0av3NqNqK79nbhnvJzRQAIfkECQoACAAsAAAAABUADwADBD8QySmBtTRn63rHGgV45BdW5Dh6wKlyH9dqa2nPoq3jU62ztNQDMEwFYxeYg9dbJpNLl/MpOyF8JSYNC7L2kicAIfkECQEACAAsAAAAABUADwADBD8QySmBtTRn63rHGgV45BdWzpiuK3COlxe7mlretHjv+WTvshoJ8CD+eqjPJWYSLp+pV+o5OyF+JWQNC7L6licAIfkECQoACAAsAAAAABUADwADBEIQIQCkpNjOejt1IEhNnTaFqGhqANq2Ibe+n/jJbKqrJry7s18Kd3E9AEdgL4bBxFanptRBtNCkN2jxV+35bNpZUwsAIfkECQoACAAsAAAAABUADwADBEMQySmBtTRn63rHGjABXvmNiFiVJOmpqSg718vJcWzun+zzOwzMBXyFWA9AknXsXTin43NK06ymz6o1VYRtobZt6LkFACH5BAkKAAgALAAAAAAVAA8AAwRIEMkpgbU0Z+t6xxoFeOQXVuQ4esCpch/Xamtpz6Kt41Ots7TUAzBMBWMXmAPXai6TySWi2Zw+obLptGr9zajaiu/Z24Z7yc0UACH/C1BJQU5ZR0lGMS4w/0ltYWdlIGZyb20gY2xpcGJvYXJkAWNyeTIuR0lGAkM6XMzu6CDk7urz7OXt8vtc0ezg6etcz+vg91xjcnkyLkdJRgFJbWFnZSBmcm9tIGNsaXBib2FyZAFJbWFnZSBmcm9tIGNsaXBib2FyZAFJbWFnZSBmcm9tIGNsaXBib2FyZAFjcnkzLkdJRgJDOlzM7ugg5O7q8+zl7fL7XNHs4OnrXM/r4PdcY3J5My5HSUYBY3J5NC5HSUYCQzpczO7oIOTu6vPs5e3y+1zR7ODp61zP6+D3XGNyeTQuR0lGAWNyeTUuR0lGAkM6XMzu6CDk7urz7OXt8vtc0ezg6etcz+zr4PdcY3J5NS5HSUYBY3J5Ni5HSUYCQzpczO7oIOTu6vPs5e3y+1zR7ODp61zP6+D3XGNyeTYuR0lGAWNyeTcuR0lGAkM6XMzu6CDk7urz7OXt8vtc0ezg6etcz+vg91xjcnk3LkdJRgFJbWFnZSBmcm9tIGNsaXBib2FyZAFjcnk0LkdJRgJDOlzM7ugg5O7q8+zl7fL7XNHs4OnrXM/r4PdcY3J5NC5HSUYBSW1hZ2UgZnJvbSBjbGlwYm9hcmQBSW1hZ2UgZnJvbSBjbGlwYm9hcmQBSW1hZ2UgZnJvbSBjbGlwYm9hcmQBAAA7SFRUUC8xLjEgMjAwIE9LDQpEYXRlOiBUaHUsIDE3IEF1ZyAyMDAwIDE1OjQxOjMwIEdNVA0KU2VydmVyOiBBcGFjaGUvMS4zLjEyIChVbml4KSBQSFAvMy4wLjE1IHJ1cy9QTDI5LjQNCkxhc3QtTW9kaWZpZWQ6IFdlZCwgMjggSnVuIDIwMDAgMTI6MDM6MDQgR01UDQpFVGFnOiAiMTVhZWRkLTc0NC0zOTU5ZTk3OCINCkFjY2VwdC1SYW5nZXM6IGJ5dGVzDQpDb250ZW50LUxlbmd0aDogMTg2MA0KQ29ubmVjdGlvbjogY2xvc2UNCkNvbnRlbnQtVHlwZTogaW1hZ2UvZ2lmDQoNCg%3D%3D" width="16" height="16" />'

		},
		'_EEK': {

			'start': ':eek: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,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%3D%3D" width="16" height="16" />'

		},
		'_SPY': {

			'start': ':spy: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhDwAPAPcEAAAAABgYGJyc/////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C05FVFNDQVBFMi4wAwEAAAAh+QQF9AEEACwAAAAADwAPAAAIVwAJCBQIoGDBgQgJFBTAkOFBhAAaSnQ4MOLEiQAIAgjAMcDGjgcLDhhJsuQAgwBIphy58uTCjxxhehSw8OLFmjYlZrSYkybBnhR/OsSZESLPoQkrokwYEAAh+QQFkAEEACwAAAAADwAPAAAIKgAJCBxIsKDBgwgTIgTAEIDBhg4HSBygsKLFgRAJTKSoMOPFjyBDihQZEAAh+QQFkAEEACwAAAAADwAPAAAIMQAJCBxIsKDBgwgTDgTAEAABARAFGBxAcQCBhg4VatwosKJFjAZBRpTIsaTJkyhRBgQAIfkEBVgCBAAsAAAAAA8ADwAACDEACQgcSLCgwYMIEw4UwFAAAQAQARiMKHGAxQEKM2ocSJHARYwFGzrsuLGkyZMoUQYEACH5BAVYAgQALAAAAAAPAA8AAAgxAAkIHEiwoMGDCBMOBMAQAAEBEAUYHEBxAIGGDhVq3CiwokWMBkFGlMixpMmTKFEGBAA7" width="16" height="16" />'

		},
		'_ROLLEYES': {

			'start': ':rolleyes: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,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%3D" width="16" height="16" />'

		},
		'_UP': {

			'start': ':up: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhDwAPAPcAAHRiGop1IpiCKru7u0lBG82yR1FHIZ6MQoV1N93CVcOsT6SSSOXKX6yZTsCrVndrOYd5QVtTLf/jdcKuXP/mg+TMbGNZM//ojerScsezY6SUVjErE1ZMKDs1HeaiAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAMALAAAAAAPAA8AQAibAAcI/EBQoMGDDCRcuIBBQgMDGw44cBCh4IAPCip8OMiRYAABATYQWOBgAQeLAxVQwLCR48AFCTNYyMAAwoYOCBQ4+HCgQIKfBzYYWDBhQsWWBgkqVdpxQYUMSF1eVAlV6sADDDQuXTqgAoWVEDI4HOrgwYEFHwokpCDBgQEEBzhwaDBBw4ePBQoIIABXLl27ST8AGHyTKOABAQEAOw%3D%3D" width="16" height="16" />'

		},
		'_DOWN': {

			'start': ':down: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhDwAPAPcAAIZjHp11KbGFMdjY2LuPOz4wFlNCH9KuaLaSTJl6P+PAe8+ub7iXWFdHJ7ueZevKi8yvdolwQWlYNf/kr86zfv/pv+7SnHJhPNS5hLObbS8iC2NRLUM3IZt/Tf+VCwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAAAMALAAAAAAPAA8AQAidAAcI/ECwIEGBAyEsSMChQIcHGC5gmPCAwYcBHxpIoECBQYMCCBSIPEAAoUmMFiYQuIgw4wYGEBgY0BBAQICCHCRAgICgQAMHEzB0SPngpMkPFhawNIqwgAYNJz9k6NgQgNWDA6c62LABQQIDAg4csCmVwtauCRpAmEBUKQMEEWL+DNoBQ4UKFjAaNGjhAYKlRj/YPQA4MIYHNwUGBAA7" width="16" height="16" />'

		},

		'_LOL': {

			'start': ':lol: ',

			'end': '',

			'text': '<img src="data:image/gif;base64,R0lGODlhDwAPAIMDAf///729vVn/yMDAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH/C05FVFNDQVBFMi4wAwEAAAAh+QQJCgADACwAAAAADwAPAAMEN3BISWqdeFTAgc1b5wkXRVqWcJqkSKjXq7bcK1cznM547vOyn68nzBE0RR4reVz+mhOiLhNFZQAAIfkECRQAAwAsAAAAAA8ADwADBD1wSElqnXhUwfnFhGd1xBQKBKCGZ6mh6uqhr2XPKBvLZw7vPdEvxiKxbBuUpwacuVpEJY0iSk5NwVwGa8kAACH5BAkKAAMALAAAAAAPAA8AAwQ3cEhJap14VMCBzVvnCRdFWpZwmqRIqNerttwrVzOcznju87KfryfMETRFHit5XP6aE6IuE0VlAAAh+QQJFAADACwAAAAADwAPAAMELXBISWqdeFTB+cVEJ3pTOI4EdaLaem6uCMeeSQszndpu2saf38pX4uGIGUtQAgAh/wtQSUFOWUdJRjEuMK1iaWdncmluMS5naWYCQzpczO7oIOTu6vPs5e3y+1xiaWdncmluMS5naWYBYmlnZ3JpbjIuZ2lmAkM6XMzu6CDk7urz7OXt8vtcYmlnZ3JpbjIuZ2lmAWJpZ2dyaW4xLmdpZgJDOlzM7ugg5O7q8+zl7fL7XGJpZ2dyaW4xLmdpZgFiaWdncmluMy5naWYCQzpczO7oIOTu6vPs5e3y+1xiaWdncmluMy5naWYBjAA7" width="16" height="16" />'

		},
	},
	init: function(){
		this._BLOG_AREA = document.getElementsByTagName("textarea")[0];
		if(!this._BLOG_AREA){
			return;
		}
		this._createToolbar();
	},
	_createToolbar: function(){
		var toolbar = document.createElement('div');
		this._BLOG_AREA.parentNode.insertBefore(toolbar, this._BLOG_AREA);
		var base = this;
        toolbar.addEventListener('click', function(ev){
            base.replaceRange(ev);
            ev.preventDefault();
            ev.stopPropagation();
        },false); 		
		for(var id in this._WRAPPERS){
			var wrapper = this._WRAPPERS[id];
			var button = document.createElement('button');
			button.id = id;
			button.innerHTML = wrapper.text;
			toolbar.appendChild(button);
		}
	},
	replaceRange: function(ev){
		var method = ev.target.id;
		var wrapper = this._WRAPPERS[method];
		var val = this._BLOG_AREA.value;

		var len = val.length;

		var start = this._BLOG_AREA.selectionStart;
		var end = this._BLOG_AREA.selectionEnd;

		if (method == '_EMAIL') {
   
            email = prompt('შეიყვანეთ ელ-ფოსტის მისამართი', 'user@domain.com');

            if (email) {
                wrapper.start = '[email]' + email;
                wrapper.end   = '[/email]';
            } else {
                return false;
            }
        }
		
		
		

       if (method == '_SIZE') {
			var selection = val.substring(start, end);
   
            size = prompt('შეიყვანეთ სასურველი ზომა', '7');

            if (size) {
                wrapper.start = '[size=' + size + ']' 
                wrapper.end   = '[/size]';
            } else {
                return false;
            }
        }
		
		if (method == '_COLOR') {
			var selection = val.substring(start, end);
   
            color = prompt('შეიყვანეთ სასურველი ფერი, თქვენ შეგიძლიათ გამოიყენოთ შემდეგი ფერები: aqua, black, blue, fuchsia, gray, grey, green, lime, maroon, navy, olive, purple, red, silver, teal, white, და yellow.', 'red');

            if (color) {
                wrapper.start = '[color=' + color + ']' 
                wrapper.end   = '[/color]';
            } else {
                return false;
            }
        }
		
		if (method == '_FONT') {
			var selection = val.substring(start, end);
   
            font = prompt('შეიყვანეთ შრიფტის დასახელება (მოქმედებს მხოლოდ ინგლისურ სიმბოლოებზე) თქვენ შეგიძლიათ გამოიყენოთ შემდეგი შრიფტები: algerian, braggadocio, chicago, desdemona, fantasy, cursive, marlett, playbill, symbol, webdings, wingdings ა.შ');

            if (font) {
                wrapper.start = '[font=' + font + ']' 
                wrapper.end   = '[/font]';
            } else {
                return false;
            }
        }
		
		else if (method == '_URL') {
            var selection = wrapper.start+val.substring(start, end)+wrapper.end;

            url = prompt('შეიყვანეთ საიტის ბმული', 'www.chromer.wordpress.com');

            if (url) {
                wrapper.start = '[url=' + url + ']';

            } else {
                return false;
            }
        }

		
		
		if (method == '_YOUTUBE') {
   
            youtube = prompt('შეიყვანეთ Youtube-ს ბმულის ის ნაწილი რომელიც http://www.youtube.com/watch?v= ს მერე მდებარეობს ', 'Vqfb6sfH-0U');

            if (youtube) {
                wrapper.start = '[youtube]' + youtube;
                wrapper.end   = '[/youtube]';
            } else {
                return false;
            }
        }
		
		if (method == '_MYVIDEO') {
   
            myvideo = prompt('შეიყვანეთ MYVIDEO-ს ბმულის ის ნაწილი რომელიც http://www.myvideo.ge/?video_id= ს მერე მდებარეობს ', '123456789');

            if (myvideo) {
                wrapper.start = '[myvideo]' + myvideo;
                wrapper.end   = '[/myvideo]';
            } else {
                return false;
            }
        }

		if (method == '_IMG') {
   
            img = prompt('შეიყვანეთ სურათის ბმული', '');

            if (img) {
                wrapper.start = '[img]' + img;
                wrapper.end   = '[/img]';
            } else {
                return false;
            }
        }
		
		if (method == '_SOUNDCLOUD') {
   
            soundcloud = prompt('შეიყვანეთ SoundCloud-ზე განთავსებული სიმღერის ბმული', '');

            if (soundcloud) {
                wrapper.start = '[sc]' + soundcloud;
                wrapper.end   = '[/sc]';
            } else {
                return false;
            }
        }
		
		var replaced = wrapper.start+val.substring(start, end)+wrapper.end;
		
		this._BLOG_AREA.value = val.substring(0, start) + replaced + val.substring(end, len);
		this._BLOG_AREA.selectionStart = start;
		this._BLOG_AREA.selectionEnd = end+wrapper.start.length+wrapper.end.length;
	}
	
	
};


_FORMAT_TOOLBAR.init();




//Show Character Count onMouseOver script by Alan Berman

(function() {
  var inputs, input;
  inputs = document.evaluate(
    '//textarea',
    document,
    null,
    XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE,
    null);
  if(!inputs.snapshotLength) return;
  for(var i = 0; i < inputs.snapshotLength; i++) {
    input = inputs.snapshotItem(i);
    input.addEventListener('mouseover', function(event) {
      this.title = this.value.length;
    }, false);
  }
})();