#ifndef _DCIIO_H_INCLUDED_
#define _DCIIO_H_INCLUDED_

#ifdef __cplusplus
extern "C"
{
#endif
/************************************************************/

/* drv version */
#define DCIIO_VER 20080216

/* drv names */
#define DCIIO_DRIVER_NAME     L"dciiodrv"
#define DCIIO_USERMODE_NAME   L"\\\\.\\dciio"
#define DCIIO_WIN_DEVICE_NAME L"\\Device\\dciio"
#define DCIIO_DOS_DEVICE_NAME L"\\DosDevices\\dciio"

/* OLS macros */
#define PciBusDevFunc(Bus, Dev, Func)	((Bus&0xFF)<<8) | ((Dev&0x1F)<<3) | (Func&7)
#define PciGetBus(address)				((address>>8) & 0xFF)
#define PciGetDev(address)				((address>>3) & 0x1F)
#define PciGetFunc(address)				(address&7)

/* ctlcodes */
#define FILE_DEVICE_DCI            0x8800
/* driver info */
#define IOCTL_DCIIO_VERSION        CTL_CODE ( FILE_DEVICE_DCI, 0x881, METHOD_BUFFERED, FILE_READ_DATA )
#define IOCTL_DCIIO_REFCOUNT       CTL_CODE ( FILE_DEVICE_DCI, 0x882, METHOD_BUFFERED, FILE_READ_DATA )
/* registers */
//#define IOCTL_DCIIO_MSR_READ       CTL_CODE ( FILE_DEVICE_DCI, 0x891, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
//#define IOCTL_DCIIO_MSR_WRITE      CTL_CODE ( FILE_DEVICE_DCI, 0x892, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
//#define IOCTL_DCIIO_PMC_READ       CTL_CODE ( FILE_DEVICE_DCI, 0x893, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
/* io ports */
#define IOCTL_DCIIO_IO_BYTE_READ   CTL_CODE ( FILE_DEVICE_DCI, 0x8A1, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
#define IOCTL_DCIIO_IO_BYTE_WRITE  CTL_CODE ( FILE_DEVICE_DCI, 0x8A2, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
//#define IOCTL_DCIIO_IO_WORD_READ   CTL_CODE ( FILE_DEVICE_DCI, 0x8A3, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
//#define IOCTL_DCIIO_IO_WORD_WRITE  CTL_CODE ( FILE_DEVICE_DCI, 0x8A4, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
//#define IOCTL_DCIIO_IO_DWORD_READ  CTL_CODE ( FILE_DEVICE_DCI, 0x8A5, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
//#define IOCTL_DCIIO_IO_DWORD_WRITE CTL_CODE ( FILE_DEVICE_DCI, 0x8A6, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
/* pci config memory */
#define IOCTL_DCIIO_PCI_CONF_READ  CTL_CODE ( FILE_DEVICE_DCI, 0x8B1, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
#define IOCTL_DCIIO_PCI_CONF_WRITE CTL_CODE ( FILE_DEVICE_DCI, 0x8B2, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
/* system memory */
//#define IOCTL_DCIIO_MEM_VIRT_READ  CTL_CODE ( FILE_DEVICE_DCI, 0x8C1, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
//#define IOCTL_DCIIO_MEM_VIRT_WRITE CTL_CODE ( FILE_DEVICE_DCI, 0x8C2, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
//#define IOCTL_DCIIO_MEM_PHYS_READ  CTL_CODE ( FILE_DEVICE_DCI, 0x8C3, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )
//#define IOCTL_DCIIO_MEM_PHYS_WRITE CTL_CODE ( FILE_DEVICE_DCI, 0x8C4, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA )

/* param structures */
#pragma pack(push,4)

typedef struct dciio_msr_write_tag
{
	DWORD reg;
	ULONGLONG val;
}
dciio_msr_write_t;

typedef struct dciio_port_write_tag
{
	DWORD port;
	DWORD data;
}
dciio_port_write_t;



typedef struct dciio_memhdr_tag
{
	ULONGLONG addr;
	DWORD size;
}
dciio_memhdr_t;

typedef struct dciio_pcihdr_tag
{
	ULONG addr;
	ULONG offs;
	ULONG size;
}
dciio_pcihdr_t;


#pragma pack(pop)

/************************************************************/
#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
