/*
* eeectl
* Copyright (C) 2008 Anthony A Z <dci@cpp.in>
* http://www.cpp.in/dev/eeectl/
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <windows.h>
#include "runtime.h"
#include "eeehw.h"
#include "ss_temp.h"


eeectl_loader_t * gcore;

unsigned char oldt;

unsigned char get_t ( BOOL f )
{
	unsigned short ret = oldt ? oldt : eeehw_temp_get ( );
	if ( f ) ret = ( ( ret * 9 ) / 5 ) + 32;
	return ( unsigned char ) ret;
}

BOOL temp_init ( eeectl_loader_t * core )
{
	gcore = core;
	return TRUE;
}

void temp_save ( ) { }
void temp_stop ( BOOL restart ) { }
void temp_suspend ( ) { }
void temp_resume ( ) { }

UINT temp_icontxt ( wchar_t * icon, wchar_t * txt, size_t max )
{
	return wsprintf ( txt, /* ':' means '' here */ L"%d:", get_t ( ( 'F' == * icon ) ) );
}

UINT temp_menucrt ( HMENU menu, UINT base )
{
	wchar_t menucap [ 64 ];
	wsprintf ( menucap, L"%dC / %dF", get_t ( FALSE ), get_t ( TRUE ) );
	AppendMenu ( menu, MF_BYCOMMAND | MF_STRING | MF_GRAYED, base, menucap ); 
	return base + 1;
}

BOOL temp_menuclk ( UINT id ) { return FALSE; }

BOOL temp_ntfevnt ( wchar_t * evname ) { return FALSE; }

void temp_ntftime ( )
{
	unsigned char newt = eeehw_temp_get ( );
	if ( newt != oldt ) gcore->ntf_icon_upd ( &eeectl_subsys_temp, NULL );
	oldt = newt;
}

eeectl_subsys_t eeectl_subsys_temp = { L"Temp", L"eeectl temperature control module", temp_init, temp_save, temp_stop, temp_suspend, temp_resume, temp_icontxt, temp_menucrt, temp_menuclk, temp_ntfevnt, temp_ntftime };
