/*
* eeectl
* Copyright (C) 2008 Anthony A Z <dci@cpp.in>
* http://www.cpp.in/dev/eeectl/
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <windows.h>
#include "runtime.h"
#include "table.h"

sth_t st_create  ( unsigned long width )
{
	stringtable_t * data = ( stringtable_t * ) mmalloc ( sizeof ( stringtable_t ) );
	data->width  = width;
	data->height = 0;
	data->rows   = ( wchar_t * * * ) mmalloc ( sizeof ( wchar_t * * ) );
	return ( sth_t ) data;
}

void st_destroy ( sth_t table )
{
	while ( st_row_del ( table, 0 ) );
	mfree ( ( ( stringtable_t * ) table )->rows );
	mfree ( ( ( stringtable_t * ) table ) );
}

unsigned long st_width  ( sth_t table )
{
	return ( ( stringtable_t * ) table )->width;
}

unsigned long st_height ( sth_t table )
{
	return ( ( stringtable_t * ) table )->height;
}

unsigned long st_row_add ( sth_t table )
{
	stringtable_t * t = ( stringtable_t * ) table;
	t->rows = ( wchar_t * * * ) mrealloc ( t->rows, ( ++t->height ) * sizeof ( wchar_t * * ) );
	t->rows [ t->height - 1 ] = ( wchar_t * * ) mmalloc ( t->width * sizeof ( wchar_t * ) );
	mmemset ( t->rows [ t->height - 1 ], 0, t->width * sizeof ( wchar_t * ) );
	return t->height - 1;
}

unsigned long st_row_del ( sth_t table, unsigned long row )
{
	stringtable_t * t = ( stringtable_t * ) table;
	if ( row < t->height )
	{
		unsigned long i;
		for ( i = 0; i < t->width; ++i )
		{
			if ( t->rows [ row ] [ i ] ) mfree ( t->rows [ row ] [ i ] );
		}
		mfree ( t->rows [ row ] );
		for ( i = row; i < ( t->height - 1 ); ++i ) t->rows [ i ] = t->rows [ i + 1 ];
		--t->height;
	}
	return t->height;
}

wchar_t * st_value_get ( sth_t table, unsigned long row, unsigned long column )
{
	stringtable_t * t = ( stringtable_t * ) table;
	return ( ( row < t->height ) && ( column < t->width ) && ( t->rows [ row ] [ column ] ) ) ? ( t->rows [ row ] [ column ] ) : L"";
}

wchar_t * st_value_set ( sth_t table, unsigned long row, unsigned long column, wchar_t * value )
{
	stringtable_t * t = ( stringtable_t * ) table;
	if ( ( row < t->height ) && ( column < t->width ) )
	{
		if ( t->rows [ row ] [ column ] ) mfree ( t->rows [ row ] [ column ] );
		t->rows [ row ] [ column ] = value ? mwcsdup ( value ) : NULL;
		return value;
	}
	return NULL;
}


unsigned long st_serial_read  ( sth_t table, wchar_t * serialized )
{
	unsigned long ret = 0;
	wchar_t * readrow = serialized;
	while ( readrow && ( * readrow ) )
	{
		wchar_t * readcol = readrow;
		unsigned long row = st_row_add ( table ), col = 0;
		/* first of all, find next row */
		wchar_t * readnextrow = mwcschr ( readrow, ';' );
		if ( readnextrow )
		{
			* readnextrow = 0;
			while ( ' ' == * ( ++readnextrow ) ); 
		}
		else readnextrow = readrow + mwcslen ( readrow );
		/* read cols */
		while ( readcol && ( * readcol ) )
		{
			/* find next element */
			wchar_t * readnextcol = mwcschr ( readcol, ',' );
			if ( readnextcol )
			{
				* readnextcol = 0;
				while ( ' ' == * ( ++readnextcol ) ); 
			}
			else readnextcol = readcol + mwcslen ( readcol );
			/* save current */
			st_value_set ( table, row, col, readcol );
			/* next */
			++col;
			readcol = readnextcol;
		}
		/* next */
		readrow = readnextrow;
		++ret;
	}
	return ret;
}

unsigned long st_serial_write ( sth_t table, wchar_t * serialized, unsigned long max_count )
{
	/* no, i'm too lazy */
	return 0;
}
