/*
* eeectl
* Copyright (C) 2008 Anthony A Z <dci@cpp.in>
* http://www.cpp.in/dev/eeectl/
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <windows.h>
#include <setupapi.h>
#include "runtime.h"
#include "dciio.h"


SC_HANDLE hServiceControl   = NULL;
SC_HANDLE hDriver           = NULL;
HANDLE    hDriverIO         = NULL;
DWORD     dwIOErrorPoint    = 0;
DWORD     dwIOErrorValue    = 0;

BYTE      bDriverBinary [ ] = 
#include "../dciiodrv/dciiodrv.inc"


BOOL dciIOStart ( )
{
	BOOL ret = TRUE;
	wchar_t szBinaryFile [ MAX_PATH ];
	dwIOErrorPoint = dwIOErrorValue = 0x00;
	mmemset ( szBinaryFile, 0, sizeof ( szBinaryFile ) );
	/* already started? */
	if ( hServiceControl )
	{
		dwIOErrorPoint = 0x01;
		dwIOErrorValue = 0x01;
		ret = FALSE;
	}
	else
	{
		hDriver   = NULL;
		hDriverIO = NULL;
	}
	/* try to open scm */
	if ( TRUE == ret )
	{
		hServiceControl = OpenSCManager ( NULL, NULL, SC_MANAGER_ALL_ACCESS );
		if ( NULL == hServiceControl )
		{
			dwIOErrorPoint = 0x02;
			dwIOErrorValue = GetLastError ( );
			ret = FALSE;
		}
	}
	/* try to open loaded driver */
	if ( TRUE == ret )
	{
		hDriver = OpenService ( hServiceControl, DCIIO_DRIVER_NAME, SERVICE_ALL_ACCESS );
		if ( hDriver )
		{
			/* try to read driver data */
			DWORD ver = 0, refs = 0;
			if ( ( TRUE == StartService ( hDriver, 0, NULL ) ) || ( ERROR_SERVICE_ALREADY_RUNNING == GetLastError ( ) ) )
			{
				hDriverIO = CreateFile ( DCIIO_USERMODE_NAME, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
				if ( INVALID_HANDLE_VALUE != hDriverIO )
				{
					DWORD dummy;
					DeviceIoControl ( hDriverIO, IOCTL_DCIIO_VERSION, NULL, 0, &ver, sizeof ( ver ), &dummy, NULL );
					DeviceIoControl ( hDriverIO, IOCTL_DCIIO_REFCOUNT, NULL, 0, &refs, sizeof ( ver ), &dummy, NULL );
				}
				else hDriverIO = NULL;
			}
			else
			{ /* emulate free driver for deletion process */
				refs = 1;
			}
			/* check */
			if ( ( DCIIO_VER != ver ) || ( NULL == hDriverIO ) )
			{
				/* free io */
				if ( hDriverIO ) CloseHandle ( hDriverIO );
				hDriverIO = NULL;
				/* is drv free? */
				if ( 1 == refs )
				{ /* unload wrong version drv & continue */
					SERVICE_STATUS st;
					ControlService ( hDriver, SERVICE_CONTROL_STOP, &st );
					DeleteService ( hDriver );
				}
				else
				{ /* driver busy or unknown. anyway we have nothing to do. */
					dwIOErrorPoint = 0x03;
					dwIOErrorPoint = 0x01;
					ret = FALSE;
				}
				/* common finish */
				CloseServiceHandle ( hDriver );
				hDriver = NULL;
				Sleep ( 200 );
			}
		}
	}
	/* try to write new drv binary */
	if ( ( TRUE == ret ) && ( NULL == hDriver ) )
	{
		HANDLE hBinaryFile;
		/* create binary path */
		GetSystemDirectory ( szBinaryFile, MAX_PATH );
		mwcscat ( szBinaryFile, L"\\drivers\\" );
		mwcscat ( szBinaryFile, DCIIO_DRIVER_NAME );
		mwcscat ( szBinaryFile, L".sys" );
		/* write service binary */
		hBinaryFile = CreateFile ( szBinaryFile, GENERIC_WRITE, 0, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_HIDDEN, NULL );
		if ( INVALID_HANDLE_VALUE != hBinaryFile )
		{
			DWORD dummy;
			WriteFile ( hBinaryFile, bDriverBinary, sizeof ( bDriverBinary ), &dummy, NULL );
			CloseHandle ( hBinaryFile );
		}
		else
		{
			dwIOErrorPoint = 0x04;
			dwIOErrorValue = GetLastError ( );
			ret = FALSE;
		}
	}
	/* try to load driver */
	if ( ( TRUE == ret ) && ( NULL == hDriver ) )
	{
		/* try to add driver record */
		int retr = 10;
		while ( ( 0 < --retr ) && ( NULL == ( hDriver = CreateService ( hServiceControl, DCIIO_DRIVER_NAME, DCIIO_DRIVER_NAME, SERVICE_ALL_ACCESS, SERVICE_KERNEL_DRIVER, SERVICE_DEMAND_START, SERVICE_ERROR_NORMAL, szBinaryFile, NULL, NULL, NULL, NULL, NULL ) ) ) ) Sleep ( 200 );
		if ( hDriver )
		{ /* try to start driver */
			retr = 11;
			while ( ( 0 < --retr ) && ( FALSE == StartService ( hDriver, 0, NULL ) ) ) Sleep ( 200 );
			if ( 0 == retr )
			{
				dwIOErrorPoint = 0x06;
				dwIOErrorValue = GetLastError ( );
				ret = FALSE;
			}
		}
		else
		{
			dwIOErrorPoint = 0x05;
			dwIOErrorValue = GetLastError ( );
			ret = FALSE;
		}
	}
	/* try to open IO */
	if ( ( TRUE == ret ) && ( NULL == hDriverIO ) )
	{
		hDriverIO = CreateFile ( DCIIO_USERMODE_NAME, GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL );
		if ( INVALID_HANDLE_VALUE == hDriverIO )
		{
			dwIOErrorPoint = 0x07;
			dwIOErrorValue = GetLastError ( );
			ret = FALSE;
		}
	}
	/* check version */
	if ( TRUE == ret )
	{
		DWORD ver = 0, dummy;
		DeviceIoControl ( hDriverIO, IOCTL_DCIIO_VERSION, NULL, 0, &ver, sizeof ( ver ), &dummy, NULL );
		if ( DCIIO_VER != ver )
		{
			dwIOErrorPoint = 0x08;
			dwIOErrorValue = 0x01;
			ret = FALSE;
		}
	}
	/* some additional init/fallback steps may be here */
	/*****/
	/*****/
	/*****/
	/*****/
	/* need to close io? */
	if ( ( FALSE == ret ) && ( 0x07 < dwIOErrorPoint ) )
	{
		CloseHandle ( hDriverIO );
		hDriverIO = NULL;
	}
	/* need to stop driver? */
	if ( ( FALSE == ret ) && ( 0x06 < dwIOErrorPoint ) )
	{
		SERVICE_STATUS st;
		ControlService ( hDriver, SERVICE_CONTROL_STOP, &st );
	}
	/* need to remove driver record? */
	if ( ( FALSE == ret ) && ( 0x05 < dwIOErrorPoint ) )
	{
		DeleteService ( hDriver );
		CloseServiceHandle ( hDriver );
		hDriver = NULL;
		Sleep ( 200 );
	}
	/* need to delete driver binary? */
	if ( ( FALSE == ret ) && ( 0x04 < dwIOErrorPoint ) )
	{
		DeleteFile ( szBinaryFile );
	}
	/* need to close scm? */
	if ( ( FALSE == ret ) && ( 0x02 < dwIOErrorPoint ) )
	{
		CloseServiceHandle ( hServiceControl );
		hServiceControl = NULL;
	}
	/* */
	return ret;
}

BOOL dciIOStop ( )
{
	BOOL bDrvInUse = FALSE;
	dwIOErrorPoint = dwIOErrorValue = 0x00;
	/* io interface opened? */
	if ( hDriverIO )
	{
		DWORD refcount = 0, dummy = 0;
		/* read refcount */
		if ( DeviceIoControl ( hDriverIO, IOCTL_DCIIO_REFCOUNT, NULL, 0, &refcount, sizeof ( refcount ), &dummy, NULL ) && dummy )
		{
			if ( refcount > 1 ) bDrvInUse = TRUE;
		}
		/* close io */
		CloseHandle ( hDriverIO );
		hDriverIO = NULL;
	}
	/* driver loaded? */
	if ( hDriver )
	{
		/* if drv not in use -- stop it and remove its record */
		if ( FALSE == bDrvInUse )
		{
			SERVICE_STATUS st;
			ControlService ( hDriver, SERVICE_CONTROL_STOP, &st );
			DeleteService ( hDriver );
		}
		/* */
		CloseServiceHandle ( hDriver );
		hDriver = NULL;
		/* delete file, if not in use */
		if ( FALSE == bDrvInUse )
		{
			wchar_t szBinaryFile [ MAX_PATH ];
			GetSystemDirectory ( szBinaryFile, MAX_PATH );
			mwcscat ( szBinaryFile, L"\\drivers\\" );
			mwcscat ( szBinaryFile, DCIIO_DRIVER_NAME );
			mwcscat ( szBinaryFile, L".sys" );
			DeleteFile ( szBinaryFile );
		}
	}
	/* scm opened? */
	if ( hServiceControl )
	{
		CloseServiceHandle ( hServiceControl );
		hServiceControl = NULL;
		return TRUE;
	}
	/* */
	dwIOErrorPoint = 0x11;
	dwIOErrorValue = 0x01;
	return FALSE;
}

DWORD dciIOErrorPoint ( )
{
	return dwIOErrorPoint;
}

DWORD dciIOErrorValue ( )
{
	return dwIOErrorValue;
}

#ifdef IOCTL_DCIIO_MSR_READ
ULONGLONG dciIOMsrRead ( DWORD reg )
{
	DWORD dummy;
	ULONGLONG ret = 0;
	dwIOErrorPoint = dwIOErrorValue = 0x00;
	if ( FALSE == DeviceIoControl ( hDriverIO, IOCTL_DCIIO_MSR_READ, &reg, sizeof ( reg ), &ret, sizeof ( ret ), &dummy, NULL ) )
	{
		dwIOErrorPoint = 0x21;
		dwIOErrorValue = GetLastError ( );
		ret = 0;
	}
	return ret;
}
#endif
#ifdef IOCTL_DCIIO_MSR_WRITE
VOID dciIOMsrWrite ( DWORD reg, ULONGLONG val )
{
	DWORD dummy;
	dciio_msr_write_t packet;
	dwIOErrorPoint = dwIOErrorValue = 0x00;
	packet.reg = reg;
	packet.val = val;
	if ( FALSE == DeviceIoControl ( hDriverIO, IOCTL_DCIIO_MSR_WRITE, &packet, sizeof ( packet ), NULL, 0, &dummy, NULL ) )
	{
		dwIOErrorPoint = 0x21;
		dwIOErrorValue = GetLastError ( );
	}
}
#endif
#ifdef IOCTL_DCIIO_PMC_READ
ULONGLONG dciIOPmcRead ( DWORD reg )
{
	DWORD dummy;
	ULONGLONG ret = 0;
	dwIOErrorPoint = dwIOErrorValue = 0x00;
	if ( FALSE == DeviceIoControl ( hDriverIO, IOCTL_DCIIO_PMC_READ, &reg, sizeof ( reg ), &ret, sizeof ( ret ), &dummy, NULL ) )
	{
		dwIOErrorPoint = 0x21;
		dwIOErrorValue = GetLastError ( );
		ret = 0;
	}
	return ret;
}
#endif

#ifdef IOCTL_DCIIO_IO_BYTE_READ
BYTE dciIOPortByteRead ( DWORD port )
{
	DWORD dummy;
	BYTE ret = 0;
	dwIOErrorPoint = dwIOErrorValue = 0x00;
	if ( FALSE == DeviceIoControl ( hDriverIO, IOCTL_DCIIO_IO_BYTE_READ, &port, sizeof ( port ), &ret, sizeof ( ret ), &dummy, NULL ) )
	{
		dwIOErrorPoint = 0x21;
		dwIOErrorValue = GetLastError ( );
		ret = 0;
	}
	return ret;
}
#endif
#ifdef IOCTL_DCIIO_IO_BYTE_WRITE
VOID dciIOPortByteWrite ( DWORD port, BYTE val )
{
	DWORD dummy;
	dciio_port_write_t packet;
	dwIOErrorPoint = dwIOErrorValue = 0x00;
	packet.port = port;
	packet.data = val;
	if ( FALSE == DeviceIoControl ( hDriverIO, IOCTL_DCIIO_IO_BYTE_WRITE, &packet, sizeof ( packet ), NULL, 0, &dummy, NULL ) )
	{
		dwIOErrorPoint = 0x21;
		dwIOErrorValue = GetLastError ( );
	}
}
#endif
#ifdef IOCTL_DCIIO_IO_WORD_READ
WORD dciIOPortWordRead ( DWORD port );
#endif
#ifdef IOCTL_DCIIO_IO_WORD_WRITE
VOID dciIOPortWordWrite ( DWORD port, WORD val );
#endif
#ifdef IOCTL_DCIIO_IO_DWORD_READ
DWORD dciIOPortDWordRead ( DWORD port );
#endif
#ifdef IOCTL_DCIIO_IO_DWORD_WRITE
VOID dciIOPortDWordWrite ( DWORD port, DWORD val );
#endif

#ifdef IOCTL_DCIIO_PCI_CONF_READ
UINT dciIOPCIConfRead ( UINT bus, UINT device, UINT function, UINT offset, UINT size, BYTE * buffer )
{
	UINT ret = 0;
	dciio_pcihdr_t pcihdr;
	pcihdr.addr = PciBusDevFunc ( bus, device, function );
	pcihdr.offs = offset;
	pcihdr.size = size;
	if ( FALSE == DeviceIoControl ( hDriverIO, IOCTL_DCIIO_PCI_CONF_READ, &pcihdr, sizeof ( pcihdr ), buffer, size, &ret, NULL ) )
	{
		dwIOErrorPoint = 0x21;
		dwIOErrorValue = GetLastError ( );
		ret = 0;
	}
	return ret;
}
#endif

#ifdef IOCTL_DCIIO_PCI_CONF_WRITE
UINT dciIOPCIConfWrite ( UINT bus, UINT device, UINT function, UINT offset, UINT size, BYTE * buffer )
{
	UINT ret = 0;
	dciio_pcihdr_t * pcipack = mmalloc ( sizeof ( dciio_pcihdr_t ) + size );
	pcipack->addr = PciBusDevFunc ( bus, device, function );
	pcipack->offs = offset;
	pcipack->size = size;
	mmemcpy ( pcipack + 1, buffer, size );
	if ( FALSE == DeviceIoControl ( hDriverIO, IOCTL_DCIIO_PCI_CONF_WRITE, pcipack, sizeof ( dciio_pcihdr_t ) + size, NULL, 0, &ret, NULL ) )
	{
		dwIOErrorPoint = 0x21;
		dwIOErrorValue = GetLastError ( );
		ret = 0;
	}
	mfree ( pcipack );
	return ret;
}
#endif

#ifdef IOCTL_DCIIO_MEM_VIRT_READ
DWORD dciIOMemVirtRead ( ULONGLONG memaddr, void * buffer, DWORD amount )
{
	DWORD ret = 0;
	dciio_memhdr_t hdr;
	dwIOErrorPoint = dwIOErrorValue = 0x00;
	hdr.addr = memaddr;
	hdr.size = amount;
	if ( FALSE == DeviceIoControl ( hDriverIO, IOCTL_DCIIO_MEM_VIRT_READ, &hdr, sizeof ( hdr ), buffer, amount, &ret, NULL ) )
	{
		dwIOErrorPoint = 0x21;
		dwIOErrorValue = GetLastError ( );
		ret = 0;
	}
	return ret;
}
#endif
#ifdef IOCTL_DCIIO_MEM_VIRT_WRITE
DWORD dciIOMemVirtWrite ( ULONGLONG memaddr, void * buffer, DWORD amount );
#endif
#ifdef IOCTL_DCIIO_MEM_PHYS_READ
DWORD dciIOMemPhysRead ( ULONGLONG memaddr, void * buffer, DWORD amount )
{
	DWORD ret = 0;
	dciio_memhdr_t hdr;
	dwIOErrorPoint = dwIOErrorValue = 0x00;
	hdr.addr = memaddr;
	hdr.size = amount;
	if ( FALSE == DeviceIoControl ( hDriverIO, IOCTL_DCIIO_MEM_PHYS_READ, &hdr, sizeof ( hdr ), buffer, amount, &ret, NULL ) )
	{
		dwIOErrorPoint = 0x21;
		dwIOErrorValue = GetLastError ( );
		ret = 0;
	}
	return ret;
}
#endif
#ifdef IOCTL_DCIIO_MEM_PHYS_WRITE
DWORD dciIOMemPhysWrite ( ULONGLONG memaddr, void * buffer, DWORD amount )
{
	DWORD ret;
	DWORD  ibuf = amount + sizeof ( dciio_memhdr_t );
	void * tbuf = mmalloc ( ibuf );
	dwIOErrorPoint = dwIOErrorValue = 0x00;
	( ( dciio_memhdr_t * ) tbuf )->addr = memaddr;
	( ( dciio_memhdr_t * ) tbuf )->size = amount;
	mmemcpy ( ( ( dciio_memhdr_t * ) tbuf ) + 1, buffer, amount );
	if ( FALSE == DeviceIoControl ( hDriverIO, IOCTL_DCIIO_MEM_PHYS_WRITE, tbuf, ibuf, NULL, 0, &ret, NULL ) )
	{
		dwIOErrorPoint = 0x21;
		dwIOErrorValue = GetLastError ( );
		ret = 0;
	}
	mfree ( tbuf );
	return ret;
}
#endif
