/*
* eeectl
* Copyright (C) 2008 Anthony A Z <dci@cpp.in>
* http://www.cpp.in/dev/eeectl/
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef _DCIACPI_H_INCLUDED_
#define _DCIACPI_H_INCLUDED_

#include <windows.h>
#include "../dciiodrv/dciiodrv.h"


BOOL dciIOStart ( );
BOOL dciIOStop ( );

DWORD dciIOErrorPoint ( );
DWORD dciIOErrorValue ( );


#ifdef IOCTL_DCIIO_MSR_READ
ULONGLONG dciIOMsrRead ( DWORD reg );
#endif
#ifdef IOCTL_DCIIO_MSR_WRITE
VOID dciIOMsrWrite ( DWORD reg, ULONGLONG val );
#endif
#ifdef IOCTL_DCIIO_PMC_READ
ULONGLONG dciIOPmcRead ( DWORD reg );
#endif

#ifdef IOCTL_DCIIO_IO_BYTE_READ
BYTE dciIOPortByteRead ( DWORD port );
#endif
#ifdef IOCTL_DCIIO_IO_BYTE_WRITE
VOID dciIOPortByteWrite ( DWORD port, BYTE val );
#endif
#ifdef IOCTL_DCIIO_IO_WORD_READ
WORD dciIOPortWordRead ( DWORD port );
#endif
#ifdef IOCTL_DCIIO_IO_WORD_WRITE
VOID dciIOPortWordWrite ( DWORD port, WORD val );
#endif
#ifdef IOCTL_DCIIO_IO_DWORD_READ
DWORD dciIOPortDWordRead ( DWORD port );
#endif
#ifdef IOCTL_DCIIO_IO_DWORD_WRITE
VOID dciIOPortDWordWrite ( DWORD port, DWORD val );
#endif

#ifdef IOCTL_DCIIO_PCI_CONF_READ
UINT dciIOPCIConfRead ( UINT bus, UINT device, UINT function, UINT offset, UINT size, BYTE * buffer );
#endif
#ifdef IOCTL_DCIIO_PCI_CONF_WRITE
UINT dciIOPCIConfWrite ( UINT bus, UINT device, UINT function, UINT offset, UINT size, BYTE * buffer );
#endif

#ifdef IOCTL_DCIIO_MEM_VIRT_READ
DWORD dciIOMemVirtRead ( ULONGLONG memaddr, void * buffer, DWORD amount );
#endif
#ifdef IOCTL_DCIIO_MEM_VIRT_WRITE
DWORD dciIOMemVirtWrite ( ULONGLONG memaddr, void * buffer, DWORD amount );
#endif
#ifdef IOCTL_DCIIO_MEM_PHYS_READ
DWORD dciIOMemPhysRead ( ULONGLONG memaddr, void * buffer, DWORD amount );
#endif
#ifdef IOCTL_DCIIO_MEM_PHYS_WRITE
DWORD dciIOMemPhysWrite ( ULONGLONG memaddr, void * buffer, DWORD amount );
#endif



#endif