/*
* eeectl
* Copyright (C) 2008 Anthony A Z <dci@cpp.in>
* http://www.cpp.in/dev/eeectl/
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef _EEECTL_H_INCLUDED_
#define _EEECTL_H_INCLUDED_

#include <windows.h>



#define MSG_DEBUG 0
#define MSG_NTFY  1
#define MSG_WARN  2
#define MSG_ERROR 3
#define MSG_EMERG 4



typedef struct eeectl_loader_tag    eeectl_loader_t;
typedef struct eeectl_subsys_tag    eeectl_subsys_t;



struct eeectl_loader_tag
{
	UINT ( * setup_read )   ( eeectl_subsys_t * subsys, wchar_t * name, wchar_t * buf, UINT num );
	BOOL ( * setup_write )  ( eeectl_subsys_t * subsys, wchar_t * name, wchar_t * buf );
	UINT ( * state_read )   ( eeectl_subsys_t * subsys, wchar_t * name, wchar_t * buf, UINT num );
	BOOL ( * state_write )  ( eeectl_subsys_t * subsys, wchar_t * name, wchar_t * buf );
	void ( * ntf_icon_upd ) ( eeectl_subsys_t * subsys, wchar_t * name );
	void ( * pass_msg )     ( eeectl_subsys_t * subsys, unsigned long level, wchar_t * fmt,... );
};


struct eeectl_subsys_tag
{
	wchar_t * name;
	wchar_t * desc;
	BOOL ( * init ) ( eeectl_loader_t * core );
	void ( * save ) ( );
	void ( * stop ) ( BOOL restart );
	void ( * suspend ) ( );
	void ( * resume  ) ( );
	UINT ( * icontxt ) ( wchar_t * icon, wchar_t * txt, size_t max );
	UINT ( * menucrt ) ( HMENU menu, UINT base );
	BOOL ( * menuclk ) ( UINT id );
	BOOL ( * ntfevnt ) ( wchar_t * evname );
	void ( * ntftime ) ( );
};

#endif