/*
* eeectl
* Copyright (C) 2008 Anthony A Z <dci@cpp.in>
* http://www.cpp.in/dev/eeectl/
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <windows.h>
#include "runtime.h"

/* common */
char mlchar ( char chr )
{
	if ( ( 0x41 <= chr ) && ( 0x5A >= chr ) ) chr += 0x20;
	return chr;
}

char muchar ( char chr )
{
	if ( ( 0x61 <= chr ) && ( 0x7A >= chr ) ) chr -= 0x20;
	return chr;
}

wchar_t mlwchar ( wchar_t chr )
{
	if ( ( 0x41 <= chr ) && ( 0x5A >= chr ) ) chr += 0x20;
	return chr;
}

wchar_t muwchar ( wchar_t chr )
{
	if ( ( 0x61 <= chr ) && ( 0x7A >= chr ) ) chr -= 0x20;
	return chr;
}

/* mem */
char    mem_bad = 0;
wchar_t mem_ebuf [ 128 ];

void * mmalloc ( size_t howmuch )
{
	void * ret = NULL;
	if ( mem_bad )
	{
		ret = LocalAlloc ( LPTR, howmuch );
		wsprintf ( mem_ebuf, L"Memory allocation failed again(%d bytes requested). We're dead.", howmuch );
		MessageBox ( NULL, mem_ebuf, L"dci", MB_ICONSTOP );
	}
	else
	{
		ret = HeapAlloc ( GetProcessHeap ( ), HEAP_ZERO_MEMORY, howmuch );
		if ( NULL == ret )
		{
			mem_bad = 1;
			/* ask for debugger */
			wsprintf ( mem_ebuf, L"Memory allocation failed(%d bytes requested). Do you want to break into debugger?", howmuch );
			if ( IDYES == MessageBox ( NULL, mem_ebuf, L"dci", MB_ICONEXCLAMATION | MB_YESNO ) ) DebugBreak ( );
			/* restart with mem_bad enabled */
			ret = mmalloc ( howmuch );
		}
	}
	/* */
	return ret;
}

void * mrealloc ( void * mem, size_t howmuch )
{
	return mem_bad ? mem : HeapReAlloc ( GetProcessHeap ( ), HEAP_ZERO_MEMORY, mem, howmuch );
}

void mfree ( void * mem )
{
	if ( 0 == mem_bad ) HeapFree ( GetProcessHeap ( ), 0, mem );
}

void * mmemcpy ( void * dest, const void * src, size_t count )
{
	size_t cnt;
	for ( cnt = 0; cnt < count; ++cnt ) ( ( unsigned char * ) dest ) [ cnt ] = ( ( unsigned char * ) src )  [ cnt ];
	return dest;
}

void * mmemset ( void * dest, int c, size_t count )
{
	size_t cnt;
	for ( cnt = 0; cnt < count; ++cnt ) ( ( unsigned char * ) dest ) [ cnt ] = ( unsigned char ) c;
	return dest;
}

int mmemcmp ( const void * buf1, const void * buf2, size_t count )
{
	size_t cnt;
	for ( cnt = 0; cnt < count; ++cnt )
	{
		int dif = ( ( char * ) buf1 ) [ cnt ] - ( ( char * ) buf2 )  [ cnt ];
		if ( dif != 0 ) return dif;
	}
	return 0;
}

int mmemicmp ( const void * buf1, const void * buf2, size_t count )
{
	size_t cnt;
	for ( cnt = 0; cnt < count; ++cnt )
	{
		int dif = mlchar ( ( ( char * ) buf1 ) [ cnt ] ) - mlchar ( ( ( char * ) buf2 )  [ cnt ] );
		if ( dif != 0 ) return dif;
	}
	return 0;
}

/* wchar */
int mwtoi ( wchar_t * str )
{
	int ret = 0;
	wchar_t * ptr = str;
	if ( '-' == * ptr ) ++ptr;
	while ( IS_NUMERIC( * ptr ) )
	{
		ret *= 10;
		ret += ( * ptr - 0x30 );
		++ptr;
	}
	if ( '-' == * str ) ret = -ret;
	return ret;
}

unsigned long mwcstoul ( const wchar_t * nptr, wchar_t ** endptr, int base )
{
	unsigned long ret = 0;
	/* */
	while ( ( ( base >= 2 ) && ( base <= 35 ) ) && ( ( base <= 10 ) ? ( ( * nptr >= 0x30 ) && ( * nptr < ( 0x30 + base ) ) ) : ( IS_NUMERIC( * nptr ) || ( ( mlwchar ( * nptr ) >= 0x61 ) && ( mlwchar ( * nptr ) < ( 0x61 - 10 + base ) ) ) ) ) )
	{
		ret *= base;
		ret += ( ( * nptr <= 0x39 ) ? ( * nptr - 0x30 ) : ( mlwchar ( * nptr ) - 0x61 + 10 ) );
		++nptr;
	}
	/* */
	if ( endptr ) * endptr = ( wchar_t * ) nptr;
	return ret;
}

long mwcstol ( const wchar_t * nptr, wchar_t ** endptr, int base )
{
	int ret;
	int neg = 0;
	if ( '-' == * nptr )
	{
		neg = 1;
		++nptr;
	}
	ret = ( long ) mwcstoul ( nptr, endptr, base );
	if ( neg ) ret *= ( -1 );
	return ret;
}

size_t mwcslen ( wchar_t * str )
{
	size_t ret = 0;
	while ( str [ ret ] ) ++ret;
	return ret;
}

wchar_t * mwcsdup ( wchar_t * str )
{
	size_t bytes = ( mwcslen ( str ) + 1 ) * sizeof ( wchar_t );
	wchar_t * ret = ( wchar_t * ) mmalloc ( bytes );
	if ( ret ) mmemcpy ( ret, str, bytes );
	return ret;
}

wchar_t * mwcscpy( wchar_t * strDestination, const wchar_t * strSource )
{
	wchar_t * ptr = strDestination;
	while ( ptr )
	{
		if ( 0 == ( * ptr = * strSource ) ) break;
		++ptr;
		++strSource;
	}
	return strDestination;
}

wchar_t * mwcscat( wchar_t * strDestination, const wchar_t * strSource )
{
	return mwcscpy ( strDestination + mwcslen ( strDestination ), strSource );
}

wchar_t * mwcschr ( wchar_t * str, int chr )
{
	while ( * str )
	{
		if ( * str == chr ) return str;
		++str;
	}
	return NULL;
}

wchar_t * mwcsrchr ( wchar_t * str, int chr )
{
	wchar_t * ptr = str + mwcslen ( str ) - 1;
	while ( ( ptr >= str ) && ( * ptr ) )
	{
		if ( * ptr == chr ) return ptr;
		--ptr;
	}
	return NULL;
}

int mwcscmp ( wchar_t * str1, wchar_t * str2 )
{
	int ret = 0;
	while ( * str1 && ( 0 == ( ret = * str1 - * str2 ) ) )
	{
		++str1; ++str2;
	}
	return ret;
}

int mwcsicmp ( wchar_t * str1, wchar_t * str2 )
{
	int ret = 0;
	while ( * str1 && ( 0 == ( ret = mlwchar ( * str1 ) - mlwchar ( * str2 ) ) ) )
	{
		++str1; ++str2;
	}
	return ret;
}
