/*
* eeectl
* Copyright (C) 2008 Anthony A Z <dci@cpp.in>
* http://www.cpp.in/dev/eeectl/
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef _RUNTIME_H_INCLUDED_
#define _RUNTIME_H_INCLUDED_

#define IS_NUMERIC(a) ( ( ( a ) >= 0x30 ) && ( ( a ) <= 0x39 ) )

char mlchar ( char chr );
char muchar ( char chr );
wchar_t mlwchar ( wchar_t chr );
wchar_t muwchar ( wchar_t chr );

void * mmalloc ( size_t howmuch );
void * mrealloc ( void * mem, size_t howmuch );
void mfree ( void * mem );

void * mmemcpy ( void * dest, const void * src, size_t count );
void * mmemset ( void * dest, int c, size_t count );
int mmemcmp ( const void * buf1, const void * buf2, size_t count );
int mmemicmp ( const void * buf1, const void * buf2, size_t count );

int mwtoi ( wchar_t * str );
unsigned long mwcstoul ( const wchar_t * nptr, wchar_t ** endptr, int base );
long mwcstol ( const wchar_t * nptr, wchar_t ** endptr, int base );
size_t mwcslen ( wchar_t * str );
wchar_t * mwcsdup ( wchar_t * str );
wchar_t * mwcscpy( wchar_t * strDestination, const wchar_t * strSource );
wchar_t * mwcscat( wchar_t * strDestination, const wchar_t * strSource );
wchar_t * mwcschr ( wchar_t * str, int chr );
wchar_t * mwcsrchr ( wchar_t * str, int chr );
int mwcscmp ( wchar_t * str1, wchar_t * str2 );
int mwcsicmp ( wchar_t * str1, wchar_t * str2 );

#endif