/*
* eeectl
* Copyright (C) 2008 Anthony A Z <dci@cpp.in>
* http://www.cpp.in/dev/eeectl/
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <windows.h>
#include "runtime.h"
#include "table.h"
#include "eeehw.h"
#include "ss_backlight.h"

#define CFLEN 2048


#define COL_NAME 0
#define COL_LEV  1
#define COL_NUM  2


eeectl_loader_t * gcore;

UINT uLev;
sth_t tblBLProfiles;

BOOL bSuspended;
UINT uPreSuspendLev;

BOOL bl_init ( eeectl_loader_t * core )
{
	UINT i;
	wchar_t * confstring = ( wchar_t * ) mmalloc ( CFLEN * sizeof ( wchar_t ) );
	gcore = core;
	/* load profiles */
	gcore->setup_read ( &eeectl_subsys_backlight, L"Profiles", confstring, CFLEN );
	tblBLProfiles = st_create ( COL_NUM );
	if ( st_serial_read ( tblBLProfiles, confstring ) )
	{
		for ( i = 0; i < st_height ( tblBLProfiles ); ++i )
		{
			UINT j;
			for ( j = i + 1; j < st_height ( tblBLProfiles ); ++j )
			{
				if ( mwtoi ( st_value_get ( tblBLProfiles, i, COL_LEV ) ) == mwtoi ( st_value_get ( tblBLProfiles, j, COL_LEV ) ) )
				{
					gcore->pass_msg ( &eeectl_subsys_backlight, MSG_ERROR, L"Duplicate value: '%s'", st_value_get ( tblBLProfiles, j, COL_LEV ) );
					st_row_del ( tblBLProfiles, j );
					--j;
				}
			}
		}
	}
	/* load state */
	gcore->state_read ( &eeectl_subsys_backlight, L"Level", confstring, CFLEN );
	uLev = IS_NUMERIC ( * confstring ) ? mwtoi ( confstring ) : eeehw_video_bl_get ( );
	eeehw_video_bl_set ( uLev );
	/* */
	return TRUE;
}

void bl_save ( )
{
	wchar_t b [ 64 ];
	wsprintf ( b, L"%d", uLev );
	gcore->state_write ( &eeectl_subsys_backlight, L"Level", b );
}

void bl_stop ( BOOL restart ) { }

void bl_suspend ( )
{
	uPreSuspendLev = uLev;
	bSuspended = TRUE;
}

void bl_resume ( )
{
	if ( bSuspended )
	{
		uLev = uPreSuspendLev;
		eeehw_video_bl_set ( uLev );
		bSuspended = FALSE;
	}
}

UINT bl_icontxt ( wchar_t * icon, wchar_t * txt, size_t max )
{
	return wsprintf ( txt, /* ';' means '%' here */ L"%d;", uLev );
}

UINT bl_menucrt ( HMENU menu, UINT base )
{
	UINT ret = 0;
	UINT i;
	/* */
	BOOL bMatch = FALSE;
	/* */
	for ( i = 0; i < st_height ( tblBLProfiles ); ++i )
	{
		UINT lev = mwtoi ( st_value_get ( tblBLProfiles, i, COL_LEV ) );
		if ( FALSE == bMatch ) bMatch = ( lev == uLev );
		AppendMenu ( menu, MF_BYCOMMAND | MF_STRING | ( ( lev == uLev ) ? MF_CHECKED : 0 ), base + ret, st_value_get ( tblBLProfiles, i, COL_NAME ) );
		++ret;
	}
	/* non-listed? */
	if ( FALSE == bMatch )
	{
		wchar_t menucap [ 64 ];
		wsprintf ( menucap, L"Custom (%d%%)", uLev );
		AppendMenu ( menu, MF_BYCOMMAND | MF_STRING | MF_CHECKED | MF_GRAYED, base + ret, menucap );
		++ret;
	}
	/* */
	return ret;
}

BOOL bl_menuclk ( UINT id )
{
	uLev = mwtoi ( st_value_get ( tblBLProfiles, id, COL_LEV ) );
	eeehw_video_bl_set ( uLev );
	gcore->ntf_icon_upd ( &eeectl_subsys_backlight, NULL );
	return TRUE;
}

BOOL bl_ntfevnt ( wchar_t * evname )
{
	UINT i;
	UINT sug = 0;
	if ( 0 == mwcsicmp ( evname, L"_up" ) )
	{
		for ( i = 0; i < st_height ( tblBLProfiles ); ++i )
		{
			UINT lev = mwtoi ( st_value_get ( tblBLProfiles, i, COL_LEV ) );
			if ( ( lev > uLev ) && ( ( 0 == sug ) || ( lev < ( UINT ) mwtoi ( st_value_get ( tblBLProfiles, sug - 1, COL_LEV ) ) ) ) ) sug = i + 1;
		}
	}
	else if ( 0 == mwcsicmp ( evname, L"_down" ) )
	{
		for ( i = 0; i < st_height ( tblBLProfiles ); ++i )
		{
			UINT lev = mwtoi ( st_value_get ( tblBLProfiles, i, COL_LEV ) );
			if ( ( lev < uLev ) && ( ( 0 == sug ) || ( lev > ( UINT ) mwtoi ( st_value_get ( tblBLProfiles, sug - 1, COL_LEV ) ) ) ) ) sug = i + 1;
		}
	}
	else
	{
		for ( i = 0; i < st_height ( tblBLProfiles ); ++i )
		{
			if ( 0 == mwcsicmp ( evname, st_value_get ( tblBLProfiles, i, COL_NAME ) ) )
			{
				sug = i + 1;
				break;
			}
		}
	}
	/* */
	if ( sug )
	{
		uLev = mwtoi ( st_value_get ( tblBLProfiles, sug - 1, COL_LEV ) );
		eeehw_video_bl_set ( uLev );
		gcore->ntf_icon_upd ( &eeectl_subsys_backlight, NULL );
		return TRUE;
	}
	/* */
	return FALSE;
}

void bl_ntftime ( )
{
	unsigned char nlev = eeehw_video_bl_get ( );
	if ( nlev != uLev ) gcore->ntf_icon_upd ( &eeectl_subsys_backlight, NULL );
	uLev = nlev;
}

eeectl_subsys_t eeectl_subsys_backlight = { L"Backlight", L"eeectl screen backlight control module", bl_init, bl_save, bl_stop, bl_suspend, bl_resume, bl_icontxt, bl_menucrt, bl_menuclk, bl_ntfevnt, bl_ntftime };
