/*
* eeectl
* Copyright (C) 2008 Anthony A Z <dci@cpp.in>
* http://www.cpp.in/dev/eeectl/
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <windows.h>
#include "runtime.h"
#include "table.h"
#include "eeehw.h"
#include "ss_speed.h"

#define CFLEN 2048

#define COL_FSB  0
#define COL_PCI  1
#define COL_VTG  2
#define COL_NAME 3
#define COL_NUM  4

#define PLL_CTL   0x01
#define PLL_FSB_M 0x0B
#define PLL_FSB_N 0x0C
#define PLL_PCI_M 0x0F
#define PLL_PCI_N 0x10


#define NAME_SUSPEND L"Suspend"

/* settings */
DWORD dwFSBIconMul;
DWORD dwStepDelay;
sth_t tblSpeeds;

/* state */
DWORD dwCurrent = 0;
DWORD dwPreSusp = 0;

eeectl_loader_t * gcore;


unsigned char plldata [ 24 ];


void walk_to_current ( )
{
	/* re-read pll */
	if ( ( sizeof ( plldata ) == eeehw_pll_read ( 0, plldata, sizeof ( plldata ) ) ) && plldata [ PLL_FSB_M ] && plldata [ PLL_FSB_N ] && plldata [ PLL_PCI_M ] && plldata [ PLL_PCI_N ] )
	{
		/* get endpoints */
		unsigned char sfsb = ( 24 * ( ( unsigned short ) plldata [ PLL_FSB_N ] ) ) / ( plldata [ PLL_FSB_M ] & 0x3F );
		unsigned char spci = ( 24 * ( ( unsigned short ) plldata [ PLL_PCI_N ] ) ) / ( plldata [ PLL_PCI_M ] & 0x3F );
		unsigned char dfsb = mwtoi ( st_value_get ( tblSpeeds, dwCurrent - 1, COL_FSB ) );
		unsigned char dpci = mwtoi ( st_value_get ( tblSpeeds, dwCurrent - 1, COL_PCI ) );
		/* set normal voltage for transfer */
		eeehw_voltage_set ( 0x01 );
		/* set Ms to 24 for easier calculations */
		plldata [ PLL_FSB_M ] = 24;
		plldata [ PLL_FSB_N ] = sfsb;
		plldata [ PLL_PCI_M ] = 24;
		plldata [ PLL_PCI_N ] = spci;
		/* iterate thru im values */
		while ( "K > 0" )
		{
			unsigned int i;
			unsigned char sugfsb = 0, sugpci = 0;
			/* try to find some suitable values */
			for ( i = 0; i < st_height ( tblSpeeds ); ++i )
			{
				unsigned char rfsb = mwtoi ( st_value_get ( tblSpeeds, i, COL_FSB ) );
				unsigned char rpci = mwtoi ( st_value_get ( tblSpeeds, i, COL_PCI ) );
				/* don't try to read this :-) */
				if (
					( ( sfsb < dfsb ) && ( rfsb < dfsb ) && (
					 ( ( rfsb > plldata [ PLL_FSB_N ] ) && ( ( 0 == sugfsb ) || ( rfsb < sugfsb ) ) ) ||
					 ( ( rfsb == plldata [ PLL_FSB_N ] ) && ( rpci > plldata [ PLL_PCI_N ] ) && ( rpci <= dpci ) && ( ( 0 == sugpci ) || ( rpci < sugpci ) ) )
					) ) ||
					( ( sfsb > dfsb ) && ( rfsb > dfsb ) && (
					 ( ( rfsb < plldata [ PLL_FSB_N ] ) && ( ( 0 == sugfsb ) || ( rfsb > sugfsb ) ) ) ||
					 ( ( rfsb == plldata [ PLL_FSB_N ] ) && ( rpci < plldata [ PLL_PCI_N ] ) && ( rpci >= dpci ) && ( ( 0 == sugpci ) || ( rpci > sugpci ) ) )
					) )
				   )
				{
					sugfsb = rfsb;
					sugpci = rpci;
				}
			}
			/* set */
			plldata [ PLL_CTL ]  |= /* rb */ ( 1 << 6 ) | /* pci_mn */ ( 1 << 4 ) | /* cpu_mn */ ( 1 << 0 );
			plldata [ PLL_FSB_N ] = ( sugfsb && sugpci ) ? sugfsb : dfsb;
			plldata [ PLL_PCI_N ] = ( sugfsb && sugpci ) ? sugpci : dpci;
			eeehw_pll_write ( 0, plldata, sizeof ( plldata ) );
			gcore->ntf_icon_upd ( &eeectl_subsys_speed, NULL );
			/* now what? */
			if ( sugfsb && sugpci ) Sleep ( dwStepDelay );
			else break;
		}
		/* set low voltage, if requested by profile */
		if ( 0 == mwtoi ( st_value_get ( tblSpeeds, dwCurrent - 1, COL_VTG ) ) ) eeehw_voltage_set ( 0x00 );
	}
	else gcore->pass_msg ( &eeectl_subsys_speed, MSG_ERROR, L"Got garbage from PLL." );
}




BOOL speed_init ( eeectl_loader_t * core )
{
	BOOL bSetupOK = TRUE;
	wchar_t * confstring = ( wchar_t * ) mmalloc ( CFLEN * sizeof ( wchar_t ) );
	/* */
	gcore = core;
	/* load profiles */
	gcore->setup_read ( &eeectl_subsys_speed, L"Profiles", confstring, CFLEN );
	tblSpeeds = st_create ( COL_NUM );
	if ( 0 == st_serial_read ( tblSpeeds, confstring ) )
	{
		gcore->pass_msg ( &eeectl_subsys_speed, MSG_ERROR, L"Unable to read Profiles setting." );
		bSetupOK = FALSE;
	}
	else
	{
		DWORD i;
		for ( i = 0; i < st_height ( tblSpeeds ); ++i )
		{
			DWORD j;
			BYTE fsb = mwtoi ( st_value_get ( tblSpeeds, i, COL_FSB ) );
			BYTE pci = mwtoi ( st_value_get ( tblSpeeds, i, COL_PCI ) );
			wchar_t * cname = st_value_get ( tblSpeeds, i, COL_NAME );
			if ( ( fsb < 30 ) || ( fsb > 200 ) || ( pci < 30 ) || ( pci > 200 ) )
			{
				gcore->pass_msg ( &eeectl_subsys_speed, MSG_ERROR, L"Invalid Speed value: '%s:%s:%s'.", cname ? cname : L"(Hidden)", st_value_get ( tblSpeeds, i, COL_FSB ), st_value_get ( tblSpeeds, i, COL_PCI ) );
				bSetupOK = FALSE;
			}
			/* */
			for ( j = i + 1; j < st_height ( tblSpeeds ); ++j )
			{
				if ( ( * cname ) && ( 0 == mwcsicmp ( cname, st_value_get ( tblSpeeds, j, COL_NAME ) ) ) )
				{
					gcore->pass_msg ( &eeectl_subsys_speed, MSG_ERROR, L"Duplicate name: '%s'.", cname );
					bSetupOK = FALSE;
				}
			}
		}
	}
	/* read step delay */
	gcore->setup_read ( &eeectl_subsys_speed, L"StepDelay", confstring, CFLEN );
	dwStepDelay = mwtoi ( confstring );
	if ( ( dwStepDelay < 100 ) || ( dwStepDelay > 10000 ) )
	{
		gcore->pass_msg ( &eeectl_subsys_speed, MSG_ERROR, L"Invalid StepDelay value: '%s'.", confstring );
		bSetupOK = FALSE;
	}
	/* read fsb icon multiplier */
	gcore->setup_read ( &eeectl_subsys_speed, L"FSBIconMul", confstring, CFLEN );
	dwFSBIconMul = mwtoi ( confstring );
	if ( ( dwFSBIconMul < 1 ) || ( dwFSBIconMul > 99 ) )
	{
		gcore->pass_msg ( &eeectl_subsys_speed, MSG_ERROR, L"Invalid FSBIconMul value: '%s'.", confstring );
		bSetupOK = FALSE;
	}
	/* settings look good? */
	if ( bSetupOK )
	{
		if ( ( sizeof ( plldata ) == eeehw_pll_read ( 0, plldata, sizeof ( plldata ) ) ) && plldata [ PLL_FSB_M ] && plldata [ PLL_FSB_N ] && plldata [ PLL_PCI_M ] && plldata [ PLL_PCI_N ] )
		{
			/* try to load last profile */
			gcore->state_read ( &eeectl_subsys_speed, L"Profile", confstring, CFLEN );
			if ( * confstring )
			{
				UINT i;
				for ( i = 0; i < st_height ( tblSpeeds ); ++i )
				{
					if ( 0 == mwcsicmp ( confstring, st_value_get ( tblSpeeds, i, COL_NAME ) ) )
					{
						dwCurrent = i + 1;
						walk_to_current ( );
						break;
					}
				}
			}
			/* try to find current profile */
			if ( 0 == dwCurrent )
			{
				unsigned char fsb = ( 24 * ( ( unsigned short ) plldata [ PLL_FSB_N ] ) ) / ( plldata [ PLL_FSB_M ] & 0x3F );
				unsigned char pci = ( 24 * ( ( unsigned short ) plldata [ PLL_PCI_N ] ) ) / ( plldata [ PLL_PCI_M ] & 0x3F );
				unsigned char vtg = eeehw_voltage_get ( );
				UINT i;
				for ( i = 0; i < st_height ( tblSpeeds ); ++i )
				{
					wchar_t * cname = st_value_get ( tblSpeeds, i, COL_NAME );
					if ( ( * cname ) && mwcsicmp ( cname, NAME_SUSPEND ) && ( fsb == mwtoi ( st_value_get ( tblSpeeds, i, COL_FSB ) ) ) && ( pci == mwtoi ( st_value_get ( tblSpeeds, i, COL_PCI ) ) ) && ( vtg == mwtoi ( st_value_get ( tblSpeeds, i, COL_VTG ) ) ) )
					{
						dwCurrent = i + 1;
						break;
					}
				}
			}
		}
		else gcore->pass_msg ( &eeectl_subsys_speed, MSG_ERROR, L"Got garbage from PLL." );
	}
	/* */
	mfree ( confstring );
	/* */
	return bSetupOK;
}

void speed_save ( )
{
	if ( dwCurrent ) gcore->state_write ( &eeectl_subsys_speed, L"Profile", st_value_get ( tblSpeeds, dwCurrent - 1, COL_NAME ) );
}

void speed_stop ( BOOL restart )
{
	st_destroy ( tblSpeeds );
	tblSpeeds = NULL;
	gcore     = NULL;
}

void speed_suspend ( )
{
	if ( dwCurrent )
	{
		UINT i;
		for ( i = 0; i < st_height ( tblSpeeds ); ++i )
		{
			if ( 0 == mwcsicmp ( NAME_SUSPEND, st_value_get ( tblSpeeds, i, COL_NAME ) ) )
			{
				dwPreSusp = dwCurrent;
				dwCurrent = i + 1;
				walk_to_current ( );
				return;
			}
		}
	}
	dwPreSusp = 0;
}

void speed_resume ( )
{
	if ( dwPreSusp )
	{
		dwCurrent = dwPreSusp;
		walk_to_current ( );
		dwPreSusp = 0;
	}
}

UINT speed_icontxt ( wchar_t * icon, wchar_t * txt, size_t max )
{
	if ( ( 0 == mwcsicmp ( L"FSB", icon ) ) && plldata [ PLL_FSB_M ] && plldata [ PLL_FSB_N ] )
	{
		return wsprintf ( txt, L"%d", dwFSBIconMul * ( 24 * ( ( unsigned short ) plldata [ PLL_FSB_N ] ) ) / ( plldata [ PLL_FSB_M ] & 0x3F ) );
	}
	else if ( ( 0 == mwcsicmp ( L"PCI", icon ) ) && plldata [ PLL_PCI_N ] && plldata [ PLL_PCI_M ] )
	{
		return wsprintf ( txt, L"%d", ( 24 * ( ( unsigned short ) plldata [ PLL_PCI_N ] ) ) / ( plldata [ PLL_PCI_M ] & 0x3F ) );
	}
	else
	{
		* txt = 0;
		return 1;
	}
}

UINT speed_menucrt ( HMENU menu, UINT base )
{
	UINT ret = 0;
	UINT i;
	/* */
	for ( i = 0; i < st_height ( tblSpeeds ); ++i )
	{
		wchar_t * spname = st_value_get ( tblSpeeds, i, COL_NAME );
		if ( ( * spname ) && mwcsicmp ( spname, NAME_SUSPEND ) )
		{
			AppendMenu ( menu, MF_BYCOMMAND | MF_STRING | ( ( i + 1 == dwCurrent ) ? MF_CHECKED : 0 ), base + ret, spname ); 
			++ret;
		}
	}
	/* non-listed freq? */
	if ( 0 == dwCurrent )
	{
		wchar_t menucap [ 32 ];
		if ( plldata [ PLL_FSB_M ] && plldata [ PLL_FSB_N ] && plldata [ PLL_PCI_M ] && plldata [ PLL_PCI_N ] )
		{
			
			unsigned char fsb = ( 24 * ( ( unsigned short ) plldata [ PLL_FSB_N ] ) ) / ( plldata [ PLL_FSB_M ] & 0x3F );
			unsigned char pci = ( 24 * ( ( unsigned short ) plldata [ PLL_PCI_N ] ) ) / ( plldata [ PLL_PCI_M ] & 0x3F );
			unsigned char vtg = eeehw_voltage_get ( );
			wsprintf ( menucap, L"Custom (%d,%d,%d)", fsb, pci, vtg );
		}
		else mwcscpy ( menucap, L"[PLL ERR]" );
		AppendMenu ( menu, MF_BYCOMMAND | MF_STRING | MF_CHECKED | MF_GRAYED, base + ret, menucap ); 
		++ret;
	}
	/* */
	return ret;
}

BOOL speed_menuclk ( UINT id )
{
	/* find */
	UINT i;
	UINT nid = 0;
	/* */
	for ( i = 0; i < st_height ( tblSpeeds ); ++i )
	{
		wchar_t * spname = st_value_get ( tblSpeeds, i, COL_NAME );
		if ( ( * spname ) && mwcsicmp ( spname, NAME_SUSPEND ) )
		{
			if ( nid == id )
			{
				dwCurrent = i + 1;
				walk_to_current ( ); 
				return TRUE;
			}
			++nid;
		}
	}
	return FALSE;
}


BOOL speed_ntfevnt ( wchar_t * evname )
{
	if ( dwCurrent )
	{
		UINT i;
		DWORD sug = 0;
		/* */
		if ( 0 == mwcsicmp ( L"_up", evname ) )
		{
			for ( i = 0; i < st_height ( tblSpeeds ); ++i )
			{
				wchar_t * spname = st_value_get ( tblSpeeds, i, COL_NAME );
				if ( ( * spname ) && mwcsicmp ( spname, NAME_SUSPEND ) )
				{
					DWORD isp = mwtoi ( st_value_get ( tblSpeeds, i, COL_FSB ) );
					DWORD ssp = mwtoi ( st_value_get ( tblSpeeds, sug - 1, COL_FSB ) );
					DWORD csp = mwtoi ( st_value_get ( tblSpeeds, dwCurrent - 1, COL_FSB ) );
					if ( ( isp > csp ) && ( ( 0 == sug ) || ( ssp > isp ) ) ) sug = i + 1;
				}
			}
		}
		else if ( 0 == mwcsicmp ( L"_down", evname ) )
		{
			for ( i = 0; i < st_height ( tblSpeeds ); ++i )
			{
				wchar_t * spname = st_value_get ( tblSpeeds, i, COL_NAME );
				if ( ( * spname ) && mwcsicmp ( spname, NAME_SUSPEND ) )
				{
					DWORD isp = mwtoi ( st_value_get ( tblSpeeds, i, COL_FSB ) );
					DWORD ssp = mwtoi ( st_value_get ( tblSpeeds, sug - 1, COL_FSB ) );
					DWORD csp = mwtoi ( st_value_get ( tblSpeeds, dwCurrent - 1, COL_FSB ) );
					if ( ( isp < csp ) && ( ( 0 == sug ) || ( ssp < isp ) ) ) sug = i + 1;
				}
			}
		}
		else
		{
			for ( i = 0; i < st_height ( tblSpeeds ); ++i )
			{
				wchar_t * spname = st_value_get ( tblSpeeds, i, COL_NAME );
				if ( ( * spname ) && mwcsicmp ( spname, NAME_SUSPEND ) && ( 0 == mwcsicmp ( spname, evname ) ) )
				{
					sug = i + 1;
					break;
				}
			}
		}
		/* */
		if ( sug )
		{
			dwCurrent = sug;
			walk_to_current ( );
			return TRUE;
		}
	}
	/* */
	return FALSE;
}

void speed_ntftime ( )
{

}

eeectl_subsys_t eeectl_subsys_speed = { L"Speed", L"eeectl clock control module", speed_init, speed_save, speed_stop, speed_suspend, speed_resume, speed_icontxt, speed_menucrt, speed_menuclk, speed_ntfevnt, speed_ntftime };
