/*
* eeectl
* Copyright (C) 2008 Anthony A Z <dci@cpp.in>
* http://www.cpp.in/dev/eeectl/
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#ifndef _TABLE_H_INCLUDED_
#define _TABLE_H_INCLUDED_

typedef struct stringtable_tag
{
	unsigned long width;
	unsigned long height;
	wchar_t * * * rows;
}
stringtable_t;

typedef void * sth_t;

sth_t st_create  ( unsigned long width );
void  st_destroy ( sth_t table );

unsigned long st_width  ( sth_t table );
unsigned long st_height ( sth_t table );

unsigned long st_row_add ( sth_t table );
unsigned long st_row_del ( sth_t table, unsigned long row );

wchar_t * st_value_get ( sth_t table, unsigned long row, unsigned long column );
wchar_t * st_value_set ( sth_t table, unsigned long row, unsigned long column, wchar_t * value );


unsigned long st_serial_read  ( sth_t table, wchar_t * serialized );
unsigned long st_serial_write ( sth_t table, wchar_t * serialized, unsigned long max_count );

#endif