/*
* eeectl
* Copyright (C) 2008 Anthony A Z <dci@cpp.in>
* http://www.cpp.in/dev/eeectl/
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <windows.h>
#include "txticon.h"
#include "runtime.h"
#include "resource.h"


HINSTANCE hinIconInst = NULL;
HBITMAP   hbmIconBits = NULL;
HBITMAP   hbmIconMask = NULL;
HBITMAP   hbmIconText = NULL;
BITMAP    bmIconBits;
BITMAP    bmIconText;

void mcblt ( HDC hdst, UINT xdst, UINT ydst, HDC hsrc, UINT xsrc, UINT ysrc, UINT w, UINT h, COLORREF cdst, COLORREF csrc )
{
	UINT xcnt, ycnt;
	for ( ycnt = 0; ycnt < h; ++ycnt )
	{
		for ( xcnt = 0; xcnt < w; ++xcnt )
		{
			if ( csrc == GetPixel ( hsrc, xsrc + xcnt, ysrc + ycnt ) ) SetPixel ( hdst, xdst + xcnt, ydst + ycnt, cdst );
		}
	}
}

BOOL TIStart ( HINSTANCE hInst )
{
	hinIconInst = hInst;
	hbmIconBits = LoadBitmap ( hinIconInst, MAKEINTRESOURCE(IDB_ICONBITS) );
	hbmIconMask = LoadBitmap ( hinIconInst, MAKEINTRESOURCE(IDB_ICONMASK) );
	hbmIconText = LoadBitmap ( hinIconInst, MAKEINTRESOURCE(IDB_ICONTEXT) );
	return hbmIconBits && hbmIconMask && hbmIconText && GetObject ( hbmIconBits, sizeof ( bmIconBits ), &bmIconBits ) && GetObject ( hbmIconText, sizeof ( bmIconText ), &bmIconText );
}

VOID TIStop ( )
{
	if ( hbmIconText )
	{
		DeleteObject ( hbmIconText );
		hbmIconText = NULL;
	}
	//
	if ( hbmIconMask )
	{
		DeleteObject ( hbmIconMask );
		hbmIconMask = NULL;
	}
	//
	if ( hbmIconBits )
	{
		DeleteObject ( hbmIconBits );
		hbmIconBits = NULL;
	}
	//
	if ( hinIconInst )
	{
		hinIconInst = NULL;
	}
}

HICON TICreate ( wchar_t * txt, COLORREF color )
{
	HICON ret = NULL;
	ICONINFO ii;
	/* */
	HDC hdcScreen;
	HDC hdcBits;
	HDC hdcText;
	HDC hdcBlit;
	HBITMAP hbmBitsOrig;
	HBITMAP hbmTextOrig;
	HBITMAP hbmBlitOrig;
	HBITMAP hbmBlit;
	/* */
	hdcScreen   = GetDC ( NULL );
	hbmBlit     = CreateCompatibleBitmap ( hdcScreen, bmIconBits.bmWidth, bmIconBits.bmHeight );
	/* */
	hdcBits     = CreateCompatibleDC ( hdcScreen );
	hdcText     = CreateCompatibleDC ( hdcScreen );
	hdcBlit     = CreateCompatibleDC ( hdcScreen );
	hbmBitsOrig = ( HBITMAP ) SelectObject ( hdcBits, hbmIconBits );
	hbmTextOrig = ( HBITMAP ) SelectObject ( hdcText, hbmIconText );
	hbmBlitOrig = ( HBITMAP ) SelectObject ( hdcBlit, hbmBlit );
	/* copy back */
	BitBlt ( hdcBlit, 0, 0, bmIconBits.bmWidth, bmIconBits.bmHeight, hdcBits, 0, 0, SRCCOPY );
	/* is there text to copy? */
	if ( txt && mwcslen ( txt ) )
	{
		UINT nSymbols = ( UINT ) mwcslen ( txt );
		UINT uSymbolW = bmIconText.bmWidth / TI_NUM_SYMBOLS;
		UINT nCnt;
		for ( nCnt = 0; nCnt < nSymbols; ++nCnt )
		{
			mcblt ( hdcBlit, /* left corner */ ( bmIconBits.bmWidth - ( ( uSymbolW + 1 ) * nSymbols ) ) / 2 + /* letter offset */ ( ( uSymbolW + 1 ) * nCnt ) + /* tuner */ ( 0 ), ( bmIconBits.bmHeight - bmIconText.bmHeight ) / 2, hdcText, uSymbolW * ( txt [ nCnt ] - 0x30 ), 0, uSymbolW, bmIconText.bmHeight, color, RGB ( 0, 0, 0 ) ); 
		}
	}
	/* */
	SelectObject ( hdcBlit, hbmBlitOrig );
	SelectObject ( hdcText, hbmTextOrig );
	SelectObject ( hdcBits, hbmBitsOrig );
	DeleteDC ( hdcBlit );
	DeleteDC ( hdcText );
	DeleteDC ( hdcBits );
	/* */
	ii.fIcon    = FALSE;
	ii.xHotspot = 0;
	ii.yHotspot = 0;
	ii.hbmColor = hbmBlit;
	ii.hbmMask  = hbmIconMask;
	ret = CreateIconIndirect ( &ii );
	/* */
	DeleteObject ( hbmBlit );
	ReleaseDC ( NULL, hdcScreen );
	return ret;
}

VOID TIDestroy ( HICON hi )
{
	DestroyIcon ( hi );
}
