<?php
$times = array
		(
		2592000 => array('თვე', 'თვე', 'თვე'),
		604800 => array('კვირა', 'კვირა', 'კვირა'),
		86400 => array('დღე', 'დღე', 'დღე'),
		3600 => array('საათი', 'საათი', 'საათი'),
		60 => array('წუთი', 'წუთი', 'წუთი'),
		1 => array('წამი', 'წამი', 'წამი')
		);

		function locate($uri)
	{
	endclean();
	
	if(substr($uri, 0, 1) == '?')$uri = SCRIPT_NAME.$uri;
	
	header('Location: '.$uri, true, 302);
	exit;
	}


		function msg($msg,$to = null)
	{
	$_SESSION['msg'][] = array('line' => date('G:i:s'), 'info' => $msg);
	if(!empty($to))locate($to);

	return true;
	}

		function err($msg,$to = null)
	{

	$date = date('G:i:s');
	if(LOCALHOST)
		{
		$backtrace = debug_backtrace();
		$backtrace = $backtrace[0];

		$date .= '.'.substr(strtok(microtime(),' '),2,4).' : '.$backtrace['file'].' - '.$backtrace['line'].'<br />';
		}

	$_SESSION['err'][] = array('line' => $date, 'info' => $msg);
	if(!empty($to))locate($to);

	return true;
	}

		function ip2int($ip)
	{
	$a=explode('.',$ip);

	return ($a[0] * 256 * 256 * 256) + ($a[1] * 256 * 256) + ($a[2] * 256) + $a[3];
	}

			function str($string, $do = 0, $html = true, $mysql = true)
	{
	global $db;
	$string = trim($string);
	if($html)$string = htmlspecialchars($string, ENT_QUOTES, 'utf-8');

	$string = str_replace(array('`', '{', '}', '$'), array('&#96;', '&#123;', '&#125;', '&#36;'), $string);

	if($mysql)$string = mysql_real_escape_string($string, $db -> connect());

	if(is_int($do) && $do > 0)$string = xsubstr($string, 0, $do);

	return $string;
	}
	
			function destr($string)
		{
		$string = htmlspecialchars_decode($string, ENT_QUOTES);
		$string = str_replace(array('&#96;', '&#123;', '&#125;', '&#36;'), array('`', '{', '}', '$'), $string);
		
		return $string;
		}

		function int($integer, $do = 0)
	{
	$integer = abs(intval($integer));
	if($do > 0)$integer = substr($integer, 0, $do);

	return $integer;
	}


		function check_fields($to = MY_URI, $fields = array(), $from = 'POST')
	{
	$count_fields = count($fields);

	$data = $GLOBALS['_'.$from];


			for($i = 0;$i < $count_fields;$i ++)
		{
		if(!isset($data[$fields[$i][0]]) && !in_array('cant set', $fields[$i]))
			{
			err('ველი არ პასუხობს '.$fields[$i][0], $to);
			}

		if(isset($data[$fields[$i][0]]))
			{

			$field = $data[$fields[$i][0]];

			if(in_array('not null',$fields[$i]) && empty($field))
				{
				err('ველი '.$fields[$i][0].' არ შეიძლება იყოს ცარიელი', $to);
				}

			if((isset($fields[$i]['values']) && !in_array($field, $fields[$i]['values'])) || isset($fields[$i]['not_values']) && in_array($field, $fields[$i]['not_values']))
				{
				err('ველი '.$fields[$i][0].' ვერ იღებს აღნისნულ მნიშვნელობას', $to);
				}


			if(isset($fields[$i]['fixlen']) || isset($fields[$i]['maxlen']) || isset($fields[$i]['minlen']))
				{
				if(!is_string($field))
					{
					err('ველი '.$fields[$i][0].' უნდა იყოს სიტყვების შემცველი', $to);
					}

				$strlen = xstrlen($field);

				if(isset($fields[$i]['fixlen']))
					{
					if($strlen != $fields[$i]['fixlen'])err('ველი '.$fields[$i][0].' არასწორი სიგრძისაა', $to);
					}
				else
					{
					if(isset($fields[$i]['maxlen']) && $strlen > $fields[$i]['maxlen'])
						{
						err('ველი '.$fields[$i][0].' ძალიან გრძელია', $to);
						}

					if(isset($fields[$i]['minlen']) && $strlen < $fields[$i]['minlen'])
						{
						err('ველი '.$fields[$i][0].' ძალიან მოკლეა', $to);
						}
					}

				}
			}

		}

	return true;
	}

		function xtocp($str)
	{
	if (function_exists('mb_convert_encoding'))return mb_convert_encoding($str, 'windows-1251', 'utf-8');
	if (function_exists('iconv'))return iconv('utf-8', 'windows-1251', $str);

	$utf8win1251 = array(
"А"=>"\xC0","Б"=>"\xC1","В"=>"\xC2","Г"=>"\xC3","Д"=>"\xC4","Е"=>"\xC5","Ё"=>"\xA8","Ж"=>"\xC6","З"=>"\xC7","И"=>"\xC8","Й"=>"\xC9","К"=>"\xCA","Л"=>"\xCB","М"=>"\xCC",
"Н"=>"\xCD","О"=>"\xCE","П"=>"\xCF","Р"=>"\xD0","С"=>"\xD1","Т"=>"\xD2","У"=>"\xD3","Ф"=>"\xD4","Х"=>"\xD5","Ц"=>"\xD6","Ч"=>"\xD7","Ш"=>"\xD8","Щ"=>"\xD9","Ъ"=>"\xDA",
"Ы"=>"\xDB","Ь"=>"\xDC","Э"=>"\xDD","Ю"=>"\xDE","Я"=>"\xDF","а"=>"\xE0","б"=>"\xE1","в"=>"\xE2","г"=>"\xE3","д"=>"\xE4","е"=>"\xE5","ё"=>"\xB8","ж"=>"\xE6","з"=>"\xE7",
"и"=>"\xE8","й"=>"\xE9","к"=>"\xEA","л"=>"\xEB","м"=>"\xEC","н"=>"\xED","о"=>"\xEE","п"=>"\xEF","р"=>"\xF0","с"=>"\xF1","т"=>"\xF2","у"=>"\xF3","ф"=>"\xF4","х"=>"\xF5",
"ц"=>"\xF6","ч"=>"\xF7","ш"=>"\xF8","щ"=>"\xF9","ъ"=>"\xFA","ы"=>"\xFB","ь"=>"\xFC","э"=>"\xFD","ю"=>"\xFE","я"=>"\xFF");

	return strtr($str, $utf8win1251);
	}

		function xtoutf($str)
	{

	if (function_exists('mb_convert_encoding'))return mb_convert_encoding($str, 'utf-8', 'windows-1251');
	if (function_exists('iconv'))return iconv('windows-1251', 'utf-8', $str);

	$win1251utf8 = array(
"\xC0"=>"А","\xC1"=>"Б","\xC2"=>"В","\xC3"=>"Г","\xC4"=>"Д","\xC5"=>"Е","\xA8"=>"Ё","\xC6"=>"Ж","\xC7"=>"З","\xC8"=>"И","\xC9"=>"Й","\xCA"=>"К","\xCB"=>"Л","\xCC"=>"М",
"\xCD"=>"Н","\xCE"=>"О","\xCF"=>"П","\xD0"=>"Р","\xD1"=>"С","\xD2"=>"Т","\xD3"=>"У","\xD4"=>"Ф","\xD5"=>"Х","\xD6"=>"Ц","\xD7"=>"Ч","\xD8"=>"Ш","\xD9"=>"Щ","\xDA"=>"Ъ",
"\xDB"=>"Ы","\xDC"=>"Ь","\xDD"=>"Э","\xDE"=>"Ю","\xDF"=>"Я","\xE0"=>"а","\xE1"=>"б","\xE2"=>"в","\xE3"=>"г","\xE4"=>"д","\xE5"=>"е","\xB8"=>"ё","\xE6"=>"ж","\xE7"=>"з",
"\xE8"=>"и","\xE9"=>"й","\xEA"=>"к","\xEB"=>"л","\xEC"=>"м","\xED"=>"н","\xEE"=>"о","\xEF"=>"п","\xF0"=>"р","\xF1"=>"с","\xF2"=>"т","\xF3"=>"у","\xF4"=>"ф","\xF5"=>"х",
"\xF6"=>"ц","\xF7"=>"ч","\xF8"=>"ш","\xF9"=>"щ","\xFA"=>"ъ","\xFB"=>"ы","\xFC"=>"ь","\xFD"=>"э","\xFE"=>"ю","\xFF"=>"я");

	return strtr($str, $win1251utf8);
	}

		function xto($str, $from, $to = 'utf-8')
	{
	if(function_exists('mb_convert_encoding'))return mb_convert_encoding($str, $to, $from);
	if(function_exists('iconv'))return iconv($from, $to, $str);
	return $str;
	}

		function xsubstr($str, $offset = 0,$length = false)
	{
	if($length == false)
		{
		if($offset < 0)$length = abs($offset);
		else $length = xstrlen($str);
		}

	if (function_exists('mb_substr'))return mb_substr($str, $offset, $length, 'utf-8');
	if (function_exists('iconv_substr'))return iconv_substr($str, $offset, $length, 'utf-8');

	$str = xtocp($str);
	$str = substr($str, $offset, $length);
	return xtoutf($str);
}

		function xstrlen($str)
	{
	if (function_exists('mb_strlen'))return mb_strlen($str, 'utf-8');
	if (function_exists('iconv_strlen'))return iconv_strlen($str, 'utf-8');
	return strlen(utf8_decode($str));
	}

		function xtolower($str)
	{
	if (function_exists('mb_strtolower'))return mb_strtolower($str, 'utf-8');
	$arraytolower = array('А'=>'а','Б'=>'б','В'=>'в','Г'=>'г','Д'=>'д','Е'=>'е','Ё'=>'ё','Ж'=>'ж','З'=>'з','И'=>'и','Й'=>'й','К'=>'к','Л'=>'л','М'=>'м','Н'=>'н','О'=>'о','П'=>'п','Р'=>'р','С'=>'с','Т'=>'т','У'=>'у','Ф'=>'ф','Х'=>'х','Ц'=>'ц','Ч'=>'ч','Ш'=>'ш','Щ'=>'щ','Ь'=>'ь','Ъ'=>'ъ','Ы'=>'ы','Э'=>'э','Ю'=>'ю','Я'=>'я','A'=>'a','B'=>'b','C'=>'c','D'=>'d','E'=>'e','I'=>'i','F'=>'f','G'=>'g','H'=>'h','J'=>'j','K'=>'k','L'=>'l','M'=>'m','N'=>'n','O'=>'o','P'=>'p','Q'=>'q','R'=>'r','S'=>'s','T'=>'t','U'=>'u','V'=>'v','W'=>'w','X'=>'x','Y'=>'y','Z'=>'z');
	return strtr($str, $arraytolower);
	}

		function check_captcha($to = MY_URI)
	{
	if(empty($_SESSION['captcha']) || empty($_POST['captcha']) || int($_SESSION['captcha']) != int($_POST['captcha']))
		{
		err('კოდი არასწორია',$to);
		}
	if(!LOCALHOST)unset($_SESSION['captcha']);
	}

		function get_hash($string)
	{

	return md5(strrev(md5(md5($string).$GLOBALS['cfg']['salt'])));

	}

		function get_int_hash($string)
	{

	$salt_int = $GLOBALS['cfg']['salt_int'];

	$strlen = xstrlen($string);
			for($i = 0;$i < $strlen;$i ++)
		{
		$string[$i] = chr(ord($string[$i]) ^ $salt_int);
		}

	return $string;
	}

		function xcookie($name, $value = '')
	{
	return setcookie($name, $value, TIME + 2592000, PATH);
	}

		function postval($name, $val = 1, $bool = true)
	{
	if(!empty($_POST[$name]) && $_POST[$name] == $val)return ($bool ? true : 1);
	return ($bool ? false : 0);
	}

		function xdate($timestamp = NULL, $format = 'j M  G:i', $format_day = true, $format_week = false, $format_month = true)
	{

	if(empty($timestamp))$timestamp = TIME;
	if(empty($format))$format = 'j M  G:i';

	$time_shift = TIME_SHIFT * 3600;

	if($format_week==true)
	{
	$week = array(0 => 'კვირა', 1 => 'ორშაბათი', 2 => 'სამშაბათი', 3 => 'ოთხშაბათი', 4 => 'ხუთშაბათი', 5 => 'პარასკევი', 6 => 'შაბათი');
	$format = str_replace('WEEK', $week[date('w',$timestamp + $time_shift)], $format);
	}

	$date = date($format, $timestamp + $time_shift);
	if($format_day==true)
		{
		$date = str_replace(date('j M',TIME + $time_shift),'დღეს', $date);
		$date = str_replace(date('j M',(TIME - 86400) + $time_shift),'გუშინ', $date);
		$date = str_replace(date('j M',(TIME - 172800) + $time_shift),'გუშინწინ', $date);
		}


	if($format_month==true)
		{
		$months_eng = array('Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec');
		$months_geo = array('იანვარი', 'თებერვალი', 'მარტი', 'აპრილი', 'მაისი', 'ივნისი', 'ივლისი', 'აგვისტო', 'სექტემბერი', 'ოქტომბერი', 'ნოემბერი', 'დეკემბერი');
		$date = str_replace($months_eng, $months_geo, $date);
		}

	return $date;
	}

		function postfix($num,$str3,$str1,$str2)
	{
	if(strlen($num) > 2)$num = substr($num,-2);
	if($num >= 5 && $num <= 20)return $str3;
	$snum = substr($num,1);
	if($snum == 1 || $num == 1)return $str1;
	if(($num >= 2 && $num <= 4) || ($snum >= 2 && $snum <= 4))return $str2;
	return $str3;
	}

		function translit($in)
	{
	$trans1= array('a','b','g','d','e','v','z','T','i','k','l','m','n','o','p','J','r','s','t','u','f','q','R','y','S','C','c','Z','w','W','x','j','h');
	$trans2= array('ა','ბ','გ','დ','ე','ვ','ზ','თ','ი','კ','ლ','მ','ნ','ო','პ','ჟ','რ','ს','ტ','უ','ფ','ქ','ღ','ყ','შ','ჩ','ც','ძ','წ','ჭ','ხ','ჯ','ჰ');
	return str_replace($trans1,$trans2,$in);
	}

		function retranslit($in)
	{
	$trans1= array('ა','ბ','გ','დ','ე','ვ','ზ','თ','ი','კ','ლ','მ','ნ','ო','პ','ჟ','რ','ს','ტ','უ','ფ','ქ','ღ','ყ','შ','ჩ','ც','ძ','წ','ჭ','ხ','ჯ','ჰ');
	$trans2= array('a','b','g','d','e','v','z','T','i','k','l','m','n','o','p','J','r','s','t','u','f','q','R','y','S','C','c','Z','w','W','x','j','h');
	return str_replace($trans1,$trans2,$in);
	}

		function pagebar($str, $page, $uri = null, $print = false)
	{
	if(!$print)$template = $GLOBALS['template'];

	if($str <= 1)return null;

	if(empty($uri))$uri = (stripos(MY_URI, '?') === false ? '?' : '&').'page={$page}';

	$result = '<div class="right_unit">';

	if($page > 1)$result .= '&laquo;<a href="'.str_replace('{$page}', ($page - 1), $uri).'">უკან</a> | ';
	else $result .= '&laquo;უკან | ';
	if($page < $str)$result .= '<a href="'.str_replace('{$page}', ($page + 1), $uri).'">შემდეგ</a>&raquo; ';
	else $result .= 'შემდეგ&raquo;';
	$result .= '<br />';

	$result .= 'გვერდები: ';
	if($page > 1) $result .= '<a href="'.str_replace('{$page}', 1, $uri).'">1</a> ';
	if($page > 2) $result .= '<a href="'.str_replace('{$page}', 2, $uri).'">2</a> ';
	if($page > 3) $result .= '<a href="'.str_replace('{$page}', 3, $uri).'">3</a> ';

	if(($page - 3) > 3) $result .= ' ... ';

	if(($page - 2) > 3) $result .= '<a href="'.str_replace('{$page}', ($page - 2), $uri).'">'.($page - 2).'</a> ';
	if(($page - 1) > 3) $result .= '<a href="'.str_replace('{$page}', ($page - 1), $uri).'">'.($page - 1).'</a> ';

	$result .= '<b>('.$page.')</b>';

	if( ($str - ($page + 1)) > 1) $result .= '<a href="'.str_replace('{$page}', ($page + 1), $uri).'">'.($page + 1).'</a> ';
	if( ($str - ($page + 2)) > 2) $result .= '<a href="'.str_replace('{$page}', ($page + 2), $uri).'">'.($page + 2).'</a> ';

	if(($str - ($page + 2)) > 1) $result .= ' ... ';

	if((($str - 2) - $page) > 2) $result .= '<a href="'.str_replace('{$page}', ($str - 2), $uri).'">'.($str - 2).'</a> ';
	if((($str - 1) - $page) > 0) $result .= '<a href="'.str_replace('{$page}', ($str - 1), $uri).'">'.($str - 1).'</a> ';
	if(($str - $page) > 0)  $result .= '<a href="'.str_replace('{$page}', $str, $uri).'">'.$str.'</a> ';

	$result .= '</div>';

	if($print)echo $result;
	else $template -> pagebar = $result;

	return true;

	}

		function check_page($count = 0, $to = null, $onpage = ONPAGE_POSTS)
	{
	if(empty($to))$to = PATH.'index.php';

	if($count > 0)
		{
		$GLOBALS['str'] = ceil($count / $onpage);

		if(PAGE > $GLOBALS['str'])locate(str_replace('{$page}',$GLOBALS['str'],$to));
		}

	return true;
	}


		function xtime($time, $int = false, $string = true)
	{
	$times = $GLOBALS['times'];

	if($time <= 0)return 0;

			foreach($times as $limit => $strings)
		{
		if($time >= $limit)
			{
			
			$result = int(floor($time / $limit));

			
			if($string)
				{
				$result .= ' '.postfix($result, $strings[0], $strings[1], $strings[2]);
				}

			
			if(!$int && ($time % $limit) != 0)
				{
				$result .= ' <sup><u>'.xtime($time % $limit, true).'</u></sup>';
				}


			return $result;

			}
		}

	return 0;

	}

		function str_delimpos($string1, $string2)
	{
	if(xsubstr($string1, 0, strlen($string2)) == $string2)return xsubstr($string1, strlen($string2));

	return $string1;
	}

		function xsize($size)
	{
	if($size >= 1099511627776)return round($size/1099511627776,1).'Tb';
	if($size >= 1073741824)return round($size/1073741824,1).'Gb';
	if($size >= 1048576)return round($size/1048576,2).'Mb';
	if($size >= 1024)return round($size/1024,2).'Kb';
	return $size.'b';
	}

		function xchmod($file)
	{
	return decoct(fileperms($file)) % 1000;
	}

		function file_write($filename, $mode = 'w', $data = null)
	{

	if(($fp = fopen($filename, $mode)) === false)return false;
	flock($fp, LOCK_EX);
	fwrite($fp, $data);
	flock($fp, LOCK_UN);
	fclose($fp);

	return true;
	}

		function highlight_php($code)
	{
	$result = highlight_string($code, true);
	$result = xsubstr($result, 6, -7);
	$result = preg_replace('~(\r\n|\r|\n)~', null, $result);

	return $result;
	}

		function highlight_html($code)
	{
	$result = preg_replace("~(&quot;|&#039;)[^<>]*(&quot;|&#039;)~iU",'<span style="color:#DD0000">$0</span>',preg_replace("~&lt;!--.*--&gt;~iU",'<span style="color:#FF8000">$0</span>',preg_replace("~(&lt;[^\s!]*\s)([^<>]*)([/?]?&gt;)~iU",'$1<span style="color:#007700">$2</span>$3',preg_replace("~&lt;[^<>]*&gt;~iU",'<span style="color:#0000BB">$0</span>',$code))));


	return $result;
	}


		function highlight_template($code)
	{

	$code = highlight_template_blocks($code);
	$code = highlight_template_ifs($code);
	$code = highlight_template_cycles($code);
	$code = highlight_template_vars($code);

	return $code;
	}

		function highlight_template_ifs($code)
	{

	preg_match_all('~\{if ((\!)?(\~)?\$((.+)(\.(.*))?)( (.*) (\$((.+)(\.(.*))?)|.+))?)\}(.*)\{\/if \\1\}~uUs', $code, $ifs, PREG_SET_ORDER);
	$count_ifs = count($ifs);
	if($count_ifs > 0)
		{
				for($i = 0;$i < $count_ifs;$i ++)
			{
			$value = '<div class="code" title="მდგომარეობა: '.$ifs[$i][1].'"><font color="#000000"><b>{if '.$ifs[$i][1].'}</b></font>'.highlight_template_ifs($ifs[$i][15]).'<font color="#000000"><b>{/if '.$ifs[$i][1].'}</b></font></div>';
			
			$code = preg_replace('~'.preg_quote($ifs[$i][0], '~').'~', $value, $code, 1);
			}
		}

	return $code;
	}

		function highlight_template_cycles($code)
	{

	preg_match_all('~\{foreach (\$(.*))\}(.*)\{\/foreach \\1\}~uUs', $code, $cycles, PREG_SET_ORDER);

	$count_cycles = count($cycles);
	if($count_cycles > 0)
		{
				for($i = 0;$i < $count_cycles;$i ++)
			{
			$value = '<div class="code" title="Цикл : '.$cycles[$i][1].'"><font color="#000000"><b>{foreach '.$cycles[$i][1].'}</b></font>'.highlight_template_cycles($cycles[$i][3]).'<font color="#000000"><b>{/foreach '.$cycles[$i][1].'}</b></font></div>';
			$code = preg_replace('~'.preg_quote($cycles[$i][0], '~').'~', $value, $code, 1);
			}
		}

	return $code;
	}

		function highlight_template_blocks($code)
	{

	preg_match_all('~\{block ((\!)?([^!]*))\}(.*)\{\/block \\1\}~uUs', $code, $blocks, PREG_SET_ORDER);

	$count_blocks = count($blocks);
	if($count_blocks > 0)
		{
				for($i = 0;$i < $count_blocks;$i ++)
			{
			$value = '<div class="code_hover" title="Блок : '.$blocks[$i][1].'"><font color="#000000"><b>{block '.$blocks[$i][1].'}</b></font>'.$blocks[$i][4].'<font color="#000000"><b>{/block '.$blocks[$i][1].'}</b></font></div>';
			$code = preg_replace('~'.preg_quote($blocks[$i][0], '~').'~', $value, $code, 1);
			}

		}

	return $code;
	}

		function highlight_template_vars($code)
	{

	$code = preg_replace('~\{\$((.*)(\.(.*))?)\}~uUs', '<font color="#000000" title="ცვლადი \$$1"><b>$0</b></font>', $code);

	return $code;
	}

		function create_rss_file($data)
	{
	$result = '<?xml version="1.0" encoding="utf-8"?><rss version="2.0"><channel>';

	if(isset($data['title']))$result .= '<title>'.$data['title'].'</title>';
	if(isset($data['link']))$result .= '<link>'.$data['link'].'</link>';
	if(isset($data['description']))$result .= '<description>'.$data['description'].'</description>';
	$result .= '<language>'.(isset($data['language']) ? $data['language'] : 'ru').'</language>';
	$result .= '<pubDate>'.(isset($data['pub_date']) ? $data['pub_date'] : '').'</pubDate>';
	$result .= '<lastBuildDate>'.(isset($data['build_date']) ? $data['build_date'] : date('r')).'</lastBuildDate>';

	if(!empty($data['values']))
		{
				for($c = count($data['values']), $i = 0;$i < $c;$i ++)
			{
			$result .= '<item>';

			if(!empty($data['values'][$i]['title']))$result .= '<title>'.$data['values'][$i]['title'].'</title>';
			if(!empty($data['values'][$i]['link']))$result .= '<link>'.$data['values'][$i]['link'].'</link>';
			if(!empty($data['values'][$i]['guid']))$result .= '<guid>'.$data['values'][$i]['guid'].'</guid>';
			if(!empty($data['values'][$i]['pub_date']))$result .= '<pub_date>'.$data['values'][$i]['pub_date'].'</pub_date>';
			if(!empty($data['values'][$i]['description']))$result .= '<description>'.$data['values'][$i]['description'].'</description>';
			

			$result .= '</item>';
			}

		}

	$result .= '</channel></rss>';

	return $result;
	}


		function loadfile($file = null, $content = null, $filename = null, $mimetype = null)
	{
	if(empty($file) || !file_exists($file))$nofile = true;
	else $nofile = false;

	if(empty($mimetype))$mimetype = 'application/octet-stream';

	header('HTTP/1.1 200 Ok');
	$md5 = md5($nofile ? $filename : $file);
	$etag = substr($md5,0,10).substr($md5,15,20);
	header('ETag: "'.$etag.'"');
	

	header('Content-Length: '.($nofile ? strlen($content) : filesize($file)));

	header('Connection: close');
	header('Content-Type: '.$mimetype);
	header('Last-Modified: '.gmdate('r'));
	header('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT');
	header('Expires: '.gmdate('D, d M Y H:i:s', time() + 3600).' GMT');
	header('Content-Disposition: '.(strtok($mimetype,'/') != 'image' ? 'attachment;' : null).' filename="'.(!empty($filename) ? $filename : basename($file)).'";');
	header('Content-Encoding: none');
	if($nofile)echo $content;
	else readfile($file);

	}

		function set_eol($string)
	{
	return preg_replace('~(\r\n|\r|\n)~u', "\r\n", $string);
	}


?>