<?php
/**
* acp_permissions (phpBB Permission Set) [Russian]
*
* @package language
* @version $Id: permissions_phpbb.php 9686 2009-06-26 11:52:54Z rxu $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

/**
*	MODDERS PLEASE NOTE
*
*	You are able to put your permission sets into a separate file too by
*	prefixing the new file with permissions_ and putting it into the acp
*	language folder.
*
*	An example of how the file could look like:
*
*	<code>
*
*	if (empty($lang) || !is_array($lang))
*	{
*		$lang = array();
*	}
*
*	// Adding new category
*	$lang['permission_cat']['bugs'] = 'Bugs';
*
*	// Adding new permission set
*	$lang['permission_type']['bug_'] = 'Bug Permissions';
*
*	// Adding the permissions
*	$lang = array_merge($lang, array(
*		'acl_bug_view'		=> array('lang' => 'Can view bug reports', 'cat' => 'bugs'),
*		'acl_bug_post'		=> array('lang' => 'Can post bugs', 'cat' => 'post'), // Using a phpBB category here
*	));
*
*	</code>
*/

// Define categories and permission types
$lang = array_merge($lang, array(
	'permission_cat'	=> array(
		'actions'		=> 'მოქმედებები',
		'content'		=> 'შიგთავსი',
		'forums'		=> 'ფორუმები',
		'misc'			=> 'სხვადასხვა',
		'permissions'	=> 'წვდომის უფლებები',
		'pm'			=> 'პირადი წერილები',
		'polls'			=> 'გამოკითხვები',
		'post'			=> 'წერილების განთავსება',
		'post_actions'	=> 'წერილებზე მოქმედება',
		'posting'		=> 'წერილები',
		'profile'		=> 'პროფილი',
		'settings'		=> 'კონფიგურაცია',
		'topic_actions'	=> 'თემებზე მოქმედება',
		'user_group'	=> 'მომხმარებლები',
	),

	// With defining 'global' here we are able to specify what is printed out if the permission is within the global scope.
	'permission_type'	=> array(
		'u_'			=> 'მომხმარებლის წვდომის უფლებები',
		'a_'			=> 'ადმინისტრატორის წვდომის უფლებები',
		'm_'			=> 'მოდერატორის წვდომის უფლებები',
		'f_'			=> 'ფორუმზე წვდომის უფლებები',
		'global'		=> array(
			'm_'			=> 'მოდერატორის გლობალური წვდომის უფლებები',
		),
	),
));

// User Permissions
$lang = array_merge($lang, array(
	'acl_u_viewprofile'	=> array('lang' => 'შეუძლია ნახოს პროფილები, მომხმარებელის სია და გვერდი «ვინ არის ეხლა საიტზე»', 'cat' => 'profile'),
	'acl_u_chgname'		=> array('lang' => 'შეუძლია შეცვალოს სახელი', 'cat' => 'profile'),
	'acl_u_chgpasswd'	=> array('lang' => 'შეუძლია შეცვალოს პაროლი', 'cat' => 'profile'),
	'acl_u_chgemail'	=> array('lang' => 'შეუძლია შეცვალოს ელ-ფოსტის მისამართი', 'cat' => 'profile'),
	'acl_u_chgavatar'	=> array('lang' => 'შეუძლია შეცვალოს ავატარი', 'cat' => 'profile'),
	'acl_u_chggrp'		=> array('lang' => 'შეუძლია შეცვალოს ავტომატური ჯგუფი', 'cat' => 'profile'),

	'acl_u_attach'		=> array('lang' => 'შეუძლია ფაილის მიმაგრება', 'cat' => 'post'),
	'acl_u_download'	=> array('lang' => 'შეუძლია ფაილის გადმოწერა', 'cat' => 'post'),
	'acl_u_savedrafts'	=> array('lang' => 'შეუძლია დროებით საქაღალდეში შენახვა', 'cat' => 'post'),
	'acl_u_chgcensors'	=> array('lang' => 'შეუძლია ავტოცენზურის გამორთვა', 'cat' => 'post'),
	'acl_u_sig'			=> array('lang' => 'შეუძლია გამოიყენოს ხელმოწერა', 'cat' => 'post'),

	'acl_u_sendpm'		=> array('lang' => 'შეუძლია პირადი წერილის გაგზავნა', 'cat' => 'pm'),
	'acl_u_masspm'		=> array('lang' => 'შეუძლია პირადი წერილის რამდენიმე მომხმარებლისთვის გაგზავნა', 'cat' => 'pm'),
	'acl_u_masspm_group'=> array('lang' => 'შეუძლია პირადი წერილის მომხმარებლის ჯგუფისთვის გაგზავნა', 'cat' => 'pm'),
	'acl_u_readpm'		=> array('lang' => 'შეუძლია პირადი წერილის წაკითხვა', 'cat' => 'pm'),
	'acl_u_pm_edit'		=> array('lang' => 'შეუძლია პირადი წერილის რედაქტირება', 'cat' => 'pm'),
	'acl_u_pm_delete'	=> array('lang' => 'შეუძლია საკუთარი საქაღალდიდან პირადი წერილების წაშლა', 'cat' => 'pm'),
	'acl_u_pm_forward'	=> array('lang' => 'შეუძლია პირადი წერილის გადაგზავნა', 'cat' => 'pm'),
	'acl_u_pm_emailpm'	=> array('lang' => 'შეუძლია პირადი წერილის ელ-ფოსტით გაგზავნა', 'cat' => 'pm'),
	'acl_u_pm_printpm'	=> array('lang' => 'შეუძლია პირადი წერილის დაბეჭდვა', 'cat' => 'pm'),
	'acl_u_pm_attach'	=> array('lang' => 'შეუძლია პირად წერილზე ფაილის მიმაგრება', 'cat' => 'pm'),
	'acl_u_pm_download'	=> array('lang' => 'შეუძლია პირადი წერილიდან ფაილის გადმოწერა', 'cat' => 'pm'),
	'acl_u_pm_bbcode'	=> array('lang' => 'შეუძლია გამოიყენოს BBCode პირად წერილში', 'cat' => 'pm'),
	'acl_u_pm_smilies'	=> array('lang' => 'შეუძლია გამოიყენოს სმაილები в პირადი წერილი', 'cat' => 'pm'),
	'acl_u_pm_img'		=> array('lang' => 'შეუძლია გამოიყენოს тег [img] в პირადი წერილი', 'cat' => 'pm'),
	'acl_u_pm_flash'	=> array('lang' => 'შეუძლია გამოიყენოს тег [flash] в პირადი წერილი', 'cat' => 'pm'),

	'acl_u_send-email'	=> array('lang' => 'შეუძლია ელ-ფოსტის წერილების გაგზავნა', 'cat' => 'misc'),
	'acl_u_sendim'		=> array('lang' => 'შეუძლია გამოიყენოს დაუყოვნებული წერილების გაგზავნის სისტემა', 'cat' => 'misc'),
	'acl_u_ignoreflood'	=> array('lang' => 'შეუძლია ფლუდ-კონტროლის იგნორირება', 'cat' => 'misc'),
	'acl_u_hideonline'	=> array('lang' => 'შეუძლია დამალოს ფორუმზე ყოფნის სტატუსი', 'cat' => 'misc'),
	'acl_u_viewonline'	=> array('lang' => 'შეუძლია ნახოს ფორუმზე ყოფნის სტატუსი', 'cat' => 'misc'),
	'acl_u_search'		=> array('lang' => 'შეუძლია ძიების გამოიყენება', 'cat' => 'misc'),
));

// Forum Permissions
$lang = array_merge($lang, array(
	'acl_f_list'		=> array('lang' => 'შეუძლია ფორუმის დანახვა', 'cat' => 'post'),
	'acl_f_read'		=> array('lang' => 'შეუძლია ფორუმის წაკითხვა', 'cat' => 'post'),
	'acl_f_post'		=> array('lang' => 'შეუძლია თემების შექმნა', 'cat' => 'post'),
	'acl_f_reply'		=> array('lang' => 'შეუძლია თემებში პასუხის გაცემა', 'cat' => 'post'),
	'acl_f_icons'		=> array('lang' => 'შეუძლია გამოიყენოს წერილების და თემების ნიშნები', 'cat' => 'post'),
	'acl_f_announce'	=> array('lang' => 'შეუძლია განცხადებების შექმნა', 'cat' => 'post'),
	'acl_f_sticky'		=> array('lang' => 'შეუძლია თემების მიმაგრება', 'cat' => 'post'),

	'acl_f_poll'		=> array('lang' => 'შეუძლია გამოკითხვის შექმნა', 'cat' => 'polls'),
	'acl_f_vote'		=> array('lang' => 'შეუძლია გამოკითხვებში ხმის მიცემა', 'cat' => 'polls'),
	'acl_f_votechg'		=> array('lang' => 'შეუძლია თავიდან მისცეს ხმა', 'cat' => 'polls'),

	'acl_f_attach'		=> array('lang' => 'შეუძლია ფაილის მიმაგრება', 'cat' => 'content'),
	'acl_f_download'	=> array('lang' => 'შეუძლია ფაილების გადმოწერა', 'cat' => 'content'),
	'acl_f_sigs'		=> array('lang' => 'შეუძლია გამოიყენოს ხელმოწერა', 'cat' => 'content'),
	'acl_f_bbcode'		=> array('lang' => 'შეუძლია გამოიყენოს BBCode', 'cat' => 'content'),
	'acl_f_smilies'		=> array('lang' => 'შეუძლია გამოიყენოს სმაილები', 'cat' => 'content'),
	'acl_f_img'			=> array('lang' => 'შეუძლია გამოიყენოს ტეგი [img]', 'cat' => 'content'),
	'acl_f_flash'		=> array('lang' => 'შეუძლია გამოიყენოს ტეგი [flash]', 'cat' => 'content'),

	'acl_f_edit'		=> array('lang' => 'შეუძლია საკუთარი წერილების რედაქტირება', 'cat' => 'actions'),
	'acl_f_delete'		=> array('lang' => 'შეუძლია წაშალოს საკუთარი წერილები', 'cat' => 'actions'),
	'acl_f_user_lock'	=> array('lang' => 'შეუძლია დახუროს საკუთარი თემები', 'cat' => 'actions'),
	'acl_f_bump'		=> array('lang' => 'შეუძლია ასწიოს საკუთარი თემები', 'cat' => 'actions'),
	'acl_f_report'		=> array('lang' => 'შეუძლია საჩივრების განთავსება', 'cat' => 'actions'),
	'acl_f_subscribe'	=> array('lang' => 'შეუძლია ფორუმების გამოწერა', 'cat' => 'actions'),
	'acl_f_print'		=> array('lang' => 'შეუძლია თემების დაბეჭდვა', 'cat' => 'actions'),
	'acl_f_e-mail'		=> array('lang' => 'შეუძლია აცნობოს (მეგობარს) ელ-ფოსტით თემის შესახებ', 'cat' => 'actions'),

	'acl_f_search'		=> array('lang' => 'შეუძლია ფორუმზე ძებნის გამოყენება', 'cat' => 'misc'),
	'acl_f_ignoreflood' => array('lang' => 'შეუძლია ფლუდ-კონტროლის იგნორირება', 'cat' => 'misc'),
	'acl_f_postcount'	=> array('lang' => 'წერილების მრიცხველი ჩართულია<br /><em>გაითვალისწინეთ, რომ ეს ფუნქცია ეფექტურია მხოლოდ ახალი წერილების შექმნისას.</em>', 'cat' => 'misc'),
	'acl_f_noapprove'	=> array('lang' => 'შეუძლია წერილების დასტურის გარეშე განთავსება', 'cat' => 'misc'),
));

// Moderator Permissions
$lang = array_merge($lang, array(
	'acl_m_edit'		=> array('lang' => 'შეუძლია რედაქტირება წერილები', 'cat' => 'post_actions'),
	'acl_m_delete'		=> array('lang' => 'შეუძლია წერილების წაშლა', 'cat' => 'post_actions'),
	'acl_m_approve'		=> array('lang' => 'შეუძლია წერილების დადასტურება', 'cat' => 'post_actions'),
	'acl_m_report'		=> array('lang' => 'შეუძლია საჩივრების დახურვა/წაშლა', 'cat' => 'post_actions'),
	'acl_m_chgposter'	=> array('lang' => 'შეუძლია შეცვალოს წერილის ავტორი', 'cat' => 'post_actions'),

	'acl_m_move'	=> array('lang' => 'შეუძლია თემის გადატანა', 'cat' => 'topic_actions'),
	'acl_m_lock'	=> array('lang' => 'შეუძლია თემის დახურვა', 'cat' => 'topic_actions'),
	'acl_m_split'	=> array('lang' => 'შეუძლია თემის გაყოფა', 'cat' => 'topic_actions'),
	'acl_m_merge'	=> array('lang' => 'შეუძლია თემის გაერთიანება', 'cat' => 'topic_actions'),

	'acl_m_info'	=> array('lang' => 'შეუძლია წერილების დეტალების ნახვა', 'cat' => 'misc'),
	'acl_m_warn'	=> array('lang' => 'შეუძლია გაფრთხილების გამოტანა<br /><em>ეს უფლება შეიძლება მინიჭებული იყოს მხოლოდ გლობალურად, და არა ფორუმების დონეზე.</em>', 'cat' => 'misc'), // This moderator setting is only global (and not local)
	'acl_m_ban'		=> array('lang' => 'შეუძლია მართოს ბლოკირება<br /><em>ეს უფლება შეიძლება მინიჭებული იყოს მხოლოდ გლობალურად, და არა ფორუმების დონეზე.</em>', 'cat' => 'misc'), // This moderator setting is only global (and not local)
));

// Admin Permissions
$lang = array_merge($lang, array(
	'acl_a_board'		=> array('lang' => 'შეუძლია ფორუმის პარამეტრების და განახლებების ნახვა', 'cat' => 'settings'),
	'acl_a_server'		=> array('lang' => 'შეუძლია სერვერის პარამეტრების შეცვლა', 'cat' => 'settings'),
	'acl_a_jabber'		=> array('lang' => 'შეუძლია შეცვალოთ პარამეტრები Jabber', 'cat' => 'settings'),
	'acl_a_phpinfo'		=> array('lang' => 'შეუძლია ინფორმაციის ნახვა php-ზე', 'cat' => 'settings'),

	'acl_a_forum'		=> array('lang' => 'შეუძლია ფორუმების მართვა', 'cat' => 'forums'),
	'acl_a_forumadd'	=> array('lang' => 'შეუძლია ფორუმის შექმნა', 'cat' => 'forums'),
	'acl_a_forumdel'	=> array('lang' => 'შეუძლია ფორუმის წაშლა', 'cat' => 'forums'),
	'acl_a_prune'		=> array('lang' => 'შეუძლია ფორუმის გასუფთავება', 'cat' => 'forums'),

	'acl_a_icons'		=> array('lang' => 'შეუძლია თემის ნიშნების, წერილების და სმაილების შეცვლა', 'cat' => 'posting'),
	'acl_a_words'		=> array('lang' => 'შეუძლია მომართოს ავტოცენზურა', 'cat' => 'posting'),
	'acl_a_bbcode'		=> array('lang' => 'შეუძლია განსაზღვროს BBCode', 'cat' => 'posting'),
	'acl_a_attach'		=> array('lang' => 'შეუძლია მიმაგრებული ფაილების პარამეტრების შეცვლა', 'cat' => 'posting'),

	'acl_a_user'		=> array('lang' => 'შეუძლია მომხმარებლის მართვა<br /><em>უფლება ასევე შეიცავს ფორუმზე მყოფი მომხმარებლის ბრაუზერის ტიპის ნახვას.</em>', 'cat' => 'user_group'),
	'acl_a_userdel'		=> array('lang' => 'შეუძლია მომხმარებლის წაშლა', 'cat' => 'user_group'),
	'acl_a_group'		=> array('lang' => 'შეუძლია ჯგუფის მართვა', 'cat' => 'user_group'),
	'acl_a_groupadd'	=> array('lang' => 'შეუძლია ჯგუფის შექმნა', 'cat' => 'user_group'),
	'acl_a_groupdel'	=> array('lang' => 'შეუძლია ჯგუფის წაშლა', 'cat' => 'user_group'),
	'acl_a_ranks'		=> array('lang' => 'შეუძლია წოდებების მართვა', 'cat' => 'user_group'),
	'acl_a_profile'		=> array('lang' => 'შეუძლია მართოს დამატებითი ველები პროფილში', 'cat' => 'user_group'),
	'acl_a_names'		=> array('lang' => 'შეუძლია მართოს აკრძალული სახელები', 'cat' => 'user_group'),
	'acl_a_ban'			=> array('lang' => 'შეუძლია მართოს ბლოკირება', 'cat' => 'user_group'),

	'acl_a_viewauth'	=> array('lang' => 'შეუძლია წვდომის უფლებების ნახვა', 'cat' => 'permissions'),
	'acl_a_authgroups'	=> array('lang' => 'შეუძლია კონკრეტული ჯგუფის წვდომის უფლებების შეცვლა', 'cat' => 'permissions'),
	'acl_a_authusers'	=> array('lang' => 'შეუძლია კონკრეტული მომხმარებლის წვდომის უფლებების შეცვლა', 'cat' => 'permissions'),
	'acl_a_fauth'		=> array('lang' => 'შეუძლია შეცვალოს წვდომის უფლებები ფორუმებში', 'cat' => 'permissions'),
	'acl_a_mauth'		=> array('lang' => 'შეუძლია მოდერატორის წვდომის უფლებების შეცვლა', 'cat' => 'permissions'),
	'acl_a_aauth'		=> array('lang' => 'შეუძლია ადმინისტრატორის წვდომის უფლებების შეცვლა', 'cat' => 'permissions'),
	'acl_a_uauth'		=> array('lang' => 'შეუძლია მომხმარებელის წვდომის უფლებების შეცვლა', 'cat' => 'permissions'),
	'acl_a_roles'		=> array('lang' => 'შეუძლია როლების მართვა', 'cat' => 'permissions'),
	'acl_a_switchperm'	=> array('lang' => 'შეუძლია წვდომის სხვა უფლებების შეცვლა', 'cat' => 'permissions'),

	'acl_a_styles'		=> array('lang' => 'შეუძლია სტილების მართვა', 'cat' => 'misc'),
	'acl_a_viewlogs'	=> array('lang' => 'შეუძლია ლოგების ნახვა', 'cat' => 'misc'),
	'acl_a_clearlogs'	=> array('lang' => 'შეუძლია გაასუფთავოს ლოგი', 'cat' => 'misc'),
	'acl_a_modules'		=> array('lang' => 'შეუძლია მოდულების მართვა', 'cat' => 'misc'),
	'acl_a_language'	=> array('lang' => 'შეუძლია მართოს ენების პაკეტი', 'cat' => 'misc'),
	'acl_a_email'		=> array('lang' => 'შეუძლია განახორციელოს წერილების მასობრივი დაგზავნა', 'cat' => 'misc'),
	'acl_a_bots'		=> array('lang' => 'შეუძლია მართოს ბოტები', 'cat' => 'misc'),
	'acl_a_reasons'		=> array('lang' => 'შეუძლია მართოს საჩივრების/მიზეზების სია', 'cat' => 'misc'),
	'acl_a_backup'		=> array('lang' => 'შეუძლია შეინახოს/აღადგინოს მონაცემთა ბაზები', 'cat' => 'misc'),
	'acl_a_search'		=> array('lang' => 'შეუძლია მართოს საძიებო ინდექსები/ძიების პარამეტრები', 'cat' => 'misc'),
));

?>