<?php
/**
*
* common [Russian]
*
* @package language
* @version $Id: common.php 9845 2009-07-24 11:13:32Z acydburn $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste:
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> '<a href=\'index.php\'>სულხანი გორაძე </a>',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|დ.თ.წ|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'ქა',

	'1_DAY'			=> '1 დღე',
	'1_MONTH'		=> '1 თვე',
	'1_YEAR'		=> '1 წელი',
	'2_WEEKS'		=> '2 კვირა',
	'3_MONTHS'		=> '3 თვე',
	'6_MONTHS'		=> '6 თვე',
	'7_DAYS'		=> '7 დღე',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'თქვენი პროფილი უკვე აქტივირებულია.',
	'ACCOUNT_DEACTIVATED'			=> 'თქვენი პროფილი გამორთულია და მხოლოდ კონფერენციის ადმინისტრატორის შეუძლია გააქტიურება.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'თქვენი პროფილი გასააქტიურებელია.',
	'ACP'							=> 'ადმინისტრატორის განყოფილება',
	'ACTIVE'						=> 'აქტიურია',
	'ACTIVE_ERROR'					=> 'ამ დროისთვის მითითებული მომხმარებლის სახელი არააქტიურია. თუ თქვენ გიჭირთ საკუთარი პროფილის აქტივაცია დაუკავშირდით კონფერენციის ადმინისტრატორს.',
	'ADMINISTRATOR'					=> 'ადმინისტრატორი',
	'ADMINISTRATORS'				=> 'ადმინისტრატორები',
	'AGE'							=> 'ასაკი',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'დაშვებულია',
	'ALL_FILES'						=> 'ყველა ფაილი',
	'ALL_FORUMS'					=> 'ყველა ფორუმი',
	'ALL_MESSAGES'					=> 'ყველა შეტყობინება',
	'ALL_POSTS'						=> 'ყველა პოსტი',
	'ALL_TIMES'						=> 'დროის სარტყელი: %1$s %2$s',
	'ALL_TOPICS'					=> 'ყველა თემა',
	'AND'							=> 'და',
	'ARE_WATCHING_FORUM'			=> 'თქვენ გამოიწერეთ ამ ფორუმის ახალი შეტყობინებები.',
	'ARE_WATCHING_TOPIC'			=> 'თქვენ გამოიწერეთ ამ თემის ახალი შეტყობინებები.',
	'ASCENDING'						=> 'მატებით',
	'ATTACHMENTS'					=> 'მიმაგრებული ფაილები',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'თქვენ ცდილობდით დაუშვებელი ფაილის ტიპის გაგზავნას.',
	'AUTHOR'						=> 'ავტორი',
	'AUTH_NO_PROFILE_CREATED'		=> 'მომხმარებლის პროფილის შექმნა ვერ მოხერხდა.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'ატვირთვა შეწყდა, რადგანაც მიბმული ფაილი აღქმულია როგორც ვირუსი.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'მოცემული ფაილი არ გამოჩნდება, რადგანაც გაფართოება <strong>%s</strong> არ არის ნებადართული',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'აღნიშნული ავატარის ატვირთვა ვერ მოხერხდა. შესაძლოა მონაცემები დაზიანებულია ან არ არის ნებადართული.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'ატვირთული ავატარის ფაილი ცარიელია.',
	'AVATAR_INVALID_FILENAME'		=> '%s ფაილის დაუშვებელი სახელი.',
	'AVATAR_NOT_UPLOADED'			=> 'ავატარის ატვირთვა ვერ მოხერხდა.',
	'AVATAR_NO_SIZE'				=> 'ავატარის ზომის განსაზღვრა ვერ მოხერხდა. გთხოვთ მიუთითეთ ხელით.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'ფაილი მხოლოდ ნაწილობრივ არის ატვირთული',
	'AVATAR_PHP_SIZE_NA'			=> 'ავატარის საკმაოდ დიდი ზომის ფაილი.<br />ვერ განისაზღვრა ავატარის მაქს. ზომა, მითითებული php.ini.',
	'AVATAR_PHP_SIZE_OVERRUN'		=> 'ავატარის საკმაოდ დიდი ზომის ფაილი. მაქსიმალური დასაშვები ზომა — %1$d %2$s.<br />მინიშნება: ეს შეზღუდვა მითითებულია php.ini ფაილში და ვერ გადასცდება აღნიშნულს.',
	'AVATAR_URL_INVALID'			=> 'ავატარის მითითებული მისამართი დაუშვებელია.',
	'AVATAR_URL_NOT_FOUND'			=> 'მითითებული ავატარის ფაილი ვერ მოიძებნა.',
	'AVATAR_WRONG_FILESIZE'			=> 'ავატარის ფაილის ზომა უნდა იყოს  0 -დან %1d %2s -მდე დიაპაზონში.',
	'AVATAR_WRONG_SIZE'				=> 'ავატარის ზომა — %5$d×%6$d. ავატარის ზომა უნდა იყოს არანაკლებ %1$d×%2$d, მაგრამ არა უმეტეს %3$d×%4$d. ყველა ზომა მითითებულია პიქსელებში.',

	'BACK_TO_TOP'			=> 'დასაწყისში დაბრუნება',
	'BACK_TO_PREV'			=> 'წინა გვერდზე დაბრუნება',
	'BAN_TRIGGERED_BY_EMAIL'=> 'თქვენი ელ-ფოსტისთვის ფორუმზე წვდომა დახურულია.',
	'BAN_TRIGGERED_BY_IP'	=> 'თქვენი IP-მისამართისთვის ფორუმზე წვდომა დახურულია.',
	'BAN_TRIGGERED_BY_USER'	=> 'თქვენი ანგარიშისთვის ფორუმზე წვდომა დახურულია.',
	'BBCODE_GUIDE'			=> 'BBCode სახელმძღვანელო',
	'BCC'					=> 'ფარული ასლი',
	'BIRTHDAYS'				=> 'დაბადების დღეები',
	'BOARD_BAN_PERM'		=> 'თქვენთვის ფორუმზე წვდომა დახურულია.<br /><br />დამატებითი ინფორმაციის მისაღებად %2$s დაუკავშირდით ადმინისტრატორს %3$s.',
	'BOARD_BAN_REASON'		=> 'მიზეზი: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'თქვენთვის ფორუმზე წვდომა დახურულია <strong>%1$s -მდე</strong>.<br /><br />დამატებითი ინფორმაციის მისაღებად %2$sდაუკავშირდით ადმინისტრატორს%3$s.',
	'BOARD_DISABLE'			=> 'უკაცრავად, მაგრამ ამ დროისთვის ფორუმი მიუწვდომელია',
	'BOARD_DISABLED'		=> 'ამ დროისთვის ფორუმი დახურულია.',
	'BOARD_UNAVAILABLE'		=> 'ფორუმი დროებით დახურულია. სცადეთ შესვლა რამდენიმე წუთის შემდეგ.',
	'BROWSING_FORUM'		=> 'ამ დროისთვის ამ ფორუმს ათვალიერებს: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'ამ დროისთვის ამ ფორუმს ათვალიერებს: %1$s და სტუმარი: %2$d',
	'BROWSING_FORUM_GUESTS'	=> 'ამ დროისთვის ამ ფორუმს ათვალიერებს: %1$s და სტუმარი: %2$d',
	'BYTES'					=> 'ბაიტი',

	'CANCEL'				=> 'გაუქმება',
	'CHANGE'				=> 'შეცვლა',
	'CHANGE_FONT_SIZE'		=> 'შრიფტის ზომის შეცვლა',
	'CHANGING_PREFERENCES'	=> 'საკუთარი პროფილის შეცვლა',
	'CHANGING_PROFILE'		=> 'პროფილის პარამეტრების შეცვლა',
	'CLICK_VIEW_PRIVMSG'	=> '%sგადასვლა «შემოსულებში»%s',
	'COLLAPSE_VIEW'			=> 'ჩახურვა',
	'CLOSE_WINDOW'			=> 'ფანჯრის დახურვა',
	'COLOUR_SWATCH'			=> 'პალიტრა',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'დასტური',
	'CONFIRM_CODE'			=> 'დასტურის კოდი',
	'CONFIRM_CODE_EXPLAIN'	=> 'შეიყვანეთ კოდი, რეგისტრს მნიშვნელობა არ აქვს.',
	'CONFIRM_CODE_WRONG'	=> 'კოდი არასწორად არის შეყვანილი.',
	'CONFIRM_OPERATION'		=> 'დარწმუნებული ხართ, რომ გინდათ ამ მოქმედების შესრულება?',
	'CONGRATULATIONS'		=> 'გილოცავთ',
	'CONNECTION_FAILED'		=> 'დაკავშირების შეცდომა.',
	'CONNECTION_SUCCESS'	=> 'კავშირი წარმატებით დამყარდა.',
	'COOKIES_DELETED'		=> 'ყველა cookies წარმატებით წაშლილია.',
	'CURRENT_TIME'			=> 'მიმდინარე დრო: %s',

	'DAY'					=> 'დღე',
	'DAYS'					=> 'დღე',
	'DELETE'				=> 'წაშლა',
	'DELETE_ALL'			=> 'ყველაფრის წაშლა',
	'DELETE_COOKIES'		=> 'ფორუმიდან cookies წაშლა',
	'DELETE_MARKED'			=> 'მონიშნულის წაშლა',
	'DELETE_POST'			=> 'პოსტის წაშლა',
	'DELIMITER'				=> 'გამყოფი',
	'DESCENDING'			=> 'კლებადობით',
	'DISABLED'				=> 'გამორთულია',
	'DISPLAY'				=> 'ჩართვა',
	'DISPLAY_GUESTS'		=> 'სტუმრების ჩვენება',
	'DISPLAY_MESSAGES'		=> 'შეტყობინებების ჩვენება',
	'DISPLAY_POSTS'			=> 'წერილების ჩვენება',
	'DISPLAY_TOPICS'		=> 'თემების ჩვენება',
	'DOWNLOADED'			=> 'გადმოწერილია:',
	'DOWNLOADING_FILE'		=> 'ფაილის გადმოწერა',
	'DOWNLOAD_COUNT'		=> 'გადმოწერილია: %d',
	'DOWNLOAD_COUNTS'		=> 'გადმოწერილია: %d',
	'DOWNLOAD_COUNT_NONE'	=> 'გადმოწერილია: 0',
	'VIEWED_COUNT'			=> 'ნანახია: %d',
	'VIEWED_COUNTS'			=> 'ნანახია: %d',
	'VIEWED_COUNT_NONE'		=> 'ნანახია: 0',

	'EDIT_POST'							=> 'წერილის რედაქტირება',
	'EMAIL'								=> 'ელ-ფოსტა', // Short form for ელ-ფოსტა_ADDRESS
	'EMAIL_ADDRESS'						=> 'ელ-ფოსტა',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'წერილის გაგზავნის შეცდომა<strong>ხაზში %1$s</strong>. სერვერის პასუხი: %2$s.',
	'EMPTY_SUBJECT'						=> 'ახალი თემის შექმნისას აუცილებელია სათაურის მითითება.',
	'EMPTY_MESSAGE_SUBJECT'				=> 'მიუთითეთ ახალი შეტყობინების თემა.',
	'ENABLED'							=> 'ჩართულია',
	'ENCLOSURE'							=> 'შემზღუდავი',
	'ENTER_USERNAME'					=> 'შეიყვანეთ მომხმარებლის სახელი',
	'ERR_CHANGING_DIRECTORY'			=> 'საქაღალდის შეცვლა ვერ მოხერხდა.',
	'ERR_CONNECTING_SERVER'				=> 'სერვერთან მიერთების შეცდომა.',
	'ERR_JAB_AUTH'						=> 'Jabber სერვერზე ვერ მოხერხდა ავტორიზაციის გავლა.',
	'ERR_JAB_CONNECT'					=> 'Jabber სერვერთთან ვერ მოხერხდა დაკავშირება.',
	'ERR_UNABLE_TO_LOGIN'				=> 'მომხმარებლის არასწორი სახელი ან პაროლი.',
	'ERR_UNWATCHING'					=> 'გამოწერის გაუქმების მცდელობისას მოხდა შეცდომა.',
	'ERR_WATCHING'						=> 'გამოწერის მცდელობისას მოხდა შეცდომა.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'მითითებული კონფერენციის მისამართი არასწორია.',
	'EXPAND_VIEW'						=> 'გაშლა',
	'EXTENSION'							=> 'გაფართოება',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'გაფართოება <strong>%s</strong> აკრძალულია.',

	'FAQ'					=> 'FAQ',
	'FAQ_EXPLAIN'			=> 'ხშირად დასმული შეკითხვები',
	'FILENAME'				=> 'ფაილის სახელი',
	'FILESIZE'				=> 'ფაილის ზომა',
	'FILEDATE'				=> 'ფაილის შექმნის თარიღი',
	'FILE_COMMENT'			=> 'ფაილის კომენტარები',
	'FILE_NOT_FOUND'		=> 'მოთხოვნილი ფაილი არ მოიძებნა.',
	'FIND_USERNAME'			=> 'მომხმარებლის ძებნა',
	'FOLDER'				=> 'საქაღალდე',
	'FORGOT_PASS'			=> 'დაგავიწყდათ პაროლი?',
	'FORM_INVALID'			=> 'ფორმის გაგზავნის შეცდომა. კიდევ სცადეთ.',
	'FORUM'					=> 'ფორუმი',
	'FORUMS'				=> 'ფორუმები',
	'FORUMS_MARKED'			=> 'არჩეული ფორუმები აღნიშნულია როგორც წაკითხულები',
	'FORUM_CAT'				=> 'კატეგორია',
	'FORUM_INDEX'			=> 'ფორუმების ჩამონათვალი',
	'FORUM_LINK'			=> 'ფორუმის ბმული',
	'FORUM_LOCATION'		=> 'ადგილი კონფერენიაში',
	'FORUM_LOCKED'			=> 'ფორუმი დახურულია',
	'FORUM_RULES'			=> 'ფორუმის წესები',
	'FORUM_RULES_LINK'		=> 'ფორუმის წესების ნახვა',
	'FROM'					=> 'დან',
	'FSOCK_DISABLED'		=> 'მოქმედება ვერ დასრულდება, ფუნქცია<var>fsockopen</var> გამორთულია ან სერვერი ვერ მოიძებნა.',
	'FSOCK_TIMEOUT'			=> 'მიერთების ტაიმაუტი.',

	'FTP_FSOCK_HOST'				=> 'FTP-სერვერი',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'FTP-სერვერი საიტთან მიერთებისათვის.',
	'FTP_FSOCK_PASSWORD'			=> 'პაროლი FTP',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'პაროლი FTP-სერვერზე შესასვლელად.',
	'FTP_FSOCK_PORT'				=> 'FTP პორტი',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'FTP-სერვერთთან შეერთების პორტი.',
	'FTP_FSOCK_ROOT_PATH'			=> 'phpBB მისამართი',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'საიტზე განთავსებული phpBB საქაღალდის მისამართი.',
	'FTP_FSOCK_TIMEOUT'				=> 'FTP ტაიმაუტი',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'წამებში გაბსაზღვული დრო, რომლის განმავლობაშიც სისტემა დაელოდება პასუხს FTP-სერვერიდან.',
	'FTP_FSOCK_USERNAME'			=> 'FTP მომხმარებლის სახელი',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'FTP-სერვერზე შესასვლელი მომხმარებლის სახელი.',

	'FTP_HOST'					=> 'FTP-სერვერი',
	'FTP_HOST_EXPLAIN'			=> 'საიტზე შესასვლელი FTP-სერვერი.',
	'FTP_PASSWORD'				=> 'პაროლი FTP',
	'FTP_PASSWORD_EXPLAIN'		=> 'FTP-სერვერზე შესასვლელი პაროლი.',
	'FTP_PORT'					=> 'FTP პორტი',
	'FTP_PORT_EXPLAIN'			=> 'FTP-სერვერთთან მისაერთებელი პორტი.',
	'FTP_ROOT_PATH'				=> 'მისამართი phpBB-სკენ',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'phpBB საქაღალდის მისამართი.',
	'FTP_TIMEOUT'				=> 'FTP ტაიმაუტი',
	'FTP_TIMEOUT_EXPLAIN'		=> 'დრო წამებში, რომლის განმავლობაშიც სისტემა დაელოდება პასუხს FTP-სერვერიდან.',
	'FTP_USERNAME'				=> 'FTP მომხმარებლის სახელი',
	'FTP_USERNAME_EXPLAIN'		=> 'FTP-სერვერზე შესასვლელი მომხმარებლის სახელი.',

	'GENERAL_ERROR'				=> 'საერთო შეცდომა',
	'GB'						=> 'გბ',
	'GIB'						=> 'გბ',
	'GO'						=> 'გადასვლა',
	'GOTO_PAGE'					=> 'გადასვლა გვერდზე',
	'GROUP'						=> 'ჯგუფი',
	'GROUPS'					=> 'ჯგუფები',
	'GROUP_ERR_TYPE'			=> 'არ არის არჩეული შესაბამისი ჯგუფის ტიპი.',
	'GROUP_ERR_USERNAME'		=> 'ჯგუფის სახელი არ არის მითითებული.',
	'GROUP_ERR_USER_LONG'		=> 'ჯგუფის სახელი არ უნდა აღემატებოდეს 60 სიმბოლოს.',
	'GUEST'						=> 'სტუმარი',
	'GUEST_USERS_ONLINE'		=> 'ამ დროისთვის ფორუმზე %d: სტუმარია',
	'GUEST_USERS_TOTAL'			=> 'სტუმრები: %d',
	'GUEST_USERS_ZERO_ONLINE'	=> 'ამ დროისთვის ფორუმზე 0: სტუმარია',
	'GUEST_USERS_ZERO_TOTAL'	=> 'სტუმრები: 0',
	'GUEST_USER_ONLINE'			=> 'ამ დროისთვის ფორუმზე %d: სტუმარი',
	'GUEST_USER_TOTAL'			=> 'სტუმრები: %d',
	'G_ADMINISTRATORS'			=> 'ადმინისტრატორები',
	'G_BOTS'					=> 'ბოტები',
	'G_GUESTS'					=> 'სტუმრები',
	'G_REGISTERED'				=> 'დარეგისტრირებული მომხმარებლები',
	'G_REGISTERED_COPPA'		=> 'დარეგისტრირებული მომხმარებლები (COPPA)',
	'G_GLOBAL_MODERATORS'		=> 'სუპერმოდერატორები',
	'G_NEWLY_REGISTERED'		=> 'ახალი მომხმარებლები',

	'HIDDEN_USERS_ONLINE'			=> 'ფარული მომხმარებლები: %d',
	'HIDDEN_USERS_TOTAL'			=> 'ფარული: %d',
	'HIDDEN_USERS_TOTAL_AND'		=> 'ფარული: %d და ',
	'HIDDEN_USERS_ZERO_ONLINE'		=> 'ფარული მომხმარებელი: 0',
	'HIDDEN_USERS_ZERO_TOTAL'		=> 'ფარული: 0',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> 'ფარული: 0 და ',
	'HIDDEN_USER_ONLINE'			=> 'ფარული მომხმარებელი: %d',
	'HIDDEN_USER_TOTAL'				=> 'ფარული: %d',
	'HIDDEN_USER_TOTAL_AND'			=> 'ფარული: %d და ',
	'HIDE_GUESTS'					=> 'ფარული სტუმარი',
	'HIDE_ME'						=> 'ამჯერად ფორუმზე ჩემი შესვლის დამალვა',
	'HOURS'							=> 'საათი',
	'HOME'							=> 'მთავარზე',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'ICQ სტატუსი',
	'IF'						=> 'თუ',
	'IMAGE'						=> 'სურათი',
	'IMAGE_FILETYPE_INVALID'	=> 'MIME-ტიპს %s არ აქვს სურათის ფაილის ტიპი %d მხარდაჭერა.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'სურათის ტიპის არ დამთხვევა.',
	'IN'						=> 'ფორუმზე',
	'INDEX'						=> 'მთავარი გვერდი',
	'INFORMATION'				=> 'ინფორმაცია',
	'INTERESTS'					=> 'ინტერესები',
	'INVALID_DIGEST_CHALLENGE'	=> 'არასწორი ავტორიზაცია.',
	'INVALID_EMAIL_LOG'			=> 'შესაძლოა ჩაწერილია არასწორი ელ-ფოსტა: <strong>%s</strong>',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'თქვენი IP-მისამართი %1$s შეტანილია შავ სიაში და დაბლოკილია. დამატებითი ინფორმაციის მისაღებად გადადით შემდეგ ბმულზე<a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'დარეგისტრირებულია',
	'JUMP_PAGE'				=> 'ჩაწერეთ იმ გვერდის ნომერი, რომელზეც გინდათ გადასვლა',
	'JUMP_TO'				=> 'გადასვლა',
	'JUMP_TO_PAGE'			=> 'გადასვლა გვერდზე…',

	'KB'					=> 'კბ',
	'KIB'					=> 'კბ',

	'LAST_POST'							=> 'ბოლო წერილი',
	'LAST_UPDATED'						=> 'ბოლო განახლდა',
	'LAST_VISIT'						=> 'ბოლო შემოსვლა',
	'LDAP_NO_LDAP_EXTENSION'			=> 'გაფართოება LDAP ხელმიუწვდომელია.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'LDAP სერვერთან ვერ მოხერხდა დაკავშირება.',
	'LDAP_SEARCH_FAILED'				=> 'LDAP-ში დირექტორიის მოძებნისას მოხდა შეცდომა.',
	'LEGEND'							=> 'ლეგენდა',
	'LOCATION'							=> 'მდებარეობა',
	'LOCK_POST'							=> 'პოსტის ბლოკირება',
	'LOCK_POST_EXPLAIN'					=> 'რედაქტირების აკრძალვა',
	'LOCK_TOPIC'						=> 'თემის დახურვა',
	'LOGIN'								=> 'შესვლა',
	'LOGIN_CHECK_PM'					=> 'შესვლა და პირადი წერილების შემოწმება.',
	'LOGIN_CONFIRMATION'				=> 'შესვლის დადასტურება',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'იმისათვის, რომ თქვენს პროფილზე არ მოხდეს პაროლების მორგება, სისტემაში შესვლის მცდელობის მაქსიმალური რაოდენობის შემდეგ უნდა შეიყვანოთ დასტურის კოდი. კოდი მოცემულია ქვემოთ სურათზე. კოდი ჩაწერეთ ზუსტად ისე, როგორც ხედავთ. თუ კოდს ვერ ხედავთ მიმართეთ %sადმინისტრატორს%s.', // აღარ გამოიყენება
	'LOGIN_ERROR_ATTEMPTS'				=> 'თქვენ გადააჭარბეთ შესვლის მცდელობის მაქსიმალურ რაოდენობას. ეხლა მომხმარებლის სახელის და პაროლის ჩაწერის გარდა თქვენ უნდა გაიაროთ სპამ-ბოტების საწინააღმდეგო შემოწმება.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'Apache ვერ შეძლო თქვენი იდენტიფიცირება.',
	'LOGIN_ERROR_PASSWORD'				=> 'პაროლი არასწორია. შეამოწმეთ და კიდევ ერთხელ სცადეთ. თუ შესვლის პრობლემა ისევ რჩება შეატყობინეთ %sადმინისტრატორს%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'ფორუმის განახლებისას ვერ მოხერხდა თქვენი პაროლის კონვერტაცია. თქვენ შეიძლება %მოითხოვოთ ახალი პაროლი%s. თუ ისევ გაქვთ სირთულეები მიმართეთ  %sფორუმის ადმინისტრატორს%s.',
	'LOGIN_ERROR_USERNAME'				=> 'მომხმარებლის არასწორი სახელი. შეამოწმეთ და სცადეთ თავიდან. თუ შესვლის პრობლემა ისევ არსებობს, შეატყობინეთ %sადმინისტრატორს%s.',
	'LOGIN_FORUM'						=> 'ფორუმის სანახავად ან წერილის დასამატებლად აუცილებელია პაროლის ჩაწერა.',
	'LOGIN_INFO'						=> 'ფორუმზე შესასვლელად თქვენ უნდა იყოთ რეგისტრირებული. რეგისტრაცია იკავებს რამდენიმე წუთს, მაგრამ გაძლევთ ფართო უფლებებს. დარეგისტრირებულ მომხმარებელს საიტის ადმინისტრატორის მიერ შეიძლება მიენიჭოს დამატებით უფლებები. რეგისტრაციამდე გაეცანით წესებს და პოლიტიკას, რომელიც მიღებულია კონფერენციაზე. გახსოვდეთ, რომ თქვენი ფორუმზე ყოფნა ნიშნავს თანხმობას <strong> ყველა</strong> წესზე.',
	'LOGIN_VIEWFORUM'					=> 'ფორუმის სანახავად გაიარეთ ავტორიზაცია.',
	'LOGIN_EXPLAIN_EDIT'				=> 'წერილის რედაქტირებისათვის გაიარეთ ავტორიზაცია.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'მომხმარებელების სიის სანახავად რედაქტირებისათვის გაიარეთ ავტორიზაცია.',
	'LOGOUT'							=> 'გამოსვლა',
	'LOGOUT_USER'						=> 'გამოსვლა [ %s ]',
	'LOG_ME_IN'							=> 'ყოველ შესვლაზე ავტომატური ავტორიზაცია',

	'MARK'					=> 'მონიშვნა',
	'MARK_ALL'				=> 'ყველას მონიშვნა',
	'MARK_FORUMS_READ'		=> 'მონიშნე ფორუმი როგორც წაკითხული',
	'MARK_SUBFORUMS_READ'	=> 'ქვეფორუმის როგორც წაკითხულის აღნიშვნა',
	'MB'					=> 'მბ',
	'MIB'					=> 'მბ',
	'MCP'					=> 'მოდერატორის განყოფილება',
	'MEMBERLIST'			=> 'მომხმარებლები',
	'MEMBERLIST_EXPLAIN'	=> 'მომხმარებელთა სრული სიის ნახვა',
	'MERGE'					=> 'გაერთიანება',
	'MERGE_POSTS'			=> 'პოსტის გადატანა',
	'MERGE_TOPIC'			=> 'თემის გაერთიანება',
	'MESSAGE'				=> 'შეტყობინება',
	'MESSAGES'				=> 'შეტყობინებები',
	'MESSAGE_BODY'			=> 'შეტყობინების ტექსტი',
	'MINUTES'				=> 'წუთი',
	'MODERATE'				=> 'მოდერირება',
	'MODERATOR'				=> 'მოდერატორი',
	'MODERATORS'			=> 'მოდერატორები',
	'MONTH'					=> 'თვე',
	'MOVE'					=> 'გადატანა',
	'MSNM'					=> 'MSNM/WLM',

	'NA'						=> 'არა',
	'NEWEST_USER'				=> 'ახალი მომხმარებელი: <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'ახალი შეტყობინება',
	'NEW_MESSAGES'				=> 'ახალი შეტყობინებები',
	'NEW_PM'					=> 'ახალი პირადი წერილები: <strong>%d</strong>',
	'NEW_PMS'					=> 'ახალი პირადი წერილები: <strong>%d</strong>',
	'NEW_POST'					=> 'ახალი შეტყობინება', // Больше не используется
	'NEW_POSTS'					=> 'ახალი შეტყობინებები', // Больше не используется
	'NEXT'						=> 'შემდეგი.',		// Used in pagination
	'NEXT_STEP'					=> 'წინ',
	'NEVER'						=> 'არასდროს',
	'NO'						=> 'არა',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'თქვენ არ შეგიძლიათ ამ ჯგუფის მართვა.',
	'NOT_AUTHORISED'			=> 'ფორმის ამ ნაწილზე წვდომის უფლება თქვენ არ გაქვთ.',
	'NOT_WATCHING_FORUM'		=> 'თქვენ აღარ გაქვთ გამოწერილი ამ ფორუმის განახლებები.',
	'NOT_WATCHING_TOPIC'		=> 'თქვენ აღარ გაქვთ ამ თემაზე გამოწერა.',
	'NOTIFY_ADMIN'				=> 'შეატყობინეთ ფორუმის ადმინისტრატორს ან ვებ-დიზაინერს.',
	'NOTIFY_ADMIN_EMAIL'		=> 'შეატყობინეთ ფორუმის ადმინისტრატორს ან ვებ-დიზაინერს: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'თქვენ აკრძალული გაქვთ ამ ფაილთან წვდომა.',
	'NO_ACTION'					=> 'მოქმედება არ არის განსაზღვრული.',
	'NO_ADMINISTRATORS'			=> 'ადმინისტრატორები არ არიან.',
	'NO_AUTH_ADMIN'				=> 'თქვენ არ გაქვთ ადმინისტრატორის განყოფილებასთან წვდომის უფლება.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'თქვენ არ გაქვთ უფლება განმეორებით გაიაროთ ავტორიზაცია როგორც უცხო მომხმარებელმა .',
	'NO_AUTH_OPERATION'			=> 'ამ ოპერაციის დასრულებისათვის თქვენ არ გაქვთ შესაბამისი წვდომის უფლება.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'SMTP-სერვერთან ვერ მოხერხდა დაკავშირება: %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'დღეს არავის დაბადების დღე არ არის.',
	'NO_E-MAIL_MESSAGE'			=> 'წერილის ტექსტი არ არის.',
	'NO_E-MAIL_RESPONSE_CODE'	=> 'საფოსტო სერვერიდან პასუხი არ არის მოსული.',
	'NO_E-MAIL_SUBJECT'			=> 'წერილის თემა არ არის მითითებული.',
	'NO_FORUM'					=> 'მოთხოვნილი ფორუმი არ არსებობს.',
	'NO_FORUMS'					=> 'ამ საიტზე არ არის ფორუმები.',
	'NO_GROUP'					=> 'მოთხოვნილი ჯგუფი არ არსებობს.',
	'NO_GROUP_MEMBERS'			=> 'ამ დროისთვის ამ ჯგუფში მომხმარებლები არ არიან.',
	'NO_IPS_DEFINED'			=> 'IP-მისამართი ან ჰოსტის სახელი არ არის განსაზღვრული',
	'NO_MEMBERS'				=> 'მითითებული კრიტერიუმებით ვერცერთი მომხმარებელი ვერ მოიძებნა',
	'NO_MESSAGES'				=> 'შეტყობინებები არი არის',
	'NO_MODE'					=> 'რეჟიმი არ არის მითითებული.',
	'NO_MODERATORS'				=> 'მოდერატორები არ არიან.',
	'NO_NEW_MESSAGES'			=> 'ახალი შეტყობინებები არ არის',
	'NO_NEW_PM'					=> 'ახალი პირადი წერილები: <strong>0</strong>',
	'NO_NEW_POSTS'				=> 'ახალი წერილები არ არის', // აღარ გამოიყენება
	'NO_ONLINE_USERS'			=> 'დარეგისტრირებული მომხმარებლები არ არიან',
	'NO_POSTS'					=> 'შეტყობინებები არი არის',
	'NO_POSTS_TIME_FRAME'		=> 'არჩეული დროის მონაკვეთში თემაში წერილები არ არის.',
	'NO_FEED_ENABLED'			=> 'ახალი ამბების არხები ამ ფორუმზე მიუწვდომელია ამ ფორუმზე.',
	'NO_FEED'					=> 'ახალი ამბების მოთხოვნილი არხი მიუწვდომელია.',
	'NO_SUBJECT'				=> 'თემა მითითებული არ არის',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'მითითებული საძიებო მექანიზმი არ არსებობს.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'ავტორიზაციის მეთოდის მხარდაჭერა არ არის.',
	'NO_TOPIC'					=> 'მოთხოვნილი თემა არ არსებობს.',
	'NO_TOPIC_FORUM'			=> 'აღნიშნული თემა ან ფორუმი მეტად აღარ არსებობს.',
	'NO_TOPICS'					=> 'ამ ფორუმში წერილი არ არის.',
	'NO_TOPICS_TIME_FRAME'		=> 'ამ ფორუმში არჩეული დროისათვის თემა არ არის.',
	'NO_UNREAD_PM'				=> 'წაუკითხავი წერილები არ არის',
	'NO_UNREAD_POSTS'			=> 'წაუკითხავი წერილები არ არის',
	'NO_UPLOAD_FORM_FOUND'		=> 'ფაილის ატრვირთვა ინიციირებულია, მაგრამ ასატვირთვი ფაილი არ მოიძებნა.',
	'NO_USER'					=> 'მოთხოვნილი მომხმარებელი არ არსებობს.',
	'NO_USERS'					=> 'მოთხოვნილი მომხმარებელი არ არსებობს.',
	'NO_USER_SPECIFIED'			=> 'მომხმარებლის სახელი არ არის განსაზღვრული.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'	=> array(
		0		=> 'წერილები არ არის რიგში',	// 0
		1		=> 'რიგშია წერილები: %d',	// 1+
	),

	'OCCUPATION'				=> 'საქმიანობის სფერო',
	'OFFLINE'					=> 'გასულია',
	'ONLINE'					=> 'შემოსულია',
	'ONLINE_BUDDIES'			=> 'მეგობრები',
	'ONLINE_USERS_TOTAL'		=> 'სულ შემოსულია: <strong>%d</strong>, მათ შორის ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'სულ შემოსულია: <strong>0</strong>, მათ შორის ',
	'ONLINE_USER_TOTAL'			=> 'სულ შემოსულია: <strong>%d</strong>,მათ შორის ',
	'OPTIONS'					=> 'პარამეტრები',

	'PAGE_OF'				=> 'გვერდი<strong>%1$d-%2$d</strong></strong> დან<strong>',
	'PASSWORD'				=> 'პაროლი',
 	'PIXEL'					=> 'პიქსელი',
	'PLAY_QUICKTIME_FILE'	=> 'QuickTime ფაილის გაშვება ',
	'PM'					=> 'პირადი წერილი',
	'PM_REPORTED'			=> 'საჩივრის სანახავად დააწკაპეთ',
	'POSTING_MESSAGE'		=> 'ფორუმზე განთავსებული წერილები«%s»',
	'POSTING_PRIVATE_MESSAGE'	=> 'პირადი წერილის შექმნა',
	'POST'					=> 'წერილი',
	'POST_ANNOUNCEMENT'		=> 'განცხადება',
	'POST_STICKY'			=> 'მიმაგრებული',
	'POSTED'				=> 'დამატებულია',
	'POSTED_IN_FORUM'		=> 'в',
	'POSTED_ON_DATE'		=> '',
	'POSTS'					=> 'წერილები',
	'POSTS_UNAPPROVED'		=> 'ამ თემაში შემოწმებული წერილი არ არის.',
	'POST_BY_AUTHOR'		=> '',
	'POST_BY_FOE'			=> 'ამ წერილების ავტორი <strong>%1$s</strong>შავ სიაშია. %2$sმაჩვენე წერილი%3$s.',
	'POST_DAY'				=> '%.2f პოსტი დღეში',
	'POST_DETAILS'			=> 'ინფორმაცია წერილზე',
	'POST_NEW_TOPIC'		=> 'ახალი თემის დაწყება',
	'POST_PCT'				=> '%.2f%% ყველა წერილი',
	'POST_PCT_ACTIVE'		=> '%.2f%% მომხმარებლის წერილები',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% თქვენი წერილები',
	'POST_REPLY'			=> 'პასუხი',
	'POST_REPORTED'			=> 'საჩივრის ნახვა',
	'POST_SUBJECT'			=> 'შეტყობინების სათაური',
	'POST_TIME'				=> 'განთასების დრო',
	'POST_TOPIC'			=> 'ახალი თემა',
	'POST_UNAPPROVED'		=> 'ეს წერილი ელოდება შემოწმებას',
	'PREVIEW'				=> 'წინასწარ ნახვა',
	'PREVIOUS'				=> 'უკან',		// Used in pagination
	'PREVIOUS_STEP'			=> 'უკან',
	'PRIVACY'				=> 'კონფიდენციალურობის შეთანხმება',
	'PRIVATE_MESSAGE'		=> 'პირადი შეტყობინება',
	'PRIVATE_MESSAGES'		=> 'პირადი შეტყობინებები',
	'PRIVATE_MESSAGING'		=> 'პირადი შეტყობინებები',
	'PROFILE'				=> 'პირადი განყოფილება',

	'READING_FORUM'				=> 'ფორუმის ნახვაа «%s»',
	'READING_GLOBAL_ANNOUNCE'	=> 'საჭირო განცხადების კითხვა',
	'READING_LINK'				=> 'ფორუმის ბმულზე «%s» გადასვლა',
	'READING_TOPIC'				=> 'თემის ნახვა ფორუმზე «%s»',
	'READ_PROFILE'				=> 'პროფილი',
	'REASON'					=> 'მიზეზი',
	'RECORD_ONLINE_USERS'		=> 'ყველაზე მეტი მომხმარებელი (<strong>%1$s</strong>)იყო %2$s',
	'REDIRECT'					=> 'გადამისამართება',
	'REDIRECTS'					=> 'ბმულზე გადასვლა',
	'REGISTER'					=> 'რეგისტრაცია',
	'REGISTERED_USERS'			=> 'დარეგისტრირებული მომხმარებლები:',
	'REG_USERS_ONLINE'			=> 'დარეგისტრირებული მომხმარებლები: %d და ',
	'REG_USERS_TOTAL'			=> 'დარეგისტრირებული: %d, ',
	'REG_USERS_TOTAL_AND'		=> 'დარეგისტრირებული: %d და ',
	'REG_USERS_ZERO_ONLINE'		=> 'დარეგისტრირებული მომხმარებლები: 0 და ',
	'REG_USERS_ZERO_TOTAL'		=> 'დარეგისტრირებული: 0, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> 'დარეგისტრირებული: 0 და ',
	'REG_USER_ONLINE'			=> 'დარეგისტრირებული მომხმარებლები: %d და ',
	'REG_USER_TOTAL'			=> 'დარეგისტრირებული: %d, ',
	'REG_USER_TOTAL_AND'		=> 'დარეგისტრირებული: %d და ',
	'REMOVE'					=> 'წაშლა',
	'REMOVE_INSTALL'			=> 'ფორუმის გამოყენებამდე წაშალეთ, გადაიტანეთ ან სახელი გადაარქვით საქაღალდე install-ს. წინააღმდეგ შემთხვევაში შეძლებთ მხოლოდ ადმინისტრატორის განყოფილებაზე წვდომას.',
	'REPLIES'					=> 'პასუხები',
	'REPLY_WITH_QUOTE'			=> 'პასუხის გაცემა ციტირებით',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'საჭირო განცხადებაზე პასუხის განთავსება',
	'REPLYING_MESSAGE'			=> 'ფორუმზე«%s» პასუხის განთავსება',
	'REPORT_BY'					=> 'წყარო',
	'REPORT_POST'				=> 'ამ წერილის გასაჩივრება',
	'REPORTING_POST'			=> 'წერილზე საშივრის განთავსება',
	'RESEND_ACTIVATION'			=> 'პროფილი აქტივაციისთვის წერილის განმეორებით გაგზავნა',
	'RESET'						=> 'გაუქმება',
	'RESTORE_PERMISSIONS'		=> 'წვდომის უფლების აღდგენა',
	'RETURN_INDEX'				=> '%sმთავარ გვერდზე დაბრუნება%s',
	'RETURN_FORUM'				=> '%sფორუმზე დაბრუნება%s',
	'RETURN_PAGE'				=> '%sწინა გვერდზე დაბრუნება%s',
	'RETURN_TOPIC'				=> '%sთემაში დაბრუნება%s',
	'RETURN_TO'					=> 'დაბრუნება',
	'FEED'						=> 'არხი',
	'FEED_NEWS'					=> 'ახალი ამბები',
 	'FEED_TOPICS_ACTIVE'		=> 'აქტიური თემები',
 	'FEED_TOPICS_NEW'			=> 'ახალი თემები',
	'RULES_ATTACH_CAN'			=> 'თქვენ <strong>შეგიძლიათ</strong> ფაილის მიმაგრება',
	'RULES_ATTACH_CANNOT'		=> 'თქვენ <strong>არ შეგიძლიათ</strong> ფაილის მიმაგრება',
	'RULES_DELETE_CAN'			=> 'თქვენ <strong>შეგიძლიათ</strong> საკუთარი წერილების წაშლა',
	'RULES_DELETE_CANNOT'		=> 'თქვენ <strong>არ შეგიძლიათ</strong> საკუთარი წერილების წაშლა',
	'RULES_DOWNLOAD_CAN'		=> 'თქვენ <strong>შეგიძლიათ</strong> მიმაგრებული ფაილის გადმოწერა',
	'RULES_DOWNLOAD_CANNOT'		=> 'თქვენ <strong>არ შეგიძლიათ</strong> მიმაგრებული ფაილის გადმოწერა',
	'RULES_EDIT_CAN'			=> 'თქვენ <strong>შეგიძლიათ</strong> საკუთარი წერილის რედაქტირება',
	'RULES_EDIT_CANNOT'			=> 'თქვენ <strong>არ შეგიძლიათ</strong> საკუთარი წერილის რედაქტირება',
	'RULES_LOCK_CAN'			=> 'თქვენ <strong>შეგიძლიათ</strong> საკუთარი თემის დახურვა',
	'RULES_LOCK_CANNOT'			=> 'თქვენ <strong>არ შეგიძლიათ</strong> საკუთარი თემის დახურვა',
	'RULES_POST_CAN'			=> 'თქვენ <strong>შეგიძლიათ</strong> თემის შექმნა',
	'RULES_POST_CANNOT'			=> 'თქვენ <strong>არ შეგიძლიათ</strong> თემის შექმნა',
	'RULES_REPLY_CAN'			=> 'თქვენ <strong>შეგიძლიათ</strong> წერილებზე პასუხის გაცემა',
	'RULES_REPLY_CANNOT'		=> 'თქვენ <strong>არ შეგიძლიათ</strong> წერილებზე პასუხის გაცემა',
	'RULES_VOTE_CAN'			=> 'თქვენ <strong>შეგიძლიათ</strong> გამოკითხვებზე ხმის მიცემა',
	'RULES_VOTE_CANNOT'			=> 'თქვენ <strong>არ შეგიძლიათ</strong> გამოკითხვებზე ხმის მიცემა',

	'SEARCH'					=> 'ძებნა',
	'SEARCH_MINI'				=> 'ძებნა…',
	'SEARCH_ADV'				=> 'გაფართოებული ძებნა',
	'SEARCH_ADV_EXPLAIN'		=> 'გაფართოებული ძებნის პარამეტრები',
	'SEARCH_KEYWORDS'			=> 'საძიებო სიტყვები',
	'SEARCHING_FORUMS'			=> 'ფორუმებში ძებნა',
	'SEARCH_ACTIVE_TOPICS'		=> 'აქტიური თემები',
	'SEARCH_FOR'				=> 'ძებნა',
	'SEARCH_FORUM'				=> 'ფორუმზე ძებნა…',
	'SEARCH_NEW'				=> 'ახალი შეტყობინებები',
	'SEARCH_POSTS_BY'			=> 'შეტყობინებები ძებნა',
	'SEARCH_SELF'				=> 'თქვენი შეტყობინებები',
	'SEARCH_TOPIC'				=> 'ძებნა თემაში…',
	'SEARCH_UNANSWERED'			=> 'უპასუხო წერილები',
	'SEARCH_UNREAD'				=> 'წაუკითხავი წერილები',
	'SEARCH_USER_POSTS'			=> 'მომხმარებლის წერილების ნახვა',
	'SECONDS'					=> 'წამი',
	'SELECT'					=> 'არჩევა',
	'SELECT_ALL_CODE'			=> 'ყველას მონიშვნა',
	'SELECT_DESTINATION_FORUM'	=> 'აირჩიეთ ფორუმი',
	'SELECT_FORUM'				=> 'აირჩიეთ ფორუმი',
	'SEND_EMAIL'				=> 'ელ-ფოსტის გაგზავნა',				// Used for submit buttons
	'SEND_EMAIL_USER'			=> 'მომხმარებლისთვის წერილის გაგზავნა',	// Used as: {L_SEND_EMASER} {USERNAME} -> EMAIL UserX
	'SEND_PRIVATE_MESSAGE'		=> 'პირადი წერილის გაგზავნა',
	'SETTINGS'					=> 'პარამეტრები',
	'SIGNATURE'					=> 'ხელმი',
	'SKIP'						=> 'გამოტოვება',
	'SMTP_NO_AUTH_SUPPORT'		=> 'SMTP-სერვერს არ აქვს ავტორიზაციის მხარდაჭერა.',
	'SORRY_AUTH_READ'			=> 'ფორუმის წასაკითხად უნდა გაიაროთ ავტორიზაცია .',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'მიმაგრებული ფაილის გადმოსაწერად გაიარეთ ავტორიზაცია.',
	'SORT_BY'					=> 'სორტირების ველი',
	'SORT_JOINED'				=> 'რეგისტრაციის თარიღი',
	'SORT_LOCATION'				=> 'მდებარეობა',
	'SORT_RANK'					=> 'წოდება',
	'SORT_POSTS'				=> 'წერილები',
	'SORT_TOPIC_TITLE'			=> 'თემის დასახელება',
	'SORT_USERNAME'				=> 'მომხმარებლის სახელი',
	'SPLIT_TOPIC'				=> 'თემის გაყოფა',
	'SQL_ERROR_OCCURRED'		=> 'მოხდა SQL-ის შეცდომა. განმეორების შემთხვევაში გთხოვთ აცნობოთ %sადმინისტრატორს%s. ',
	'STATISTICS'				=> 'სტატისტიკა',
	'START_WATCHING_FORUM'		=> 'ფორუმის გამოწერა',
	'START_WATCHING_TOPIC'		=> 'თემის გამოწერა',
	'STOP_WATCHING_FORUM'		=> 'ფორუმის გამოწერის გაუქმება',
	'STOP_WATCHING_TOPIC'		=> 'თემის გამოწერის გაუქმება',
	'SUBFORUM'					=> 'ქვეფორუმი',
	'SUBFORUMS'					=> 'ქვეფორუმები',
	'SUBJECT'					=> 'სათაური',
	'SUBMIT'					=> 'გაგზავნა',

	'TERMS_USE'			=> 'საერთო წესები',
	'TEST_CONNECTION'	=> 'მიერთების შემოწმება',
	'THE_TEAM'			=> 'ჩვენი ჯუფი',
	'TIME'				=> 'დრო',

	'TOO_LARGE'					=> 'ჩაწერილი სიმბოლო საკმაოდ გრძელია.',
	'TOO_LARGE_MAX_RECIPIENTS'	=> '<strong>პირადი წერილის მიმღებთა რაოდენობა</strong> საკმაოდ დიდია.',

	'TOO_LONG'			=> 'სიმბოლოების რაოდენობა საკმაოდ გრძელია.',

	'TOO_LONG_AIM'					=> 'AIM-ის სახელი საკმაოდ გრძელია.',
	'TOO_LONG_CONFIRM_CODE'			=> 'ჩაწერილი დასტურის კოდი საკმაოდ გრძელია.',
	'TOO_LONG_DATEFORMAT'			=> 'ჩაწერილი თარიღის ფორმატი საკმაოდ გრძელია.',
	'TOO_LONG_ICQ'					=> 'Номер ICQ საკმაოდ გრძელია.',
	'TOO_LONG_INTERESTS'			=> 'ინტერესების ტექსტი საკმაოდ გრძელია.',
	'TOO_LONG_JABBER'				=> 'Jabber-ის ანგარიშის სახელი საკმაოდ გრძელია.',
	'TOO_LONG_LOCATION'				=> 'სტრიქონი «მდებარეობა» ძალიან გრძელია.',
	'TOO_LONG_MSN'					=> 'MSN/WLM-ის სახელი საკმაოდ გრძელია.',
	'TOO_LONG_NEW_PASSWORD'			=> 'ჩაწერილი პაროლი საკმაოდ გრძელია.',
	'TOO_LONG_OCCUPATION'			=> 'სტრიქონი «საქმიანობის სფერო» ძალიან გრძელია.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'პაროლის დასტური საკმაოდ გრძელია.',
	'TOO_LONG_USER_PASSWORD'		=> 'პაროლი საკმაოდ გრძელია.',
	'TOO_LONG_USERNAME'				=> 'მომხმარებლის სახელი საკმაოდ გრძელია.',
	'TOO_LONG_EMAIL'				=> 'მისამართი ელ-ფოსტა საკმაოდ გრძელია.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'ელ-ფოსტის მისამართის დასტური საკმაოდ გრძელია.',
	'TOO_LONG_WEBSITE'				=> 'საიტის მისამართი საკმაოდ გრძელია.',
	'TOO_LONG_YIM'					=> 'YIM-ის სახელი საკმაოდ გრძელია.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'თქვენ აირჩიეთ გამოკითხვის პასუხების ძალიან ბევრი ვარიანტი.',

	'TOO_SHORT'						=> 'ჩაწერილი მნიშვნელობა ძალიან მოკლეა.',

	'TOO_SHORT_AIM'					=> 'AIM ძალიან მოკლეა.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'ჩაწერილი დასტურის კოდი ძალიან მოკლეა.',
	'TOO_SHORT_DATEFORMAT'			=> 'ჩაწერილი თარიღის ფორმატი ძალიან მოკლეა.',
	'TOO_SHORT_ICQ'					=> 'ICQ ნომერი ძალიან მოკლეა.',
	'TOO_SHORT_INTERESTS'			=> 'ინტერესების სტრიქონი ძალიან მოკლეა.',
	'TOO_SHORT_JABBER'				=> 'Jabber-ის ანგარიშის სახელი ძალიან მოკლეა.',
	'TOO_SHORT_LOCATION'			=> 'სტრიქონი «მდებარეობა» ძალიან მოკლეა.',
	'TOO_SHORT_MSN'					=> 'MSNM/WLM სახელი ძალიან მოკლეა.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'ჩაწერილი პაროლი ძალიან მოკლეა.',
	'TOO_SHORT_OCCUPATION'			=> 'სტრიქონი «საქმიანობის სფერო» ძალიან მოკლეა.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'პაროლის დასტური ძალიან მოკლეა.',
	'TOO_SHORT_USER_PASSWORD'		=> 'პაროლი ძალიან მოკლეა.',
	'TOO_SHORT_USERNAME'			=> 'მომხმარებლის სახელი ძალიან მოკლეა.',
	'TOO_SHORT_E-MAIL'				=> 'მისამართი ელ-ფოსტა ძალიან მოკლეა.',
	'TOO_SHORT_E-MAIL_CONFIRM'		=> 'ელ-ფოსტის მისამართის დასტური ძალიან მოკლეა.',
	'TOO_SHORT_WEBSITE'				=> 'საიტის მისამართი ძალიან მოკლეა.',
	'TOO_SHORT_YIM'					=> 'YIM სახელი ძალიან მოკლეა.',

	'TOO_SMALL'						=> 'ჩაწერილი სიმბოლო საკმაოდ მოკლეა.',
	'TOO_SMALL_MAX_RECIPIENTS'		=> '<strong>პირადი წერილის მიმღებთა რაოდენობა</strong> საკმაოდ მოკლეა.',

	'TOPIC'				=> 'თემა',
	'TOPICS'			=> 'თემები',
	'TOPICS_UNAPPROVED'	=> 'ამ ფორუმზე სულ ცოტა 1 თემა არ არის დადასტურებული.',
	'TOPIC_ICON'		=> 'ნიშანი',
	'TOPIC_LOCKED'		=> 'ეს თემა დახურულია, თქვენ არ შეგიძლიათ მისი რედაქტირება და წერილის დაამტება.',
	'TOPIC_LOCKED_SHORT'=> 'დახურულია',
	'TOPIC_MOVED'		=> 'გადატანილია',
	'TOPIC_REVIEW'		=> 'თემის დათვალიერება',
	'TOPIC_TITLE'		=> 'თემის სახელი',
	'TOPIC_UNAPPROVED'	=> 'თემა არ არის ნებადართული',
	'TOTAL_ATTACHMENTS'	=> 'მიმაგრებული ფაილები',
	'TOTAL_LOG'			=> '1 ლოგი',
	'TOTAL_LOGS'		=> 'ლოგი: %d',
	'TOTAL_NO_PM'		=> 'სულ 0 პირადი წერილი',
	'TOTAL_PM'			=> 'სულ 1 პირადი წერილი',
	'TOTAL_PMS'			=> 'სულ %d პირადი წერილი',
	'TOTAL_POSTS'		=> 'სულ წერილები',
	'TOTAL_POSTS_OTHER'	=> 'სულ წერილები: <strong>%d</strong>',
	'TOTAL_POSTS_ZERO'	=> 'სულ წერილები: <strong>0</strong>',
	'TOPIC_REPORTED'	=> 'ამ თემასთან დაკავშირებით შემოვიდა საჩივარი',
	'TOTAL_TOPICS_OTHER'=> 'თემები: <strong>%d</strong>',
	'TOTAL_TOPICS_ZERO'	=> 'თემები: <strong>0</strong>',
	'TOTAL_USERS_OTHER'	=> 'მომხმარებლები: <strong>%d</strong>',
	'TOTAL_USERS_ZERO'	=> 'მომხმარებლები: <strong>0</strong>',
	'TRACKED_PHP_ERROR'	=> 'PHP შეცდომის თვალყურის დევნა: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'სურათის ზომის განსაზღვრა ვერ მოხერხდა.',
	'UNABLE_TO_DELIVER_FILE'=> 'ფაილის გადაგზავნა ვერ მოხერხდა.',
	'UNKNOWN_BROWSER'		=> 'უცნობი ბრაუზერი',
	'UNMARK_ALL'			=> 'მონიშვნის მოხსნა',
	'UNREAD_MESSAGES'		=> 'წაუკითხავი წერილები',
	'UNREAD_PM'				=> 'წაუკითხავი წერილები: <strong>%d</strong>',
	'UNREAD_PMS'			=> 'წაუკითხავი წერილები: <strong>%d</strong>',
	'UNREAD_POST'			=> 'წაუკითხავი წერილი',
	'UNREAD_POSTS'			=> 'წაუკითხავი წერილები',
	'UNWATCH_FORUM_CONFIRM'		=> 'თქვენ ნამდვილად გსურთ ამ ფორუმის გამოწერის გაუქმება?',
	'UNWATCH_FORUM_DETAILED'	=> 'თქვენ ნამდვილად გსურთ «%s» ფორუმის გამოწერის გაუქმება?',
	'UNWATCH_TOPIC_CONFIRM'		=> 'თქვენ ნამდვილად გსურთ ამ თემის გამოწერის გაუქმება?',
	'UNWATCH_TOPIC_DETAILED'	=> 'თქვენ ნამდვილად გსურთ «%s» ფორუმის გამოწერის გაუქმება?',
	'UNWATCHED_FORUMS'			=> 'თქვენ აღარ გაქვთ გამოწერილი არჩეული ფორუმები.',
	'UNWATCHED_TOPICS'			=> 'თქვენ აღარ გაქვთ გამოწერილი არჩეული თემები.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'თქვენ აღარ გაქვთ გამოწერილი არჩეულები.',
	'UPDATE'				=> 'განახლდა',
	'UPLOAD_IN_PROGRESS'	=> 'მიმდინარეობს ატვირთვა.',
	'URL_REDIRECT'			=> 'თუ თქვენს ბრაუზერს არ აქვს ავტომატური გადამისამართების მხარდაჭერა, %sდააწკაპეთ ამ ბმულს%s.',
	'USERGROUPS'			=> 'ჯგუფები',
	'USERNAME'				=> 'მომხმარებლის სახელი',
	'USERNAMES'				=> 'მომხმარებლის სახელები',
	'USER_AVATAR'			=> 'მომხმარებლის ავატარი',
	'USER_CANNOT_READ'		=> 'თქევნა არ შეგიძლიათ ამ ფორუმზე შეტყობინებების წაკითხვა.',
	'USER_POST'				=> '%d წერილი',
	'USER_POSTS'			=> '%d წერილები',
	'USERS'					=> 'მომხმარებლები',
	'USE_PERMISSIONS'		=> 'მომხმარებლის უფლებების შემოწმება',

	'USER_NEW_PERMISSION_DISALLOWED'	=> 'თქვენ არ გაქვთ ამ ფუნქციის გამოყენების უფლება. შესაძლოა, თქვენ ეხლახან დარეგისტრირდით ფორუმზე ან თქვენ უნდა იყოთ უფრო მეტად აქტიური რომ მიიღოთ ამის უფლება.',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'ნანახია:',
	'VIEWING_FAQ'				=> 'FAQ-ის ნახვა',
	'VIEWING_MEMBERS'			=> 'მომხმარებელთა სიის ნახვა',
	'VIEWING_ONLINE'			=> 'გვერდის "ვინ არიან ფორუმზე" ნახვა',
	'VIEWING_MCP'				=> 'მოდერატორის განყოფილების ნახვა',
	'VIEWING_MEMBER_PROFILE'	=> 'მომხმარებლის პროფილის ნახვა',
	'VIEWING_PRIVATE_MESSAGES'	=> 'პირადი წერილების ნახვა',
	'VIEWING_REGISTER'			=> 'პროფილის რეგისტრაცია',
	'VIEWING_UCP'				=> 'პირადი განყოფილების ნახვა',
	'VIEWS'						=> 'ნახვები',
	'VIEW_BOOKMARKS'			=> 'რჩეულების ნახვა',
	'VIEW_FORUM_LOGS'			=> 'ლოგების ნახვა',
	'VIEW_LATEST_POST'			=> 'მომდევნო წერილის ნახვა',
	'VIEW_NEWEST_POST'			=> 'პირველ წაუკითხავ წერილზე გადასვლა',
	'VIEW_NOTES'				=> 'მომხმარებლის ჩანაწერები',
	'VIEW_ONLINE_TIME'			=> 'დაფუძნებულია მომხმარებლების ბოლო წუთის აქტივობაზე',
	'VIEW_ONLINE_TIMES'			=> 'მონაცემები ეფუძნება მომხმარებლების აქტივობას ბოლო %d წუთის განმავლობაში',
	'VIEW_TOPIC'				=> 'თემის ნახვა',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'განცხადება: ',
	'VIEW_TOPIC_GLOBAL'			=> 'საჭირო: ',
	'VIEW_TOPIC_LOCKED'			=> 'დახურულია: ',
	'VIEW_TOPIC_LOGS'			=> 'ლოგების ნახვა',
	'VIEW_TOPIC_MOVED'			=> 'გადატანილია: ',
	'VIEW_TOPIC_POLL'			=> 'გამოკითხვა: ',
	'VIEW_TOPIC_STICKY'			=> 'მიმაგრებული: ',
	'VISIT_WEBSITE'				=> 'საიტზე გადასვლა',

	'WARNINGS'			=> 'გაფრთხილებები',
	'WARN_USER'			=> 'გაფრთხილების მიცემა',
	'WATCH_FORUM_CONFIRM'	=> 'თქვენ ნამდვილად გსურთ გამოიწეროთ ეს ფორუმი?',
	'WATCH_FORUM_DETAILED'	=> 'თქვენ ნამდვილად გსურთ გამოიწეროთ «%s» ფორუმი?',
	'WATCH_TOPIC_CONFIRM'	=> 'თქვენ ნამდვილად გსურთ გამოიწეროთ ეს თემა?',
	'WATCH_TOPIC_DETAILED'	=> 'თქვენ ნამდვილად გსურთ გამოიწეროთ «%s» თემა?',
	'WELCOME_SUBJECT'	=> 'კეთილი იყოს თქვენი მობრძანება ფორუმზე «%s»',
	'WEBSITE'			=> 'საიტი',
	'WHOIS'				=> 'ინფორმაცია IP-მისამართზე',
	'WHO_IS_ONLINE'		=> 'ვინ არის ეხლა ფორუმზე',
	'WRONG_PASSWORD'	=> 'თქვენ ჩაწერეთ არასწორი პაროლი.',

	'WRONG_DATA_ICQ'			=> 'ICQ-ს ნომერი არასწორია.',
	'WRONG_DATA_JABBER'			=> 'Jabber-ს სახელი არასწორია.',
	'WRONG_DATA_LANG'			=> 'მითითებულია არასწორი ენა.',
	'WRONG_DATA_WEBSITE'		=> 'საიტის მისამართი უნდა იყოს სწორი ბმული, რომელიც შეიცავს პროტოკოლის სახელს. მაგალითად, http://www.example.com/.',
	'WROTE'						=> 'წერდა',

	'YEAR'				=> 'წელი',
	'YEAR_MONTH_DAY'	=> '(წწწწ-თთთ-დდ)',
	'YES'				=> 'კი',
	'YIM'				=> 'YIM',
	'YOU_LAST_VISIT'	=> 'წინა შემოსვლა: %s',
	'YOU_NEW_PM'		=> 'თქვენთ მიიღეთ ახალი პირადი წერილი.',
	'YOU_NEW_PMS'		=> 'თქვენთ მიიღეთ ახალი პირადი წერილები.',
	'YOU_NO_NEW_PM'		=> 'თქვენ არ გაქვთ ახალი პირადი წერილები.',

	'datetime'			=> array(
		'TODAY'		=> 'დღეს',
		'TOMORROW'	=> 'ხვალ',
		'YESTERDAY'	=> 'გუშინ',

		'AGO'		=> array(
			0		=> 'წუთზე ნაკლებ დროს',
			1		=> '%d წუთის უკან',
			2		=> '%d წუთის უკან',
			5		=> '%d წუთის უკან',
			21		=> '%d წუთის უკან',
			22		=> '%d წუთის უკან',
			25		=> '%d წუთის უკან',
			31		=> '%d წუთის უკან',
			32		=> '%d წუთის უკან',
			35		=> '%d წუთის უკან',
			41		=> '%d წუთის უკან',
			42		=> '%d წუთის უკან',
			45		=> '%d წუთის უკან',
			51		=> '%d წუთის უკან',
			52		=> '%d წუთის უკან',
			55		=> '%d წუთის უკან',
			60		=> '1 საათის უკან',
		),

		'Sunday'	=> 'კვირა',
		'Monday'	=> 'ორშაბათი',
		'Tuesday'	=> 'სამშაბათი',
		'Wednesday'	=> 'ოთხშაბათი',
		'Thursday'	=> 'ხუთშაბათი',
		'Friday'	=> 'პარასკები',
		'Saturday'	=> 'შაბათი',

		'Sun'		=> 'კვ',
		'Mon'		=> 'ორშ',
		'Tue'		=> 'სამშ',
		'Wed'		=> 'ოთხშ',
		'Thu'		=> 'ხუთშ',
		'Fri'		=> 'პარ',
		'Sat'		=> 'შაბ',

		'January'	=> 'იანვარი',
		'February'	=> 'თებერველი',
		'March'		=> 'მარტი',
		'April'		=> 'არილი',
		'May'		=> 'მაისი',
		'June'		=> 'ივნისი',
		'July'		=> 'ივლისი',
		'August'	=> 'აგვისტო',
		'September'	=> 'სექტემბერი',
		'October'	=> 'ოქტომბერი',
		'November'	=> 'ნოემბერი',
		'December'	=> 'დეკემბერი',

		'Jan'		=> 'იან',
		'Feb'		=> 'თებ',
		'Mar'		=> 'მარ',
		'Apr'		=> 'აპრ',
		'May_short'	=> 'მაი',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'ივნ',
		'Jul'		=> 'ივლ',
		'Aug'		=> 'აგვ',
		'Sep'		=> 'სექ',
		'Oct'		=> 'ოქტ',
		'Nov'		=> 'ნოემ',
		'Dec'		=> 'დეკ',
	),

	'tz'				=> array(
		'-12'	=> 'UTC − 12 საათი',
		'-11'	=> 'UTC − 11 საათი',
		'-10'	=> 'UTC − 10 საათი',
		'-9.5'	=> 'UTC − 9:30 საათი',
		'-9'	=> 'UTC − 9 საათი',
		'-8'	=> 'UTC − 8 საათი',
		'-7'	=> 'UTC − 7 საათი',
		'-6'	=> 'UTC − 6 საათი',
		'-5'	=> 'UTC − 5 საათი',
		'-4.5'	=> 'UTC − 4:30 საათი',
		'-4'	=> 'UTC − 4 საათი',
		'-3.5'	=> 'UTC − 3:30 საათი',
		'-3'	=> 'UTC − 3 საათი',
		'-2'	=> 'UTC − 2 საათი',
		'-1'	=> 'UTC − 1 час',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 час',
		'2'		=> 'UTC + 2 საათი',
		'3'		=> 'UTC + 3 საათი',
		'3.5'	=> 'UTC + 3:30 საათი',
		'4'		=> 'UTC + 4 საათი',
		'4.5'	=> 'UTC + 4:30 საათი',
		'5'		=> 'UTC + 5 საათი',
		'5.5'	=> 'UTC + 5:30 საათი',
		'5.75'	=> 'UTC + 5:45 საათი',
		'6'		=> 'UTC + 6 საათი',
		'6.5'	=> 'UTC + 6:30 საათი',
		'7'		=> 'UTC + 7 საათი',
		'8'		=> 'UTC + 8 საათი',
		'8.75'	=> 'UTC + 8:45 საათი',
		'9'		=> 'UTC + 9 საათი',
		'9.5'	=> 'UTC + 9:30 საათი',
		'10'	=> 'UTC + 10 საათი',
		'10.5'	=> 'UTC + 10:30 საათი',
		'11'	=> 'UTC + 11 საათი',
		'11.5'	=> 'UTC + 11:30 საათი',
		'12'	=> 'UTC + 12 საათი',
		'12.75'	=> 'UTC + 12:45 საათი',
		'13'	=> 'UTC + 13 საათი',
		'14'	=> 'UTC + 14 საათი',
		'dst'	=> '[ ზაფხულის დრო ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC − 12] დროის ცვლის მერიდიანი (დასავლეთი)',
		'-11'	=> '[UTC − 11] კუნძული მიდვეი, სამოა',
		'-10'	=> '[UTC − 10] ჰავაი',
		'-9.5'	=> '[UTC − 9:30] მარკიზის კუნძულები',
		'-9'	=> '[UTC − 9] ალიასკა',
		'-8'	=> '[UTC − 8] წყნარი ოკეანის დრო (აშშ და კანადა) და ტიხუანა',
		'-7'	=> '[UTC − 7] არიზონა',
		'-6'	=> '[UTC − 6] მექსიკა, ცენტრალური ამერიკა, ცენტრალური დრო (აშშ და კანადა)',
		'-5'	=> '[UTC − 5] ინდიანა (აღმოსავლეთი), აღმოსავლეთის დრო (აშშ და კანადა)',
		'-4.5'	=> '[UTC − 4:30] ვენესუელა',
		'-4'	=> '[UTC − 4] სანტიაგო, ატლანტიკური დრო (კანადა)',
		'-3.5'	=> '[UTC − 3:30] ნიუფაუნდლენდი',
		'-3'	=> '[UTC − 3] ბრაზილია, გრენლანდია',
		'-2'	=> '[UTC − 2] შუა ატლანტიკური დრო',
		'-1'	=> '[UTC − 1] აზორის კუნძულები, მწვანე კონცხის კუნძულები',
		'0'		=> '[UTC] დრო გრინვიჩის დროით: დუბლინი, ლონდონი, ლისაბონი, ედინბურგი',
		'1'		=> '[UTC + 1] ბერლინი, მადრიდი, პარიზი, რომი, დასავლეთ ცენტრალური აფრიკა',
		'2'		=> '[UTC + 2] ათენი, ვილნიუსი, კიევი, მინსკი, როგა, ტალინი, ცენტრალური აფრიკა',
		'3'		=> '[UTC + 3] ბაღდადი, კალინინგრადი, ქუვეითი, ერ-რიადი, ნაირობი',
		'3.5'	=> '[UTC + 3:30] თეირანი',
		'4'		=> '[UTC + 4] ვოლგოგრადი, მოსკოვი, სამარა, სანქტ-პეტერბურგი, ბაქო, ერევანი, თბილისი',
		'4.5'	=> '[UTC + 4:30] ქაბული',
		'5'		=> '[UTC + 5] ისლამაბადი, ყარაჩი,  ტაშკენტი',
		'5.5'	=> '[UTC + 5:30] ბომბეი, კალკუტა, მადრასი, ნიუ-დელი',
		'5.75'	=> '[UTC + 5:45] კატმანდუ',
		'6'		=> '[UTC + 6] ალმა-ატა, ასტანა, ეკატერინებურგი, ორენბურგი',
		'6.5'	=> '[UTC + 6:30] იანგონი',
		'7'		=> '[UTC + 7] ბანკიკი, ჯაკარტა, ნოვოსიბირსკი, ომსკი, ჰანოი',
		'8'		=> '[UTC + 8] ჰონკონგი, კრასნოიარსკი, პეკინი, სინგაპური',
		'9'		=> '[UTC + 9] ირკუტსკი, სეული, ტოკიო',
		'9.5'	=> '[UTC + 9:30] ადელაიდა, დარვინი',
		'10'	=> '[UTC + 10] ბლაგოვეშენსკი, იაკუტსკი',
		'10.5'	=> '[UTC + 10:30] ლორდ-ჰაუ',
		'11'	=> '[UTC + 11] ვლადივოსტოკი, ჩიტა, სახალინი, ხაბაროვსკი',
		'12'	=> '[UTC + 12] მაგადანი, კამჩატკა, ფიჯი',
		'13'	=> '[UTC + 13] ნუკუალოფა',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '10 იან 2005, 17:57',
		'd M Y H:i'				=> '10 იან 2005 17:57',
		'M jS, \'y, H:i'		=> 'იან 1, \'07, 13:37',
		'D M d, Y g:i a'		=> 'ორშ იან 10, 2005 5:57 pm',
		'F jS, Y, g:i a'		=> 'იანვარი 1, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'დღეს, 13:37 / 01 იან 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'დღეს, 1:37 pm / იანვარი 1, 2007, 1:37 pm'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=>'|d M Y|, H:i', // Сегодня, 13:37 / 01 Янв 2007, 13:37

));

?>