<?php
/**
*
* help_bbcode [Russian]
*
* @package language
* @version $Id: help_bbcode.php 9623 2009-06-18 18:12:28Z nickvergessen $
* @copyright (c) 2005 phpBB Group
* @license http://opensource.org/licenses/gpl-license.php GNU Public License
*
*/

/**
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine

$help = array(
	array(
		0 => '--',
		1 => 'შესავალი'
	),
	array(
		0 => 'Что такое BBCode?',
		1 => 'BBCode — это специальный ვარიანტი HTML. Сможете ли თქვენ использовать BBCode в ваших წერილებიх ან нет, определяется ადმინისტრატორისგან ფორუმიов. Кроме того, თქვენ сможете отключить использование BBCode в конкретном сообщении при его размещении. Сам BBCode по стилю похож на HTML, теги заключены в квадратные скобки [ და ], а не в &lt; და &gt;; он даёт больше возможностей управления тем, как თქვენводятся данные. При использовании некоторых შაბლონიов თქვენ сможете добавлять BBCode в ваши წერილები, пользуясь простым интерфейсом, расположенным над полем для ввода текста. Но даже в этом случае данное руководство может оказаться полезным.'
	),
	array(
		0 => '--',
		1 => 'ტექსტის ფორმატირება'
	),
	array(
		0 => 'როგორ გავამუქოთ, დავხაროთ ან ხაზი გავისსვათ ტექსტს',
		1 => 'BBCode აქვს შრიფტის სწრაფი შეცვლის ტეგები. ამის გაკეთება შეიძლება შემდეგნაირად: <ul><li>ტექსტის გასამუქებლად სიტყვა ჩაწერეთ <strong>[b][/b]</strong> ში, მაგალითად:<br /><br /><strong>[b]</strong>გამარჯობათ<strong>[/b]</strong><br /><br />იქნება<strong>Привет</strong></li><li>Для подчёркивания используйте <strong>[u][/u]</strong>, მაგალითად:<br /><br /><strong>[u]</strong>Доброе утро<strong>[/u]</strong><br /><br />станет <span style="text-decoration: underline">Доброе утро</span></li><li>Курсив делается тегами <strong>[i][/i]</strong>, მაგალითად:<br /><br />Это <strong>[i]</strong>здорово!<strong>[/i]</strong><br /><br />თქვენдаст Это <i>здорово!</i></li></ul>'
	),
	array(
		0 => 'Как შეცვლა цвет ან размер текста',
		1 => 'Для изменения цвета ან размера шрифта могут быть использованы следующие теги (окончательный вид будет зависеть от системы და браузера მომხმარებლის): <ul><li>Цвет текста можно შეცვლა, окружив его <strong>[color=][/color]</strong>. თქვენ შეგიძლიათ указать ან известное სახელი цвета (red, blue, yellow და т. п.), ან шестнадцатеричное представление, მაგალითად #FFFFFF, #000000. Таким образом, для создания красного текста თქვენ შეგიძლიათ использовать:<br /><br /><strong>[color=red]</strong>Привет!<strong>[/color]</strong><br /><br />ან<br /><br /><strong>[color=#FF0000]</strong>Привет!<strong>[/color]</strong><br /><br />оба способа дадут в результате <span style="color:red">Привет!</span></li><li>Изменение размера достигается аналогичным образом при использовании <strong>[size=][/size]</strong>. Этот тег зависит от используемых შაბლონიов, рекомендуемый формат — რიცხვი, показывающее размер текста в процентах, от 20% (очень маленький) до 200% (очень დიდი) от размера по умолчанию. მაგალითად:<br /><br /><strong>[size=30]</strong>МАЛЕНЬКИЙ<strong>[/size]</strong><br /><br />скорее всего будет <span style="font-size:30%;">МАЛЕНЬКИЙ</span><br /><br />в то время как:<br /><br /><strong>[size=200]</strong>ОГРОМНЫЙ!<strong>[/size]</strong><br /><br />будет <span style="font-size:200%;">ОГРОМНЫЙ!</span></li></ul>'
	),
	array(
		0 => 'Могу ли я комбинировать теги?',
		1 => 'Да, конечно, შეგიძლიათ . მაგალითად, для привлечения чьего-то внимания თქვენ сможете написать:<br /><br /><strong>[size=200][color=red][b]</strong>ПОСМОТРИТЕ НА МЕНЯ!<strong>[/b][/color][/size]</strong><br /><br />что თქვენдаст <span style="color:red;font-size:200%;"><strong>ПОСМОТРИТЕ НА МЕНЯ!</strong></span><br /><br />Мы не рекомендуем თქვენводить таким образом длинные тексты! Учтите, что თქვენ, автор წერილები, должны позаботиться о том, чтобы теги были правильно вложены. Вот этот BBCode, მაგალითად, неправилен:<br /><br /><strong>[b][u]</strong>Это неверно<strong>[/b][/u]</strong>'
	),
	array(
		0 => '--',
		1 => 'Цитирование და თქვენвод форматированных текстов'
	),
	array(
		0 => 'Цитирование при ответах',
		1 => 'Есть два способа процитировать текст, со ссылкой და без.<ul><li>Когда თქვენ используете кнопку «ციტატა» для ответа на წერილი, то его текст добавляется в поле ввода окружённым блоком <strong>[quote=&quot;&quot;][/quote]</strong>. Этот метод позволит вам цитировать со ссылкой на автора ან на что-то ещё, что თქვენ туда впишете. მაგალითად, для цитирования отрывка текста, написанного Mr. Blobby, თქვენ напишете:<br /><br /><strong>[quote=&quot;Mr. Blobby&quot;]</strong>ტექსტი Mr. Blobby будет აქ<strong>[/quote]</strong><br /><br />В результате перед текстом будут вставлены слова «Mr. Blobby писал(а):». გახსოვდეთ, თქვენ <strong>должны</strong> заключить სახელი в каთქვენчки &quot;&quot;, они не могут быть опущены.</li><li>მეორე метод просто позволяет вам что-то процитировать. Для этого вам надо заключить текст в теги <strong>[quote][/quote]</strong>. При просмотре წერილები будет просто показан текст в блоке цитирования.</li></ul>'
	),
	array(
		0 => 'თქვენвод кода ან форматированного текста',
		1 => 'თუ вам надо თქვენвести кусок программы ან что-то, что должно быть თქვენведено шрифтом фиксированной ширины (Courier), თქვენ должны заключить текст в теги <strong>[code][/code]</strong>, მაგალითად:<br /><br /><strong>[code]</strong>echo &quot;This is some code&quot;;<strong>[/code]</strong><br /><br />Всё форматирование, используемое внутри тегов <strong>[code][/code]</strong>, будет сохранено. Подсветка синтаксиса ენაа PHP может быть включена с помощью <strong>[code=php][/code]</strong> და рекомендуется при отправке сообщений с PHP-кодом для улучшения его удобочитаемости.'
	),
	array(
		0 => '--',
		1 => 'Создание списков'
	),
	array(
		0 => 'Создание маркированного списка',
		1 => 'BBCode поддерживает два вида списков: маркированные და нумерованные. Они практически идентичны своим эквивалентам из HTML. В маркированном списке все элементы თქვენводятся последовательно, каждый отмечается символом-маркером. Для создания маркированного списка используйте <strong>[list][/list]</strong> და определите каждый элемент при помощи <strong>[*]</strong>. მაგალითად, чтобы თქვენвести свои любимые цвета, თქვენ შეგიძლიათ использовать:<br /><br /><strong>[list]</strong><br /><strong>[*]</strong>Красный<br /><strong>[*]</strong>Синий<br /><strong>[*]</strong>Жёлтый<br /><strong>[/list]</strong><br /><br />Это თქვენдаст такой список:<ul><li>Красный</li><li>Синий</li><li>Жёлтый</li></ul>'
	),
	array(
		0 => 'Создание нумерованного списка',
		1 => 'მეორე ტიპი списка, нумерованный, позволяет თქვენбрать, что именно будет თქვენводиться перед каждым элементом. Для создания нумерованного списка используйте <strong>[list=1][/list]</strong> ან <strong>[list=a][/list]</strong> для создания алфавитного списка. Как და в случае маркированного списка, элементы определяются с помощью <strong>[*]</strong>. მაგალითად:<br /><br /><strong>[list=1]</strong><br /><strong>[*]</strong>Пойти в магазин<br /><strong>[*]</strong>Купить ახალი компьютер<br /><strong>[*]</strong>Обругать компьютер, когда случится ошибка<br /><strong>[/list]</strong><br /><br />თქვენдаст следующее:<ol style="list-style-type: decimal"><li>Пойти в магазин</li><li>Купить ახალი компьютер</li><li>Обругать компьютер, когда случится ошибка</li></ol>Для алфавитного списка используйте:<br /><br /><strong>[list=a]</strong><br /><strong>[*]</strong>Перთქვენй возможный ответ<br /><strong>[*]</strong>მეორე возможный ответ<br /><strong>[*]</strong>Третий возможный ответ<br /><strong>[/list]</strong><br /><br />что თქვენдаст<ol style="list-style-type: lower-alpha"><li>Перთქვენй возможный ответ</li><li>მეორე возможный ответ</li><li>Третий возможный ответ</li></ol>'
	),
	// This block will switch the FAQ-Questions to the second template column
	array(
		0 => '--',
		1 => '--'
	),
	array(
		0 => '--',
		1 => 'Создание ссылок'
	),
	array(
		0 => 'Ссылки на другой сайт',
		1 => 'В BBCode поддерживается несколько способов создания URL\'ов.<ul><li>Перთქვენй из них использует тег <strong>[url=][/url]</strong>, после знака = должен идти нужный URL. მაგალითად, для ссылки на phpBB.com თქვენ могли бы использовать:<br /><br /><strong>[url=http://www.phpbb.com/]</strong>Посетите phpBB!<strong>[/url]</strong><br /><br />Это создаст следующую ссылку: <a href="http://www.phpbb.com/">Посетите phpBB!</a> Учтите, что ბმული будет открываться в том же ან в новом окне, в зависимости от настроек браузера მომხმარებლის.</li><li>თუ თქვენ хотите, чтобы в качестве текста ссылки показывался сам URL, თქვენ შეგიძლიათ просто сделать следующее:<br /><br /><strong>[url]</strong>http://www.phpbb.com/<strong>[/url]</strong><br /><br />Это თქვენдаст следующую ссылку: <a href="http://www.phpbb.com/">http://www.phpbb.com/</a></li><li>Кроме того, phpBB поддерживает возможность, называемую <i>Автоматические ссылки</i>, это переведёт любой синтаксически правильный URL в ссылку без необходимости указания тегов და даже префикса http://. მაგალითად, ввод www.phpbb.com в ваше წერილი приведёт к автоматической თქვენдаче <a href="http://www.phpbb.com/">www.phpbb.com</a> при просмотре წერილები.</li><li>То же самое относится და к მისამართიам ელ-ფოსტა, თქვენ შეგიძლიათ ან указать მისამართი в явном виде:<br /><br /><strong>[ელ-ფოსტა]</strong>no.one@domain.adr<strong>[/ელ-ფოსტა]</strong><br /><br />что თქვენдаст <a href="ელ-ფოსტაto:no.one@domain.adr">no.one@domain.adr</a>, ან просто ввести no.one@domain.adr в ваше წერილი, და он будет автоматически преобразован при просмотре.</li></ul>Как და со всеми прочими тегами BBCode, თქვენ შეგიძლიათ заключать в URL\'ы любые другие теги, მაგალითად <strong>[img][/img]</strong> (см. მომდევნო пункт), <strong>[b][/b]</strong> და ა.შ. Как და с тегами форматирования, правильная вложенность тегов зависит от вас, მაგალითად:<br /><br /><strong>[url=http://www.google.com/][img]</strong>http://www.google.com/intl/en_ALL/images/logo.gif<strong>[/url][/img]</strong><br /><br /> <span style="text-decoration: underline">неверно</span>, что может привести к последующему удалению вашего წერილები, так что будьте аккуратнее.'
	),
	array(
		0 => '--',
		1 => 'Показ изображений в წერილებიх'
	),
	array(
		0 => 'დაემატაие სურათები в წერილი',
		1 => 'BBCode включает тег для დაემატაия картинки в ваше წერილი. При этом следует помнить две очень важные вещи: во-перთქვენх, многих მომხმარებელი раздражает большое количество изображений, во-вторых, ваше სურათი уже должно быть размещено в интернете (т. е. оно не может быть расположено მხოლოდ на вашем компьютере, если, конечно, თქვენ не запустან на нём веб-სერვერი!). На данный момент нет возможности хранить სურათები локально на phpBB (ожидается, что это ограничение будет снято в следующей версии phpBB). Для თქვენвода სურათები თქვენ должны окружить его URL тегами <strong>[img][/img]</strong>. მაგალითად:<br /><br /><strong>[img]</strong>http://www.google.com/intl/en_ALL/images/logo.gif<strong>[/img]</strong><br /><br />Как указано в предыдущем пункте, თქვენ შეგიძლიათ заключить სურათი в теги <strong>[url][/url]</strong>, то есть<br /><br /><strong>[url=http://www.google.com/][img]</strong>http://www.google.com/intl/en_ALL/images/logo.gif<strong>[/img][/url]</strong><br /><br />თქვენдаст:<br /><br /><a href="http://www.google.com/"><img src="http://www.google.com/intl/en_ALL/images/logo.gif" alt="" /></a>'
	),
	array(
		0 => 'წერილზე ფაილის მიმაგრება',
		1 => 'Теперь вложения могут быть помещены в любой части წერილები при помощи нового тега BBCode <strong>[attachment=][/attachment]</strong>, если вложения разрешены ადმინისტრატორისგან конференции და если თქვენ имеете необходимые წვდომის უფლებები. На странице размещения წერილები находится თქვენпадающий список (соответственно кнопка) для размещения вложений в сообщении.'
	),
	array(
		0 => '--',
		1 => 'სხვა'
	),
	array(
		0 => 'შემიძლია თუ არა დავამატო საკუთარი ტეგები?',
		1 => 'თუ თქვენ являетесь ადმინისტრატორისგან этого ფორუმიа და имеетe достаточные права, то შეგიძლიათ добавить ноთქვენе теги BBCode в ადმინისტრატორიском разделе.'
	)
);

?>