CREATE TABLE IF NOT EXISTS `mf_config` (
  `name` varchar(100) NOT NULL,
  `value` text NOT NULL,
  PRIMARY KEY (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `mf_config` (`name`, `value`) VALUES
('path', '/'),
('salt', 'some salt 5.6.38 42 78'),
('salt_int', '7'),
('onpage_topics', '15'),
('onpage_posts', '20'),
('time_antispam_topics', '10'),
('time_antispam_posts', '3'),
('maxlen_post', '50000'),
('time_edit_post', '600'),
('time_shift', '0'),
('index_title', 'ფორუმი'),
('users_active', '1'),
('mod_reply_to', '1'),
('time_antispam_private', '15'),
('open_reg', '1'),
('maxlen_short_post', '40'),
('time_silence', '0'),
('domain', ''),
('date_start_forum', '1542056400');

CREATE TABLE IF NOT EXISTS `mf_forums` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `description` varchar(250) NOT NULL,
  `position` int(11) NOT NULL,
  `level` enum('0','1','2','3') NOT NULL,
  `level_topics` enum('0','1','2','3') NOT NULL,
  `count_topics` int(11) NOT NULL,
  `count_posts` int(11) NOT NULL,
  `counter_posts` tinyint(1) NOT NULL,
  `counter_topics` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=109 ;

INSERT INTO `mf_forums` (`id`, `name`, `description`, `position`, `level`, `level_topics`, `count_topics`, `count_posts`, `counter_posts`, `counter_topics`) VALUES
(38, 'ადმინისტრაცია', 'ადმინისტრაციასთან კონტაქტი', 1, '0', '1', 1, 2, 1, 1),
(80, 'კულტურა', 'პოეზია, მხატვრობა, კინო და თეატრი', 4, '0', '1', 0, 0, 1, 1),
(81, 'მელომანია', 'მუსიკა და ყველაფერი მუსიკაზე', 5, '0', '1', 0, 0, 1, 1),
(82, 'სპორტი', 'ფეხბურთი და სპორტის სახეობები', 6, '0', '1', 0, 0, 1, 1),
(83, 'ურთიერთობა', 'ცხოვრებისეული საკითხები', 7, '0', '1', 0, 0, 1, 1),
(84, 'ავტომობილები', 'ყველაფერი ავტომობილების შესახებ', 8, '0', '1', 0, 0, 1, 1),
(85, 'კულინარია', 'კვება და საკვების რეცეპტები', 9, '0', '1', 0, 0, 1, 1),
(86, 'მედიცინა', 'ყველაფერი ჯანმრთელობის შესახებ', 10, '0', '1', 0, 0, 1, 1),
(87, 'ინტერნეტი', 'ყველაფერი ინტერნეტთან დაკავშირებით', 11, '0', '1', 0, 0, 1, 1),
(88, 'პროგრამირება', 'პროგრამული ენები და სკრიპტები', 12, '0', '1', 0, 0, 1, 1),
(89, 'კომერცია', 'სავაჭრო განყოფილება ფორუმზე', 13, '0', '1', 0, 0, 1, 1),
(90, 'კომპიუტერები', 'ყველაფერი კომპიუტერებზე', 14, '0', '1', 0, 0, 1, 1),
(91, 'მობილურები', 'მობილური ტელეფონების განხილვა', 15, '0', '1', 0, 0, 1, 1),
(92, 'თამაშები', 'კომპიუტერის და მობილურის თამაშები', 16, '0', '1', 1, 1, 1, 1),
(93, 'პროგრამები', 'ოპერაციული სისტემები და აპლიკაციები', 17, '0', '1', 0, 0, 1, 1),
(94, 'სხვადასხვა', 'შერეული თემების განყოფილება', 32, '0', '1', 1, 3, 1, 1),
(78, 'პოლიტიკა', 'საქართველოსი და მსოფლიოს პოლიტიკა', 2, '0', '1', 0, 0, 1, 1),
(79, 'მეცნიერება', 'შემეცნება და მეცნიერული ფაქტები', 3, '0', '1', 0, 0, 1, 1),
(95, 'დასაქმება', 'ვაკანსიების განყოფილება', 18, '0', '1', 0, 0, 1, 1),
(96, 'მასმედია', 'ახალი ამბები და ტელეგადაცემები', 19, '0', '1', 0, 0, 1, 1),
(97, 'ფილოსოფია', 'ფილოსოფიური თემების განყოფილება', 20, '0', '1', 0, 0, 1, 1),
(98, 'რელიგია', 'მსოფლიო რელიგიები და რწმენები', 21, '0', '1', 0, 0, 1, 1),
(99, 'არსენალი', 'სამხედო საქმე და იარაღები', 22, '0', '1', 0, 0, 1, 1),
(100, 'გართობა', 'გასართობი განყოფილება', 23, '0', '1', 0, 0, 1, 1),
(101, 'კომუნიკაცია', 'სატელიტები და ქსელები', 24, '0', '1', 1, 2, 1, 1),
(102, 'ფსიქოლოგია', 'ფსიქოლოგიური თემები', 25, '0', '1', 0, 0, 1, 1),
(103, 'პარამეცნიერები', 'პარაფსიქოლოგია და მისტიკა', 26, '0', '1', 0, 0, 1, 1),
(104, 'კინემატოგრაფია', 'ფილმები და სერიალები', 27, '0', '1', 0, 0, 1, 1),
(105, 'ბუნება', 'ცხოველები და მცენარეები', 28, '0', '1', 0, 0, 1, 1),
(106, 'იუმორი', 'იუმორისტული თემები', 29, '0', '1', 0, 0, 1, 1),
(107, 'ლიტერატურა', 'ლიტერატურის განყოფილება', 30, '0', '1', 0, 0, 1, 1),
(108, 'სილამაზე', 'ყველაფერი მოდის შესახებ', 31, '0', '1', 0, 0, 1, 1);

CREATE TABLE IF NOT EXISTS `mf_posts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tid` int(11) NOT NULL,
  `fid` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  `ip` bigint(20) NOT NULL,
  `ua` varchar(250) NOT NULL,
  `edit_count` tinyint(4) NOT NULL,
  `edit_date` int(11) NOT NULL,
  `edit_user_id` int(11) NOT NULL,
  `answer_to` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `author_id` (`user_id`),
  KEY `ip` (`ip`),
  KEY `date` (`date`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=28 ;

CREATE TABLE IF NOT EXISTS `mf_posts_answers` (
  `pid` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `answer_pid` int(11) NOT NULL,
  `answer_user` int(11) NOT NULL,
  `tid` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`pid`,`answer_pid`),
  KEY `pid` (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `mf_posts_text` (
  `pid` int(11) NOT NULL,
  `text` longtext NOT NULL,
  PRIMARY KEY (`pid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE IF NOT EXISTS `mf_private_contacts` (
  `user_id` int(11) NOT NULL,
  `contact_user_id` int(11) NOT NULL,
  PRIMARY KEY (`user_id`,`contact_user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `mf_private_messages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `to_user_id` int(11) NOT NULL,
  `new` enum('0','1') NOT NULL,
  `date` int(11) NOT NULL,
  `text` text NOT NULL,
  `ip` bigint(20) NOT NULL,
  `ua` varchar(250) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  KEY `to_user_id` (`to_user_id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=4 ;

CREATE TABLE IF NOT EXISTS `mf_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `title` varchar(70) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=11 ;

INSERT INTO `mf_rules` (`id`, `cid`, `title`, `text`) VALUES
(1, 2, '#1 წესი', '1. საიტზე აკრძალულია უცენზურო სიტყვების გამოყენება და უცენზურო მეტსახელით რეგისტრაცია.'),
(2, 2, '#2 წესი', '2. აკრძალულია ღიად მომხმარებელთან ჩხუბი და დამცირება, პირადული გაარკვიეთ პირადი ფოსტით, ასევე აკრძალულია რელიგიური და რასობრივი უმცირესობების წარმომადგენლების შეურაწყოფა.'),
(3, 2, '#3 წესი', '3. დაუშვებელია პირადი საიტების ნებისმიერი ფორმით რეკლამირება ჩვენს საიტზე.'),
(4, 2, '#4 წესი', '4. აკრძალულია ერთზე მეტი მეტსახელის რეგისტრაცია და გამოყენება სხვადასხვა მიზნით.'),
(5, 2, '#5 წესი', '5. აკრძალულია ერთი და იგივე გზავნილების მრავლობითად დაგზავნა ანუ სპამი.'),
(6, 2, '#6 წესი', '6. აკრძალულია დახურული თემის ხელმეორედ გახსნა, ასევე აკრძალულია ბლოკირების შემთხვევაში ხელმეორედ რეგისტრაცია.'),
(7, 2, '#7 წესი', '7. საიტზე იკრძალება პორნოგრაფიული მასალის გამოქვეყნება ნებისმიერი ფორმით.'),
(8, 2, '#8 წესი', '8. დაუშვებელია ცრუ ინფორმაციის გავცელება, ინფორმაციას აუცილებელია დაურთოთ ინფორმაციის წყაროც.'),
(9, 2, '#9 წესი', '9. აკრძალულია სიცილაკების ჭარბი გამოყენება და უაზრო პოსტების წერა.');

CREATE TABLE IF NOT EXISTS `mf_rules_cats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `position` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=3 ;

INSERT INTO `mf_rules_cats` (`id`, `name`, `position`) VALUES
(2, 'საიტის წესები', 1);

CREATE TABLE IF NOT EXISTS `mf_topics` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fid` int(11) NOT NULL,
  `name` varchar(100) NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  `last_user_id` int(11) NOT NULL,
  `last_date` int(11) NOT NULL,
  `first_post` int(11) NOT NULL,
  `first_post_on_pages` enum('0','1') NOT NULL COMMENT '0',
  `not_edit_author` enum('0','1') NOT NULL COMMENT '0',
  `answer_to` int(11) NOT NULL,
  `count_posts` int(11) NOT NULL,
  `open` int(11) NOT NULL,
  `top` enum('0','1') NOT NULL,
  `level` enum('0','1','2','3') NOT NULL,
  `level_posts` enum('0','1','2','3') NOT NULL,
  `count_all_views` int(11) NOT NULL,
  `count_views` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `author_id` (`user_id`),
  KEY `fid` (`fid`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=13 ;

CREATE TABLE IF NOT EXISTS `mf_topics_bookmarks` (
  `tid` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`tid`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `mf_topics_logs` (
  `tid` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `text` text NOT NULL,
  `ip` bigint(20) NOT NULL,
  `ua` varchar(250) NOT NULL,
  KEY `tid` (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `mf_topics_views` (
  `tid` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`tid`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO `mf_topics_views` (`tid`, `user_id`, `date`) VALUES
(7, 1, 1545744983),
(7, 4, 1543844011),
(7, 6, 1545293538),
(7, 7, 1545293538),
(7, 8, 1545744983),
(10, 9, 1546531201),
(7, 9, 1545744983),
(10, 1, 1546531201),
(7, 10, 1545744983),
(10, 10, 1546531201),
(10, 11, 1546192523),
(7, 11, 1545744983),
(7, 12, 1545744983),
(10, 12, 1546192523),
(11, 12, 1546423604),
(11, 1, 1546531411),
(10, 8, 1546192523),
(11, 9, 1546531411),
(12, 9, 1546531520),
(12, 1, 1546531520);

CREATE TABLE IF NOT EXISTS `mf_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(40) NOT NULL,
  `nick` varchar(40) NOT NULL,
  `password` varchar(32) NOT NULL,
  `active` enum('0','1') NOT NULL DEFAULT '0',
  `level` enum('1','2','3') NOT NULL DEFAULT '1',
  `date_reg` int(11) NOT NULL,
  `date_last_visit` int(11) NOT NULL,
  `set_onpage_topics` tinyint(4) NOT NULL,
  `set_onpage_posts` tinyint(4) NOT NULL,
  `set_fast_post` enum('0','1') NOT NULL,
  `set_time_shift` tinyint(2) NOT NULL,
  `ip` bigint(20) NOT NULL,
  `ua` varchar(250) NOT NULL,
  `page` varchar(250) NOT NULL,
  `info_name` varchar(50) NOT NULL,
  `info_birthday` varchar(50) NOT NULL,
  `info_city` varchar(70) NOT NULL,
  `info_email` varchar(100) NOT NULL,
  `info_tel` varchar(50) NOT NULL,
  `info_site` varchar(50) NOT NULL,
  `info_interest` varchar(500) NOT NULL,
  `info_about` varchar(500) NOT NULL,
  `info_sex` enum('0','1') NOT NULL,
  `info_avatar` varchar(5000) NOT NULL,
  `punish_ban` enum('0','1') NOT NULL,
  `punish_pid` int(11) NOT NULL,
  `punish_to_date` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `login` (`login`),
  UNIQUE KEY `nick` (`nick`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=14 ;

INSERT INTO `mf_users` (`id`, `login`, `nick`, `password`, `active`, `level`, `date_reg`, `date_last_visit`, `set_onpage_topics`, `set_onpage_posts`, `set_fast_post`, `set_time_shift`, `ip`, `ua`, `page`, `info_name`, `info_birthday`, `info_city`, `info_email`, `info_tel`, `info_site`, `info_interest`, `info_about`, `info_sex`, `info_avatar`, `punish_ban`, `punish_pid`, `punish_to_date`) VALUES
(1, 'admin', 'admin', 'f695b5bef246ee8eddf950f4ff4e755b', '1', '3', 1542090081, 1546602766, 15, 20, '0', 0, 1547094331, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/70.0.3538.102 Safari/537.36 OPR/57.0.3098.106', '/index.php', 'მერაბი', '26 ივნისი 1990', 'ქარელი', 'admin@forumi.eu.org', '555', 'http://forumi.eu.org', 'მეცნიერება', 'ფორუმის მფლობელი', '1', 'https://d.radikal.ru/d28/1812/91/e74d7ef1cc9b.png', '0', 0, 0);

CREATE TABLE IF NOT EXISTS `mf_users_punishes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `punished_user_id` int(11) NOT NULL,
  `rule` int(11) NOT NULL,
  `date` int(11) NOT NULL,
  `to_date` int(11) NOT NULL,
  `comment` tinytext NOT NULL,
  `pid` int(11) NOT NULL,
  `ban` enum('0','1') NOT NULL,
  `close_private` enum('0','1') NOT NULL,
  `ip` bigint(20) NOT NULL,
  `ua` varchar(250) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;
