<?php
// Copyright 2014 Tristan van Bokkem

if (!defined("IN_ESOTALK")) exit;

ET::$pluginInfo["Signature"] = array(
	"name" => "Signature",
	"description" => "Let users add their signature to posts.",
	"version" => "1.1.5",
    "author" => "esoTalk Team",
    "authorEmail" => "5557720max@gmail.com",
    "authorURL" => "https://github.com/phpSoftware/esoTalk-v2/",
	"license" => "GPLv2",
	"priority" => "0"
);

class ETPlugin_Signature extends ETPlugin {

	// https://gist.github.com/getmanzooronline/61e341cb8de3d98ec12b
	function truncate($text, $length=150, $ending='...', $exact=true, $considerHtml=true) {
	 if ($considerHtml) {
	  // if the plain text is shorter than the maximum length, return the whole text
	  if (strlen(preg_replace('/<.*?>/', '', $text)) <= $length) {
	   return $text;
	  }
	  // splits all html-tags to scanable lines
	  preg_match_all('/(<.+?>)?([^<>]*)/s', $text, $lines, PREG_SET_ORDER);
	  $total_length = strlen($ending);
	  $open_tags = array();
	  $truncate = '';
	  foreach ($lines as $line_matchings) {
	   // if there is any html-tag in this line, handle it and add it (uncounted) to the output
	   if (!empty($line_matchings[1])) {
	    // if it’s an “empty element” with or without xhtml-conform closing slash (f.e.)
	    if (preg_match('/^<(\s*.+?\/\s*|\s*(img|br|input|hr|area|base|basefont|col|frame|isindex|link|meta|param)(\s.+?)?)>$/is', $line_matchings[1])) {
	    // do nothing
	    // if tag is a closing tag (f.e.)
	    } else if (preg_match('/^<\s*\/([^\s]+?)\s*>$/s', $line_matchings[1], $tag_matchings)) {
	     // delete tag from $open_tags list
	     $pos = array_search($tag_matchings[1], $open_tags);
	     if ($pos !== false) {
	      unset($open_tags[$pos]);
	     }
	     // if tag is an opening tag (f.e. )
	    } else if (preg_match('/^<\s*([^\s>!]+).*?>$/s', $line_matchings[1], $tag_matchings)) {
	     // add tag to the beginning of $open_tags list
	     array_unshift($open_tags, strtolower($tag_matchings[1]));
	    }
	    // add html-tag to $truncate’d text
	    $truncate .= $line_matchings[1];
	   }
	   // calculate the length of the plain text part of the line; handle entities as one character
	   $content_length = strlen(preg_replace('/&[0-9a-z]{2,8};|&#[0-9]{1,7};|&#x[0-9a-f]{1,6};/i', ' ', $line_matchings[2]));
	   if ($total_length+$content_length > $length) {
	    // the number of characters which are left
	    $left = $length - $total_length;
	    $entities_length = 0;
	    // search for html entities
	    if (preg_match_all('/&[0-9a-z]{2,8};|&#[0-9]{1,7};|&#x[0-9a-f]{1,6};/i', $line_matchings[2], $entities, PREG_OFFSET_CAPTURE)) {
	     // calculate the real length of all entities in the legal range
	     foreach ($entities[0] as $entity) {
	      if ($entity[1]+1-$entities_length <= $left) {
	       $left--;
	       $entities_length += strlen($entity[0]);
	      } else {
	       // no more characters left
	       break;
	      }
	     }
	    }
	    $truncate .= substr($line_matchings[2], 0, $left+$entities_length);
	    // maximum lenght is reached, so get off the loop
	    break;
	   } else {
	    $truncate .= $line_matchings[2];
	    $total_length += $content_length;
	   }
	   // if the maximum length is reached, get off the loop
	   if($total_length >= $length) {
	    break;
	   }
	  }
	 } else {
	  if (strlen($text) <= $length) {
	   return $text;
	  } else {
	   $truncate = substr($text, 0, $length - strlen($ending));
	  }
	 }
	 // if the words shouldn't be cut in the middle...
	 if (!$exact) {
	  // ...search the last occurance of a space...
	  $spacepos = strrpos($truncate, ' ');
	  if (isset($spacepos)) {
	   // ...and cut the text in this position
	   $truncate = substr($truncate, 0, $spacepos);
	  }
	 }
	 // add the defined ending to the text
	 $truncate .= $ending;
	 if($considerHtml) {
	  // close all unclosed html-tags
	  foreach ($open_tags as $tag) {
	   $truncate .= "</".$tag.">";
	  }
	 }
	return $truncate;
 }

	function setup($oldVersion = "")
	{
		ET::writeConfig(array("plugin.Signature.characters" => "150"));
		return true;
	}

	function handler_settingsController_initGeneral($sender, $form)
	{
		$form->addSection("signature", T("Signature"), array("after" => "privacy"));
		$form->setValue("signature", ET::$session->preference("signature"));
		$form->addField("signature", "signature", array($this, "fieldSignature"), array($this, "saveSignature"));
	}

	function fieldSignature($form)
	{
		$signature = self::truncate(ET::formatter()->init(ET::$session->preference("signature"))->format()->get(),C("plugin.Signature.characters"));

		if ($signature)
		{
			return $form->input("signature", "text")." <small>(".T("Max characters:")." ".C("plugin.Signature.characters").", ".T("BBCode Allowed").")</small><br /><br /><small>".$signature."</small>";
		}
		else
		{
			return $form->input("signature", "text")." <small>(".T("Max characters:")." ".C("plugin.Signature.characters").", ".T("BBCode Allowed").")</small><br /><br /><small>-</small>";
		}
	}

	public function saveSignature($form, $key, &$preferences)
	{
		$signature = $form->getValue($key);
		$preferences["signature"] = $signature;
	}

	public function handler_conversationController_renderBefore($sender)
	{
		$sender->addCSSFile($this->resource("signature.css"));
		$sender->addJSFile($this->resource("signature.js"));
	}

	public function handler_conversationController_formatPostForTemplate($sender, &$formatted, $post, $conversation)
	{
		if ($post["deleteMemberId"]) return;

		// Lets check if the Likes plugin is active,
		// if so we need to output the signature HTML a bit different.
		$signature = ET::formatter()->init($post["preferences"]["signature"])->format()->get();
		if (in_array("Likes", C("esoTalk.enabledPlugins")))
		{
			if ($signature)
			{
				addToArray($formatted["footer"], "<div class='signature'>".self::truncate(
$signature,C("plugin.Signature.characters"))."</div>", 0);
			}
			else
			{
				return;
			}
		}
		else
		{
			addToArray($formatted["footer"], "<p class='signature-no-likes'>".self::truncate($signature,C("plugin.Signature.characters"))."</p>", 0);
		}
	}

	public function settings($sender)
	{
		// Set up the settings form.
		$form = ETFactory::make("form");
		$form->action = URL("admin/plugins/settings/Signature");

		// Set the values for the sitemap options.
		$form->setValue("characters", C("plugin.Signature.characters", "150"));

		// If the form was submitted...
		if ($form->validPostBack()) {

			// Construct an array of config options to write.
			$config = array();
			$config["plugin.Signature.characters"] = $form->getValue("characters");

			// Write the config file.
			ET::writeConfig($config);

			$sender->redirect(URL("admin/plugins"));
		}

		$sender->data("SignatureSettingsForm", $form);
		return $this->view("settings");
	}

}
