<?php
require_once __DIR__ . '/header.php';
$d = load_data();

// handle login/logout
if (isset($_POST['admin_login'])) {
    if (admin_login($_POST['password'] ?? '')) { header('Location: admin.php'); exit; }
    else echo '<div class="card">Wrong password.</div>';
}
if (isset($_GET['logout'])) { admin_logout(); header('Location: admin.php'); exit; }


?>
<div class="card">
  <h2>Admin Panel</h2>
  <?php if (!is_admin()): ?>
    <form method="post" class="row">
      <input type="password" name="password" placeholder="Admin password">
      <button class="btn" name="admin_login" value="1">Login</button>
    </form>
  <?php else: ?>
    <div>
      <a class="btn secondary" href="admin.php?logout=1">Logout</a>
    </div>
<?php
$ipFile = __DIR__ . "/ip.json";
$data = json_decode(file_get_contents($ipFile), true);
$blocked = $data['blocked'] ?? [];

// Pagination
$perPage = 5;
$total = count($blocked);
$page = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$start = ($page - 1) * $perPage;
$paginated = array_slice($blocked, $start, $perPage);
?>
  <title>IP Management</title>
  <style>
    table { border-collapse: collapse; width: 400px; }
    td, th { border: 1px solid #ccc; padding: 8px; }
  </style>
</head>
<body>
<h2>Blocked IP List</h2>

<!-- Show blocked IPs -->
<table>
  <tr><th>IP Address</th><th>Action</th></tr>
  <?php foreach ($paginated as $ip): ?>
    <tr>
      <td><?= htmlspecialchars($ip) ?></td>
      <td><a href="blocking.php?action=unblock&ip=<?= urlencode($ip) ?>">Unblock</a></td>
    </tr>
  <?php endforeach; ?>
</table>

<!-- Pagination -->
<p>
<?php for ($i = 1; $i <= ceil($total / $perPage); $i++): ?>
  <a href="?page=<?= $i ?>"><?= $i ?></a>
<?php endfor; ?>
</p>

<!-- Manual block form -->
<h3>Block New IP</h3>
<form class="row" action="blocking.php" method="get">
  <input type="hidden" name="action" value="block">
  <input type="text" name="ip" placeholder="Enter IP" required>
  <button class="btn" type="submit">Block</button>
</form>
  <?php endif; ?>
</div>
<?php require_once __DIR__ . '/footer.php'; ?>
