<?php
require_once __DIR__ . '/header.php';
$d = load_data();
$topics = array_values($d['topics']);
usort($topics, function($a,$b){ return ($b['updated_at']??0) <=> ($a['updated_at']??0); });
$topics = array_slice($topics, 0, 15);
?>
<div class="card">
  <h2>Last Active Topics</h2>
  <?php if (empty($topics)): ?>
    <div class="muted">No topics yet.</div>
  <?php else: foreach ($topics as $t): ?>
    <div class="topic badges">
      <a href="posts.php?id=<?php echo h($t['id']); ?>"><strong><?php echo h($t['title']); ?></strong></a>
        <?php if (!empty($t['sticky'])): ?><span>Sticky</span><?php endif; ?>
        <?php if (!empty($t['closed'])): ?><span>Closed</span><?php endif; ?>
      <div class="muted"><br><span>by <?php $au = $d['users'][$t['author_id']]['username'] ?? 'Unknown'; echo h($au); ?> •
        updated <?php echo date('Y-m-d H:i', $t['updated_at']); ?></span></div>
    </div>
  <?php endforeach; endif; ?>
</div>
<?php require_once __DIR__ . '/footer.php'; ?>
