<?php
require_once __DIR__ . '/header.php';
require_once __DIR__ . '/pagination.php';
$me = current_user();
$d = load_data();
$id = (string)($_GET['id'] ?? '');
if (!isset($d['topics'][$id])) { echo '<div class="card">Topic not found.</div>'; require 'footer.php'; exit; }
$t = $d['topics'][$id];

// Pagination for posts
$all = array_values(array_filter($d['posts'], function($p) use ($id){ return $p['topic_id']===$id; }));
usort($all, function($a,$b){ return $a['created_at'] <=> $b['created_at']; });
$per = 15;
$page = max(1,(int)($_GET['page']??1));
$total = max(1, (int)ceil(count($all)/$per));
$offset = ($page-1)*$per;
$posts = array_slice($all, $offset, $per);

// Reply
$error='';
$quote = '';
if (isset($_GET['quote'])) {
    $qid = (string)$_GET['quote'];
    if (isset($d['posts'][$qid])) {
        $qcontent = $d['posts'][$qid]['content'];
        $quote = "[quote]". $qcontent ."[/quote]\n";
    }
}
if ($_SERVER['REQUEST_METHOD']==='POST' && (!$t['closed'] || is_admin())) {
    $content = trim($_POST['content'] ?? '');
    if ($content==='') { $error='Content required.'; }
    else {
        $pid = next_post_id($d);
        $d['posts'][$pid] = [
            'id'=>$pid, 'topic_id'=>$id, 'content'=>$content, 'author_id'=>$me['id'], 'author_ip'=>ip(),
            'created_at'=>now(), 'updated_at'=>now()
        ];
        $d['topics'][$id]['replies'] = ($d['topics'][$id]['replies'] ?? 0)+1;
        $d['topics'][$id]['updated_at'] = now();
        save_data($d);
        header('Location: posts.php?id='.$id.'&page='.$total.'#p'.$pid);
        exit;
    }
}
?>
<div class="card">
  <h2><?php echo h($t['title']); ?></h2>
  <div class="badges">
    <?php if (!empty($t['sticky'])): ?><span>Sticky</span><?php endif; ?>
    <?php if (!empty($t['closed'])): ?><span>Closed</span><?php endif; ?>
    <span>Author IP: <?php echo h($t['author_ip']); ?></span>

 <?php
$file = 'data.json';

$data = file_exists($file) ? json_decode(file_get_contents($file), true) : [];
$item = isset($data[$id]) ? $data[$id] : ['total'=>0,'count'=>0];
$average = $item['count'] > 0 ? round($item['total'] / $item['count'], 2) : 0;
?>

<h3>Rate this topic:</h3>
<div id="stars">
<?php for($i=1; $i<=5; $i++): ?>
    <span class="star" data-value="<?= $i ?>"><small><?= $i ?></small>&#9733;</span>
<?php endfor; ?>
</div>
<p>Average: <span id="average"><?= $average ?></span> stars (<?= $item['count'] ?> votes)</p>

<script>
document.querySelectorAll('#stars .star').forEach(star => {
    star.addEventListener('click', () => {
        const stars = star.dataset.value;
        fetch('vote.php', {
            method: 'POST',
            headers: {'Content-Type': 'application/x-www-form-urlencoded'},
            body: 'id=<?= $id ?>&stars=' + stars
        })
        .then(res => res.json())
        .then(data => {
            if(data.status === 'success'){
                document.getElementById('average').innerText = data.average + ' (' + data.count + ' votes)';
                alert('Thanks for voting!');
            } else {
                alert(data.message);
            }
        });
    });
});
</script>

<style>
.star {
color: orange;
}
.star:hover {
color: white;
}
</style>

  </div>
  <?php if (is_admin()): ?><br>
    <div>
      <a class="btn small secondary" href="edit.php?type=topic&id=<?php echo h($id); ?>">Edit</a>
      <a class="btn small secondary" href="sticky.php?id=<?php echo h($id); ?>">Sticky On/Off</a>
      <a class="btn small secondary" href="close.php?id=<?php echo h($id); ?>">Close</a>
      <a class="btn small secondary" href="open.php?id=<?php echo h($id); ?>">Open</a>
      <a class="btn small danger" href="delete.php?type=topic&id=<?php echo h($id); ?>" onclick="return confirm('Delete topic?')">Delete</a>
    </div>
  <?php endif; ?>
</div>

<div class="card">
  <h3>Posts</h3>
  <?php foreach ($posts as $p): $uid = $p['author_id']; $user = $d['users'][(string)$uid]['username'] ?? 'Unknown'; ?>
    <div class="post" id="p<?php echo h($p['id']); ?>">
      <div class="badges"><strong><?php echo h($user); ?></strong> <span>IP: <?php echo h($p['author_ip']); ?> • <?php echo date('Y-m-d H:i', $p['created_at']); ?></span></div><br>
      <div><?php echo render_content($p['content']); ?></div><br>
      <div>

<?php
$topicid = $id;
$postid = $p['id'];
?>
<script src="jquery-3.7.1.min.js"></script>
<?php
// assume $topicid and $postid exist already in your page
// sanitize display ID
$displayPostId = htmlspecialchars($postid, ENT_QUOTES, 'UTF-8');
?>
<style>
/* black / gray heart style */
.like-btn { display:inline-flex; align-items:center; gap:8px; cursor:pointer; user-select:none; }
.like-btn .heart {
  width:22px; height:22px; display:inline-block; transform-origin:center; transition: transform .15s ease;
}
.like-btn .count { font-family: Arial, sans-serif; font-size:14px; color:#fff; }
.like-btn .heart.svg-gray path { fill: gray; }    /* not-liked: gray */
.like-btn .heart.svg-black path { fill: red; }   /* liked: black */
.like-btn.liked .heart { transform: scale(1.05); }
</style>

<div class="post" data-postid="<?php echo $displayPostId; ?>">
  <!-- your post content here -->
  <div class="like-btn" title="Like" role="button" aria-pressed="false" data-postid="<?php echo $displayPostId; ?>">
    <!-- SVG heart (simple) -->
    <svg class="heart svg-gray" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true">
      <path d="M12 21s-7.2-4.73-9.5-7.02C-0.45 10.73 2.33 5 7.3 5c2.2 0 3.7 1.2 4.7 2.5C12.99 6.2 14.5 5 16.7 5 21.67 5 24.45 10.73 21.5 13.98 19.2 16.27 12 21 12 21z"/>
    </svg>
    <span class="count">0</span>
  </div>
</div>

<script>
// Minimal client-side code (no jQuery) — works with multiple posts
document.addEventListener('DOMContentLoaded', function () {
  async function getLikeInfo(postid, el) {
    try {
      let params = new URLSearchParams({ action: 'get', postid: postid });
      let res = await fetch('api.php?' + params.toString(), { credentials: 'same-origin' });
      let json = await res.json();
      if (json.ok) {
        updateUI(el, json.likes, json.liked);
      }
    } catch (err) { console.error(err); }
  }

  async function toggleLike(postid, el) {
    try {
      let params = new URLSearchParams({ action: 'toggle', postid: postid });
      let res = await fetch('api.php', {
        method: 'POST',
        body: params,
        credentials: 'same-origin',
        headers: { 'Accept': 'application/json' }
      });
      let json = await res.json();
      if (json.ok) {
        updateUI(el, json.likes, json.liked);
      } else {
        console.error('Error:', json);
      }
    } catch (err) {
      console.error(err);
    }
  }

  function updateUI(el, likes, liked) {
    if (!el) return;
    const svg = el.querySelector('.heart');
    const count = el.querySelector('.count');
    count.textContent = likes;
    if (liked) {
      el.classList.add('liked');
      svg.classList.remove('svg-gray');
      svg.classList.add('svg-black');
      el.setAttribute('aria-pressed', 'true');
    } else {
      el.classList.remove('liked');
      svg.classList.remove('svg-black');
      svg.classList.add('svg-gray');
      el.setAttribute('aria-pressed', 'false');
    }
  }

  // initialize each like button on the page
  document.querySelectorAll('.like-btn').forEach(btn => {
    const postid = btn.dataset.postid;
    if (!postid) return;
    // load initial state
    getLikeInfo(postid, btn);

    btn.addEventListener('click', function (e) {
      e.preventDefault();
      // debounce: disable while request in progress
      if (btn.dataset.busy === '1') return;
      btn.dataset.busy = '1';
      toggleLike(postid, btn).finally(() => { btn.dataset.busy = '0'; });
    });
  });
});
</script>

<script>
function insertText(text) {
    const replyBox = document.getElementById("replyBox");
    
    // Insert text at cursor position
    const start = replyBox.selectionStart;
    const end = replyBox.selectionEnd;
    const before = replyBox.value.substring(0, start);
    const after = replyBox.value.substring(end);
    
    replyBox.value = before + text + after;
    
    // Move cursor to after inserted text
    replyBox.selectionStart = replyBox.selectionEnd = start + text.length;
    replyBox.focus();
}
</script>

<a class="btn small secondary" href="#reply" onclick="insertText('[b]<?php echo $user; ?>[/b], ')">Reply</a>
        <a class="btn small secondary" href="posts.php?id=<?php echo h($id); ?>&quote=<?php echo h($p['id']); ?>#reply">Quote</a>
        <?php if (is_admin() || $uid===$me['id']): ?>
        <a class="btn small secondary" href="edit.php?type=post&id=<?php echo h($p['id']); ?>">Edit</a>
        <a class="btn small danger" href="delete.php?type=post&id=<?php echo h($p['id']); ?>" onclick="return confirm('Delete post?')">Delete</a>
        <?php endif; ?>
      </div>
    </div>
  <?php endforeach; ?>
  <?php render_pagination($page, $total, 'posts.php?id='.urlencode($id)); ?>
</div>

<?php if (!$t['closed'] || is_admin()): ?>
<?php if ($error): ?><div class="card"><?php echo h($error); ?></div><?php endif; ?>
<div class="card" id="reply">
  <h3>Reply</h3>
  
<style>
/* Panel styling */
.bb-emoji-panel {
  background: #111;
  color: #fff;
  border-radius: 8px;
  margin-bottom: 10px;
  padding: 5px;
  font-family: sans-serif;
}

/* Tabs */
.tab-buttons {
  display: flex;
  border-bottom: 1px solid #444;
}
.tab-buttons button {
  flex: 1;
  padding: 8px;
  background: #222;
  color: #ccc;
  border: none;
  cursor: pointer;
}
.tab-buttons button.active {
  background: #000;
  color: #fff;
  font-weight: bold;
}

/* Tab content */
.tab-content {
  display: none;
  padding: 8px;
}
.tab-content.active {
  display: block;
}

/* BBCode buttons */
.bb-buttons button {
  margin: 3px;
  padding: 5px 10px;
  background: #333;
  color: #fff;
  border: none;
  cursor: pointer;
  border-radius: 4px;
}
.bb-buttons button:hover {
  background: #555;
}

/* Emoji grid */
.emoji-grid {
  display: flex;
  flex-wrap: wrap;
  gap: 5px;
}
.emoji-grid span {
  cursor: pointer;
  font-size: 20px;
  padding: 5px;
  border-radius: 4px;
}
.emoji-grid span:hover {
  background: #444;
}
</style>

<div class="bb-emoji-panel">
  <div class="tab-buttons">
    <button type="button" class="tab-btn active" data-tab="bbcodes">BB Codes</button>
    <button type="button" class="tab-btn" data-tab="emojis">Emojis</button>
  </div>

  <!-- BBCode tab -->
  <div id="bbcodes" class="tab-content active">
    <div class="bb-buttons">
      <button type="button" data-bb="[b][/b]"><b>B</b></button>
      <button type="button" data-bb="[i][/i]"><i>I</i></button>
      <button type="button" data-bb="[u][/u]"><u>U</u></button>
      <button type="button" data-bb="[s][/s]"><s>S</s></button>
      <button type="button" data-bb="[url][/url]"><font color="blue">URL</font></button>
      <button type="button" data-bb="[quote][/quote]"><font color="gray">QUOTE</font></button>
      <button type="button" data-bb="[img][/img]"><font color="green"><b>IMG</b></font></button>
      <button type="button" data-bb="[youtube][/youtube]"><font color="red"><b>You</b></font>Tube</button>
    </div>
  </div>

  <!-- Emoji tab -->
  <div id="emojis" class="tab-content">
    <div class="emoji-grid">
<!-- Happy / Positive -->
<span>😀</span> <span>😁</span> <span>😂</span> <span>🤣</span> <span>😊</span> <span>😇</span> <span>😍</span> <span>🥰</span> <span>😘</span> <span>😋</span> <span>😎</span> <span>🤩</span>

<!-- Sad / Negative -->
<span>😞</span> <span>😔</span> <span>😟</span> <span>😢</span> <span>😭</span> <span>😩</span> <span>😫</span> <span>🥺</span> <span>😖</span> <span>☹️</span> <span>🙁</span> <span>😓</span>

<!-- Angry / Frustrated -->
<span>😠</span> <span>😡</span> <span>🤬</span> <span>😤</span> <span>😣</span> <span>🤯</span>

<!-- Love / Affection -->
<span>❤️</span> <span>💛</span> <span>💚</span> <span>💙</span> <span>💜</span> <span>🖤</span> <span>🤎</span> <span>🤍</span> <span>💔</span> <span>❣️</span> <span>💕</span> <span>💞</span> <span>💓</span> <span>💗</span> <span>💖</span> <span>💘</span> <span>💝</span> <span>💟</span>

<!-- Surprise / Shock -->
<span>😲</span> <span>😯</span> <span>😮</span> <span>😳</span> <span>🥵</span> <span>🥶</span> <span>🤯</span> <span>😱</span>

<!-- Neutral / Thinking -->
<span>😐</span> <span>😑</span> <span>😶</span> <span>😏</span> <span>🤔</span> <span>🤨</span> <span>😬</span> <span>🙄</span>

<!-- Sleepy / Sick -->
<span>😴</span> <span>🥱</span> <span>🤤</span> <span>🤢</span> <span>🤮</span> <span>🤧</span> <span>🤒</span> <span>🤕</span>

<!-- Funny / Playful -->
<span>😜</span> <span>😝</span> <span>😛</span> <span>🤪</span> <span>🥳</span> <span>🫨</span>

<!-- Other Reactions -->
<span>🙏</span> <span>🤝</span> <span>👍</span> <span>👎</span> <span>👏</span> <span>🙌</span> <span>🤲</span> <span>🤗</span> <span>🤭</span> <span>🤫</span> <span>😶‍🌫️</span>

    </div>
  </div>
</div>

<form class="row" method="post">
  <textarea id="replyBox" name="content" rows="5" placeholder="Write reply..."><?php echo h($quote); ?></textarea>
  <button class="btn">Post Reply</button>
</form>

<script>
// Tabs switching
document.querySelectorAll('.tab-btn').forEach(btn => {
  btn.addEventListener('click', () => {
    document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
    document.querySelectorAll('.tab-content').forEach(tc => tc.classList.remove('active'));
    btn.classList.add('active');
    document.getElementById(btn.dataset.tab).classList.add('active');
  });
});

// Insert text at cursor
function insertAtCursor(myField, myValue) {
  if (document.selection) {
    myField.focus();
    let sel = document.selection.createRange();
    sel.text = myValue;
  } else if (myField.selectionStart || myField.selectionStart === 0) {
    let startPos = myField.selectionStart;
    let endPos = myField.selectionEnd;
    myField.value = myField.value.substring(0, startPos)
      + myValue
      + myField.value.substring(endPos, myField.value.length);
    myField.selectionStart = myField.selectionEnd = startPos + myValue.length;
  } else {
    myField.value += myValue;
  }
  myField.focus();
}

// Handle BBCode buttons
document.querySelectorAll('.bb-buttons button').forEach(btn => {
  btn.addEventListener('click', () => {
    insertAtCursor(document.getElementById('replyBox'), btn.dataset.bb);
  });
});

// Handle Emoji clicks
document.querySelectorAll('.emoji-grid span').forEach(span => {
  span.addEventListener('click', () => {
    insertAtCursor(document.getElementById('replyBox'), span.textContent);
  });
});
</script>

</div>
<?php endif; ?>

<?php require_once __DIR__ . '/footer.php'; ?>
