<?php
require_once __DIR__ . '/header.php';
require_once __DIR__ . '/pagination.php';
$d = load_data();
$q = trim($_GET['q'] ?? '');
$page = max(1, (int)($_GET['page'] ?? 1));
$per = 20;

// filter
$topics = array_values($d['topics']);
if ($q !== '') {
    $topics = array_values(array_filter($topics, function($t) use ($q){
        return stripos($t['title'], $q) !== false;
    }));
}

// sort sticky first, then updated desc
usort($topics, function($a,$b){
    if (($b['sticky']??false) != ($a['sticky']??false)) return ($b['sticky']??false) <=> ($a['sticky']??false);
    return ($b['updated_at']??0) <=> ($a['updated_at']??0);
});

$total = max(1, (int)ceil(count($topics)/$per));
$offset = ($page-1)*$per;
$topics = array_slice($topics, $offset, $per);
?>
<div class="card">
<h2>Search</h2>
  <form class="row" method="get">
    <input type="text" name="q" value="<?php echo h($q); ?>" placeholder="Search topics">
    <button class="btn">Search</button>
  </form>
   <h2>Topics</h2>
     <?php if (empty($topics)): ?>
    <div class="muted">No topics yet.</div>
    <?php endif; ?>
  <?php foreach ($topics as $t): ?>
    <div class="topic badges">
      <a href="posts.php?id=<?php echo h($t['id']); ?>"><strong><?php echo h($t['title']); ?></strong></a>
        <?php if (!empty($t['sticky'])): ?><span>Sticky</span><?php endif; ?>
        <?php if (!empty($t['closed'])): ?><span>Closed</span><?php endif; ?>
      <div class="muted"><br><span>by <?php $au = $d['users'][$t['author_id']]['username'] ?? 'Unknown'; echo h($au); ?>
        • replies <?php echo (int)($t['replies'] ?? 0); ?> • updated <?php echo date('Y-m-d H:i', $t['updated_at']); ?></span></div>
    </div>
  <?php endforeach; ?>
  <?php render_pagination($page, $total, 'topics.php'.($q!==''?('?q='.urlencode($q)):"")); ?>
</div>
<?php require_once __DIR__ . '/footer.php'; ?>
