<?php
header('Content-Type: application/json');

$id = isset($_POST['id']) ? $_POST['id'] : null;
$stars = isset($_POST['stars']) ? intval($_POST['stars']) : 0;

if (!$id || $stars < 1 || $stars > 5) {
    echo json_encode(['status' => 'error', 'message' => 'Invalid input']);
    exit;
}

$ip = $_SERVER['REMOTE_ADDR'];
$file = 'data.json';

// Load existing data
if (file_exists($file)) {
    $data = json_decode(file_get_contents($file), true);
} else {
    $data = [];
}

// Initialize item if not exists
if (!isset($data[$id])) {
    $data[$id] = ['votes' => [], 'total' => 0, 'count' => 0];
}

// Check if IP already voted
foreach ($data[$id]['votes'] as $vote) {
    if ($vote['ip'] === $ip) {
        echo json_encode(['status' => 'error', 'message' => 'You already voted']);
        exit;
    }
}

// Save vote
$data[$id]['votes'][] = ['ip' => $ip, 'stars' => $stars];
$data[$id]['total'] += $stars;
$data[$id]['count']++;

// Save back to file
file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));

// Return average
$average = round($data[$id]['total'] / $data[$id]['count'], 2);
echo json_encode(['status' => 'success', 'average' => $average, 'count' => $data[$id]['count']]);
?>

