<?php
header('Content-Type: text/html; charset=utf-8');

// Simple BBCode parser
function parse_bbcodes($text) {
    // Basic tags
    $replacements = [
        '/\[b\](.*?)\[\/b\]/is' => '<b>$1</b>',
        '/\[i\](.*?)\[\/i\]/is' => '<i>$1</i>',
        '/\[u\](.*?)\[\/u\]/is' => '<u>$1</u>',
        '/\[s\](.*?)\[\/s\]/is' => '<s>$1</s>',
        '/\[url\](.*?)\[\/url\]/is' => '<a href="$1">$1</a>',
        '/\[quote\](.*?)\[\/quote\]/is' => '<fieldset><legend>QUOTE</legend>$1</fieldset>',
        '/\[img\](.*?)\[\/img\]/is' => '<img style="width:100%;" src="$1">',
        '/\[youtube\](.*?)\[\/youtube\]/is' => '<iframe width="100%" height="100%" src="https://www.youtube.com/embed/$1" frameborder="0" allowfullscreen></iframe>',
    ];

    foreach ($replacements as $pat => $rep) {
        $text = preg_replace($pat, $rep, $text);
    }

    // Links with attributes safely escaped
    $text = preg_replace_callback('/\[url=(.*?)\](.*?)\[\/url\]/is', function($m) {
        $url = filter_var($m[1], FILTER_SANITIZE_URL);
        if (!preg_match('#^https?://#i', $url)) return $m[2];
        return '<a rel="nofollow noopener" target="_blank" href="'.htmlspecialchars($url,ENT_QUOTES,'UTF-8').'">'.$m[2].'</a>';
    }, $text);

    // Convert newlines to <br>
    $text = nl2br($text);

    return $text;
}

