<?php
$ipFile = __DIR__ . "/ip.json";
$data = json_decode(file_get_contents($ipFile), true);
$blocked = $data['blocked'] ?? [];

$action = $_GET['action'] ?? '';
$ip = $_GET['ip'] ?? '';

if ($ip && filter_var($ip, FILTER_VALIDATE_IP)) {
    if ($action === 'block' && !in_array($ip, $blocked)) {
        $data['blocked'][] = $ip;
    } elseif ($action === 'unblock' && in_array($ip, $blocked)) {
        $data['blocked'] = array_values(array_diff($blocked, [$ip]));
    }
    file_put_contents($ipFile, json_encode($data, JSON_PRETTY_PRINT));
}

// Redirect back to admin
header("Location: admin.php");
exit;
?>

