<?php
require_once __DIR__ . '/header.php';
$me = current_user();
$error = '';
if ($_SERVER['REQUEST_METHOD']==='POST') {
    $title = trim($_POST['title'] ?? '');
    $content = trim($_POST['content'] ?? '');
    if ($title === '' || $content === '') {
        $error = 'Title and content are required.';
    } else {
        $d = load_data();
        $id = next_topic_id($d);
        $d['topics'][$id] = [
            'id'=>$id, 'title'=>$title, 'author_id'=>$me['id'], 'author_ip'=>ip(),
            'created_at'=>now(), 'updated_at'=>now(), 'closed'=>false, 'sticky'=>false, 'replies'=>0
        ];
        $pid = next_post_id($d);
        $d['posts'][$pid] = [
            'id'=>$pid, 'topic_id'=>$id, 'content'=>$content, 'author_id'=>$me['id'], 'author_ip'=>ip(),
            'created_at'=>now(), 'updated_at'=>now()
        ];
        save_data($d);
        header('Location: posts.php?id='.$id);
        exit;
    }
}
?>
<?php if ($error): ?><div class="card"><?php echo h($error); ?></div><?php endif; ?>
<div class="card">
  <h2>Create Topic</h2>

<style>
/* Panel styling */
.bb-emoji-panel {
  background: #111;
  color: #fff;
  border-radius: 8px;
  margin-bottom: 10px;
  padding: 5px;
  font-family: sans-serif;
}

/* Tabs */
.tab-buttons {
  display: flex;
  border-bottom: 1px solid #444;
}
.tab-buttons button {
  flex: 1;
  padding: 8px;
  background: #222;
  color: #ccc;
  border: none;
  cursor: pointer;
}
.tab-buttons button.active {
  background: #000;
  color: #fff;
  font-weight: bold;
}

/* Tab content */
.tab-content {
  display: none;
  padding: 8px;
}
.tab-content.active {
  display: block;
}

/* BBCode buttons */
.bb-buttons button {
  margin: 3px;
  padding: 5px 10px;
  background: #333;
  color: #fff;
  border: none;
  cursor: pointer;
  border-radius: 4px;
}
.bb-buttons button:hover {
  background: #555;
}

/* Emoji grid */
.emoji-grid {
  display: flex;
  flex-wrap: wrap;
  gap: 5px;
}
.emoji-grid span {
  cursor: pointer;
  font-size: 20px;
  padding: 5px;
  border-radius: 4px;
}
.emoji-grid span:hover {
  background: #444;
}
</style>

  <form class="row" method="post">
    <input type="text" name="title" placeholder="Title">
    
<div class="bb-emoji-panel">
  <div class="tab-buttons">
    <button type="button" class="tab-btn active" data-tab="bbcodes">BB Codes</button>
    <button type="button" class="tab-btn" data-tab="emojis">Emojis</button>
  </div>

  <!-- BBCode tab -->
  <div id="bbcodes" class="tab-content active">
    <div class="bb-buttons">
      <button type="button" data-bb="[b][/b]"><b>B</b></button>
      <button type="button" data-bb="[i][/i]"><i>I</i></button>
      <button type="button" data-bb="[u][/u]"><u>U</u></button>
      <button type="button" data-bb="[s][/s]"><s>S</s></button>
      <button type="button" data-bb="[url][/url]"><font color="blue">URL</font></button>
      <button type="button" data-bb="[quote][/quote]"><font color="gray">QUOTE</font></button>
      <button type="button" data-bb="[img][/img]"><font color="green"><b>IMG</b></font></button>
      <button type="button" data-bb="[youtube][/youtube]"><font color="red"><b>You</b></font>Tube</button>
    </div>
  </div>

  <!-- Emoji tab -->
  <div id="emojis" class="tab-content">
    <div class="emoji-grid">
<!-- Happy / Positive -->
<span>😀</span> <span>😁</span> <span>😂</span> <span>🤣</span> <span>😊</span> <span>😇</span> <span>😍</span> <span>🥰</span> <span>😘</span> <span>😋</span> <span>😎</span> <span>🤩</span>

<!-- Sad / Negative -->
<span>😞</span> <span>😔</span> <span>😟</span> <span>😢</span> <span>😭</span> <span>😩</span> <span>😫</span> <span>🥺</span> <span>😖</span> <span>☹️</span> <span>🙁</span> <span>😓</span>

<!-- Angry / Frustrated -->
<span>😠</span> <span>😡</span> <span>🤬</span> <span>😤</span> <span>😣</span> <span>🤯</span>

<!-- Love / Affection -->
<span>❤️</span> <span>💛</span> <span>💚</span> <span>💙</span> <span>💜</span> <span>🖤</span> <span>🤎</span> <span>🤍</span> <span>💔</span> <span>❣️</span> <span>💕</span> <span>💞</span> <span>💓</span> <span>💗</span> <span>💖</span> <span>💘</span> <span>💝</span> <span>💟</span>

<!-- Surprise / Shock -->
<span>😲</span> <span>😯</span> <span>😮</span> <span>😳</span> <span>🥵</span> <span>🥶</span> <span>🤯</span> <span>😱</span>

<!-- Neutral / Thinking -->
<span>😐</span> <span>😑</span> <span>😶</span> <span>😏</span> <span>🤔</span> <span>🤨</span> <span>😬</span> <span>🙄</span>

<!-- Sleepy / Sick -->
<span>😴</span> <span>🥱</span> <span>🤤</span> <span>🤢</span> <span>🤮</span> <span>🤧</span> <span>🤒</span> <span>🤕</span>

<!-- Funny / Playful -->
<span>😜</span> <span>😝</span> <span>😛</span> <span>🤪</span> <span>🥳</span> <span>🫨</span>

<!-- Other Reactions -->
<span>🙏</span> <span>🤝</span> <span>👍</span> <span>👎</span> <span>👏</span> <span>🙌</span> <span>🤲</span> <span>🤗</span> <span>🤭</span> <span>🤫</span> <span>😶‍🌫️</span>

    </div>
  </div>
</div>


    <textarea id="topicBox" name="content" rows="6" placeholder="Content"></textarea>
    <button class="btn">Create</button>
  </form>

<script>
// Tabs switching
document.querySelectorAll('.tab-btn').forEach(btn => {
  btn.addEventListener('click', () => {
    document.querySelectorAll('.tab-btn').forEach(b => b.classList.remove('active'));
    document.querySelectorAll('.tab-content').forEach(tc => tc.classList.remove('active'));
    btn.classList.add('active');
    document.getElementById(btn.dataset.tab).classList.add('active');
  });
});

// Insert text at cursor
function insertAtCursor(myField, myValue) {
  if (document.selection) {
    myField.focus();
    let sel = document.selection.createRange();
    sel.text = myValue;
  } else if (myField.selectionStart || myField.selectionStart === 0) {
    let startPos = myField.selectionStart;
    let endPos = myField.selectionEnd;
    myField.value = myField.value.substring(0, startPos)
      + myValue
      + myField.value.substring(endPos, myField.value.length);
    myField.selectionStart = myField.selectionEnd = startPos + myValue.length;
  } else {
    myField.value += myValue;
  }
  myField.focus();
}

// Handle BBCode buttons
document.querySelectorAll('.bb-buttons button').forEach(btn => {
  btn.addEventListener('click', () => {
    insertAtCursor(document.getElementById('topicBox'), btn.dataset.bb);
  });
});

// Handle Emoji clicks
document.querySelectorAll('.emoji-grid span').forEach(span => {
  span.addEventListener('click', () => {
    insertAtCursor(document.getElementById('topicBox'), span.textContent);
  });
});
</script>

</div>
<?php require_once __DIR__ . '/footer.php'; ?>
