<?php
require_once __DIR__ . '/header.php';
$me = current_user();
$d = load_data();
$type = $_GET['type'] ?? '';
$id = (string)($_GET['id'] ?? '');
$error='';

if ($type==='post' && isset($d['posts'][$id])) {
    $item = $d['posts'][$id];
    $owner = $item['author_id'] ?? '';
    if (!is_admin() && $owner !== $me['id']) { echo '<div class="card">Not allowed.</div>'; require 'footer.php'; exit; }
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $content = trim($_POST['content'] ?? '');
        if ($content==='') $error='Content required.';
        else {
            $d['posts'][$id]['content']=$content;
            $d['posts'][$id]['updated_at']=now();
            save_data($d);
            header('Location: posts.php?id='.$item['topic_id'].'#p'.$id);
            exit;
        }
    }
    ?>
    <div class="card">
      <h2>Edit Post</h2>
      <?php if ($error): ?><div class="muted"><?php echo h($error); ?></div><?php endif; ?>
      <form class="row" method="post">
        <textarea name="content" rows="8"><?php echo h($item['content']); ?></textarea>
        <button class="btn">Save</button>
      </form>
    </div>
    <?php
} elseif ($type==='topic' && isset($d['topics'][$id])) {
    $item = $d['topics'][$id];
    $owner = $item['author_id'] ?? '';
    if (!is_admin() && $owner !== $me['id']) { echo '<div class="card">Not allowed.</div>'; require 'footer.php'; exit; }
    if ($_SERVER['REQUEST_METHOD']==='POST') {
        $title = trim($_POST['title'] ?? '');
        if ($title==='') $error='Title required.';
        else {
            $d['topics'][$id]['title']=$title;
            $d['topics'][$id]['updated_at']=now();
            save_data($d);
            header('Location: posts.php?id='.$id);
            exit;
        }
    }
    ?>
    <div class="card">
      <h2>Edit Topic</h2>
      <?php if ($error): ?><div class="muted"><?php echo h($error); ?></div><?php endif; ?>
      <form class="row" method="post">
        <input type="text" name="title" value="<?php echo h($item['title']); ?>">
        <button class="btn">Save</button>
      </form>
    </div>
    <?php
} else {
    echo '<div class="card">Item not found.</div>';
}
require_once __DIR__ . '/footer.php';
