<?php
function getUserIP() {
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        return $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        return explode(',', $_SERVER['HTTP_X_FORWARDED_FOR'])[0];
    } else {
        return $_SERVER['REMOTE_ADDR'];
    }
}

$ipFile = __DIR__ . "/ip.json";
$data = json_decode(file_get_contents($ipFile), true);

$userIP = getUserIP();

if (in_array($userIP, $data['blocked'])) {
    // Hide or block access
    header("HTTP/1.1 403 Forbidden");
    exit("🚫 Access Denied – Your IP ($userIP) is blocked.");
}
?>

