<?php include "header.php"; ?>

<script>
function insertText(text) {
    const to = document.getElementById("to");
    
    // Insert text at cursor position
    const start = to.selectionStart;
    const end = to.selectionEnd;
    const before = to.value.substring(0, start);
    const after = to.value.substring(end);
    
    to.value = before + text + after;
    
    // Move cursor to after inserted text
    to.selectionStart = to.selectionEnd = start + text.length;
    to.focus();
}
</script>

<div class="card">
<form class="row">
<h2>Send Message</h2>
<input type="text" id="to" placeholder="IP">
<textarea id="message" rows="6" placeholder="Message"></textarea>
<button class="btn" onclick="sendMessage()">Send</button>
</form>

<h2>Inbox</h2>

</div>
<div id="inbox"></div>
</div>
<script>
async function sendMessage() {
    const to = document.getElementById('to').value;
    const message = document.getElementById('message').value;
    if(!to || !message) return alert('Please fill all fields.');
    
    const res = await fetch('pm.php?action=send', {
        method: 'POST',
        body: new URLSearchParams({to, message})
    });
    const data = await res.json();
    alert(data.status === 'success' ? 'Message sent!' : 'Error sending message');
    loadInbox();
}

async function loadInbox() {
    const res = await fetch('pm.php?action=inbox');
    const messages = await res.json();
    const inbox = document.getElementById('inbox');
    inbox.innerHTML = '';
    messages.forEach((msg, i) => {
        const div = document.createElement('div');
        div.className = 'message';
        div.innerHTML = `<div class="card"><div class="badges topic"><span>From: ${msg.from}, ${new Date(msg.time*1000).toLocaleString()}</span><p>${msg.message}</p></div><br>
        <a class="btn small secondary" href="#to" onclick="insertText('${msg.from}')">Reply</a><button class="btn danger" onclick="deleteMessage(${i})">Delete</button></div>`;
        inbox.appendChild(div);
    });
}

async function deleteMessage(index) {
    const res = await fetch('pm.php?action=delete', {
        method: 'POST',
        body: new URLSearchParams({index})
    });
    const data = await res.json();
    alert(data.status === 'deleted' ? 'Deleted!' : 'Error deleting');
    loadInbox();
}

// Load inbox on page load
loadInbox();
</script>
<?php include "footer.php"; ?>

