<?php
function render_pagination($current, $total, $base) {
    if ($total <= 1) return;
    echo '<div class="pagination">';
    // Previous
    if ($current > 1) {
        echo '<a href="'.h($base).(strpos($base,'?')===false?'?':'&').'page='.($current-1).'">&laquo; Prev</a>';
    }
    // First 3
    for ($i=1;$i<=min(3,$total);$i++) {
        $cls = $i===$current ? 'class="current"' : '';
        echo '<a '.$cls.' href="'.h($base).(strpos($base,'?')===false?'?':'&').'page='.$i.'">'.$i.'</a>';
    }
    // Ellipsis mid
    if ($total > 6 && $current > 4) echo '<span>…</span>';
    // Window around current
    $start = max(4, $current-1);
    $end = min($total-3, $current+1);
    for ($i=$start; $i<=$end; $i++) {
        $cls = $i===$current ? 'class="current"' : '';
        echo '<a '.$cls.' href="'.h($base).(strpos($base,'?')===false?'?':'&').'page='.$i.'">'.$i.'</a>';
    }
    // Ellipsis before last
    if ($total > 6 && $current < $total-3) echo '<span>…</span>';
    // Last 3
    for ($i=max($total-2,4); $i<=$total; $i++) {
        if ($i<4) continue;
        $cls = $i===$current ? 'class="current"' : '';
        echo '<a '.$cls.' href="'.h($base).(strpos($base,'?')===false?'?':'&').'page='.$i.'">'.$i.'</a>';
    }
    // Next
    if ($current < $total) {
        echo '<a href="'.h($base).(strpos($base,'?')===false?'?':'&').'page='.($current+1).'">Next &raquo;</a>';
    }
    echo '</div>';
}
