<?php
header('Content-Type: application/json');

$ip = $_SERVER['REMOTE_ADDR'];
$file = 'messages.json';

// Load existing messages
$messages = file_exists($file) ? json_decode(file_get_contents($file), true) : [];

// Ensure structure
if (!isset($messages[$ip])) $messages[$ip] = [];

$action = $_GET['action'] ?? '';

if ($action === 'send') {
    $to = $_POST['to'] ?? '';
    $msg = $_POST['message'] ?? '';
    if ($to && $msg) {
        if (!isset($messages[$to])) $messages[$to] = [];
        $messages[$to][] = [
            'from' => $ip,
            'message' => $msg,
            'time' => time()
        ];
        // Limit to 50 messages per user
        if (count($messages[$to]) > 50) array_shift($messages[$to]);
        file_put_contents($file, json_encode($messages, JSON_PRETTY_PRINT));
        echo json_encode(['status' => 'success']);
        exit;
    }
} elseif ($action === 'inbox') {
    echo json_encode($messages[$ip]);
    exit;
} elseif ($action === 'delete') {
    $index = $_POST['index'] ?? null;
    if (isset($messages[$ip][$index])) {
        array_splice($messages[$ip], $index, 1);
        file_put_contents($file, json_encode($messages, JSON_PRETTY_PRINT));
        echo json_encode(['status' => 'deleted']);
        exit;
    }
}

echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
?>

