<?php
require_once __DIR__ . '/header.php';
require_once __DIR__ . '/pagination.php';
$d = load_data();
$q = trim($_GET['q'] ?? '');
$page = max(1,(int)($_GET['page']??1));
$per = 20;

$matches = [];
if ($q!=='') {
    foreach ($d['topics'] as $t) {
        if (stripos($t['title'],$q)!==false) $matches[] = ['type'=>'topic','title'=>$t['title'],'id'=>$t['id'],'snippet'=>''];
    }
    foreach ($d['posts'] as $p) {
        if (stripos($p['content'],$q)!==false) {
            $snippet = substr($p['content'], max(0, stripos($p['content'],$q)-20), 80);
            $matches[] = ['type'=>'post','title'=>'Post in topic #'.$p['topic_id'],'id'=>$p['id'],'topic_id'=>$p['topic_id'],'snippet'=>$snippet];
        }
    }
}

$total = max(1,(int)ceil(count($matches)/$per));
$offset = ($page-1)*$per;
$items = array_slice($matches, $offset, $per);
?>
<div class="card">
  <h2>Search</h2>
  <form class="row" method="get">
    <input type="text" name="q" value="<?php echo h($q); ?>" placeholder="Search topics & posts">
    <button class="btn">Search</button>
  </form>
  <?php if ($q===''): ?>
    
  <?php else: ?>
    <div class='card'><?php echo count($matches); ?> results for "<strong><?php echo h($q); ?></strong>"</div>
    <?php foreach ($items as $it): ?>
      <div class="topic">
        <?php if ($it['type']==='topic'): ?>
          <a href="posts.php?id=<?php echo h($it['id']); ?>"><strong><?php echo h($it['title']); ?></strong></a>
        <?php else: ?>
          <a href="posts.php?id=<?php echo h($it['topic_id']); ?>#p<?php echo h($it['id']); ?>"><strong><?php echo h($it['title']); ?></strong></a>
          <div class="muted"><?php echo h($it['snippet']); ?></div>
        <?php endif; ?>
      </div>
    <?php endforeach; ?>
    <?php render_pagination($page,$total,'search.php?q='.urlencode($q)); ?>
  <?php endif; ?>
</div>
<?php require_once __DIR__ . '/footer.php'; ?>
