using System;
using System.Collections.Generic;
using System.Text;
using System.IO;
using System.Security.Cryptography;
using System.Security.Cryptography.X509Certificates;
using CryptoManager;
using System.Runtime.InteropServices;
using System.Net;
using System.Web;

namespace DataSender
{
    class Program
    {
        static void Main(string[] args)
        {
            StreamReader sprivate = new StreamReader("key.pem");
            String privateKey = sprivate.ReadToEnd().ToString();
            sprivate.Close();

            StreamReader spublic = new StreamReader("certificate.cer");
            String publicKey = spublic.ReadToEnd().ToString();
            spublic.Close();

            Console.WriteLine("INPUT DATA TO SEND");
            Console.WriteLine("---------------------------------------------------------------------------");

            byte[] data = System.Text.ASCIIEncoding.ASCII.GetBytes(Console.ReadLine());

            Console.WriteLine("---------------------------------------------------------------------------");
            Console.WriteLine();
            Console.WriteLine();

            Console.WriteLine("CALCULATING HASH");
            Console.WriteLine("---------------------------------------------------------------------------");

            SHA1CryptoServiceProvider sha = new SHA1CryptoServiceProvider();
            byte[] hashedData = sha.ComputeHash(data);
            Console.WriteLine(Convert.ToBase64String(hashedData));
            RSACryptoServiceProvider rsa = new RSACryptoServiceProvider();
            rsa.FromXmlString(OpenSSSL.DecodePEMKey(privateKey, ""));
            Console.WriteLine("---------------------------------------------------------------------------");
            Console.WriteLine();
            Console.WriteLine();

            Console.WriteLine("CALCULATING SIGNATURE");
            Console.WriteLine("---------------------------------------------------------------------------");

            byte[] signature = rsa.SignHash(hashedData, CryptoConfig.MapNameToOID("SHA1"));
            Console.WriteLine(Convert.ToBase64String(signature));
            StreamWriter sw = new StreamWriter("signature.txt");
            sw.WriteLine(Convert.ToBase64String(signature));
            sw.Close();

            Console.WriteLine("---------------------------------------------------------------------------");
            Console.WriteLine();
            Console.WriteLine();


            Console.WriteLine("STARTING LOCAL VERIFICATION");
            Console.WriteLine("---------------------------------------------------------------------------");

            X509Certificate cert = new X509Certificate(System.Text.ASCIIEncoding.ASCII.GetBytes(publicKey));
            RSACryptoServiceProvider validate = OpenSSSL.GetPublicKeyFromX509Certificate(cert);
            Console.WriteLine(validate.VerifyData(data, CryptoConfig.MapNameToOID("SHA1"), signature).ToString());

            Console.WriteLine("---------------------------------------------------------------------------");
            Console.WriteLine();
            Console.WriteLine();



            Console.WriteLine("STARTING REMOTE VERIFICATION");
            Console.WriteLine("---------------------------------------------------------------------------");


            string uri = "http://localhost:35585/index.php?data=" + System.Text.ASCIIEncoding.ASCII.GetString(data) + "&signature=" + HttpUtility.UrlEncode(Convert.ToBase64String(signature));
            WebRequest request;
            request = WebRequest.Create(uri);
            WebResponse response;
            request.Method = "GET";
            response = request.GetResponse();
            StreamReader s = new StreamReader(response.GetResponseStream());
            Console.Write(s.ReadToEnd());
            Console.WriteLine();
            Console.WriteLine("---------------------------------------------------------------------------");
            Console.WriteLine();
            Console.WriteLine();

            Console.WriteLine("PRESS ANY KEY TO EXIT");

            Console.ReadLine();

        }
    }
}
